/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.dialog;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.vafada.swtcalendar.SWTCalendar;
import org.vafada.swtcalendar.SWTCalendarEvent;
import org.vafada.swtcalendar.SWTCalendarListener;

public class CalendarDialog
extends CommonDialog {
    private SWTCalendar swtcal = null;
    private Date dateBuffer;
    private Date dateBefore;
    private Date date;

    public CalendarDialog(Shell parent) {
        super(parent);
    }

    @Override
    protected void customizeDialog(Composite composite) {
        composite.getShell().setText(Messages.getString((String)"calendar"));
        GridLayout gridLayout = new GridLayout(1, true);
        composite.setLayout((Layout)gridLayout);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        this.swtcal = new SWTCalendar(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.swtcal.setLayoutData(gridData);
        this.swtcal.addSWTCalendarListener(new SWTCalendarListener(){

            @Override
            public void dateChanged(SWTCalendarEvent calendarEvent) {
                CalendarDialog.this.dateBuffer = calendarEvent.getCalendar().getTime();
            }
        });
        if (this.dateBefore != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.dateBefore);
            this.swtcal.setCalendar(calendar);
        }
    }

    public void setDate(Date date) {
        this.dateBefore = date;
    }

    public Date getDate() {
        return this.date;
    }

    protected void cancelPressed() {
        this.date = this.dateBefore;
        super.cancelPressed();
    }

    @Override
    protected void okPressed() {
        if (this.dateBuffer != null) {
            this.date = this.dateBuffer;
        }
        super.okPressed();
    }

    @Override
    protected ValidateResult validate() {
        return null;
    }
}

