/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.editor;

import com.clustercontrol.bean.Property;
import com.clustercontrol.editor.PropertyDefine;
import com.clustercontrol.util.Messages;
import java.io.Serializable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TextCellEditor;

public class IntegerPropertyDefine
extends PropertyDefine
implements Serializable {
    private static final long serialVersionUID = 3562301924650606249L;

    public IntegerPropertyDefine() {
        this.m_cellEditor = new TextCellEditor();
    }

    @Override
    public String getColumnText(Object value) {
        if (value instanceof Integer) {
            return value.toString();
        }
        return "";
    }

    @Override
    public Object getValue(Property element) {
        Object value = element.getValue();
        if (value instanceof Integer) {
            return value.toString();
        }
        return "";
    }

    @Override
    public void modify(Property element, Object value) {
        try {
            if (((String)value).length() == 0) {
                element.setValue("");
            } else if (element.getLowerBound() <= Integer.parseInt((String)value) && Integer.parseInt((String)value) <= element.getUpperBound()) {
                Integer check = new Integer((String)value);
                element.setValue(check);
            } else {
                Object[] args = new String[]{String.valueOf(element.getLowerBound()), String.valueOf(element.getUpperBound())};
                MessageDialog.openWarning(null, (String)Messages.getString((String)"message.hinemos.1"), (String)Messages.getString((String)"message.hinemos.8", (Object[])args));
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    @Override
    public void initEditer() {
    }
}

