/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.accesscontrol.util.LocalSession;
import com.clustercontrol.jobmanagement.action.GetJobDetailTableDefine;
import com.clustercontrol.jobmanagement.composite.action.JobDetailSelectionChangedListener;
import com.clustercontrol.jobmanagement.composite.action.SessionJobDoubleClickListener;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.jobmanagement.viewer.JobTableTreeViewer;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.JobInfo;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class DetailComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(DetailComposite.class);
    private JobTableTreeViewer m_viewer = null;
    private String m_sessionId = null;
    private String m_jobunitId = null;
    private String m_jobId = null;
    private Label m_sessionIdLabel = null;

    public DetailComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_sessionIdLabel = new Label((Composite)this, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.m_sessionIdLabel.setLayoutData((Object)gridData);
        TableTree tree = new TableTree((Composite)this, 66308);
        Table table = tree.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        tree.setLayoutData((Object)gridData);
        this.m_viewer = new JobTableTreeViewer(tree);
        this.m_viewer.createTableColumn(GetJobDetailTableDefine.get(), 4, 1);
        this.m_viewer.addSelectionChangedListener(new JobDetailSelectionChangedListener(this));
        this.m_viewer.addDoubleClickListener(new SessionJobDoubleClickListener(this));
        this.update(null, null);
    }

    public void update(String sessionId, String jobunitId) {
        JobTreeItem item;
        block10: {
            item = null;
            if (sessionId != null && sessionId.length() > 0) {
                try {
                    item = JobEndpointWrapper.getJobDetailList(sessionId);
                }
                catch (InvalidRole_Exception invalidRole_Exception) {
                    if (LocalSession.isDialogFlag()) {
                        LocalSession.setDialogFlag(false);
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                        LocalSession.setDialogFlag(true);
                    }
                }
                catch (Exception e) {
                    m_log.warn((Object)("update() getJobDetailList, " + e.getMessage()), (Throwable)e);
                    if (!LocalSession.isDialogFlag()) break block10;
                    LocalSession.setDialogFlag(false);
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
                    LocalSession.setDialogFlag(true);
                }
            }
        }
        if (item == null) {
            return;
        }
        this.m_viewer.setInput(item);
        this.m_viewer.expandAll();
        if (this.m_sessionId != null && this.m_sessionId.length() > 0 && sessionId != null && sessionId.length() > 0 && this.m_sessionId.compareTo(sessionId) == 0) {
            this.selectDetail((JobTreeItem)item.getChildren().get(0));
        } else {
            this.setJobId(null);
        }
        this.m_sessionId = sessionId;
        this.m_jobunitId = jobunitId;
        if (this.m_sessionId != null) {
            this.m_sessionIdLabel.setText(String.valueOf(Messages.getString((String)"session.id")) + " : " + this.m_sessionId);
        } else {
            this.m_sessionIdLabel.setText(String.valueOf(Messages.getString((String)"session.id")) + " : ");
        }
    }

    public void selectDetail(JobTreeItem item) {
        if (this.getJobId() != null && this.getJobId().length() > 0 && this.m_viewer.getSelection().isEmpty()) {
            boolean select = false;
            JobInfo info = item.getData();
            if (info == null) {
                m_log.info((Object)"selectDetail info is null");
                return;
            }
            String jobId = info.getId();
            if (this.getJobId().compareTo(jobId) == 0) {
                select = true;
            }
            if (select) {
                this.m_viewer.setSelection((ISelection)new StructuredSelection((Object)item), true);
            } else {
                int i = 0;
                while (i < item.getChildren().size()) {
                    JobTreeItem children = (JobTreeItem)item.getChildren().get(i);
                    this.selectDetail(children);
                    ++i;
                }
            }
        }
    }

    public TableTreeViewer getTableTreeViewer() {
        return this.m_viewer;
    }

    public Table getTable() {
        return this.m_viewer.getTableTree().getTable();
    }

    public TableTree getTableTree() {
        return this.m_viewer.getTableTree();
    }

    public String getSessionId() {
        return this.m_sessionId;
    }

    public void setSessionId(String sessionId) {
        this.m_sessionId = sessionId;
    }

    public String getJobId() {
        return this.m_jobId;
    }

    public void setJobId(String jobId) {
        this.m_jobId = jobId;
    }

    public String getJobunitId() {
        return this.m_jobunitId;
    }

    public void setJobunitId(String jobunitId) {
        this.m_jobunitId = jobunitId;
    }
}

