/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.action.NumberVerifyListener;
import com.clustercontrol.composite.action.StringVerifyListener;
import com.clustercontrol.dialog.ScopeTreeDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.repository.FacilityPath;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.JobFileInfo;
import com.clustercontrol.ws.repository.FacilityInfo;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FileComposite
extends Composite {
    private Text m_srcScope = null;
    private Text m_srcFile = null;
    private Text m_destScope = null;
    private Text m_destDirectory = null;
    private Button m_agentUser = null;
    private Button m_specifyUser = null;
    private Text m_user = null;
    private Button m_srcScopeSelect = null;
    private Button m_destScopeSelect = null;
    private Button m_allNode = null;
    private Button m_oneNode = null;
    private Button m_compressionCondition = null;
    private Button m_checkFileCondition = null;
    private String m_srcFacilityId = null;
    private String m_srcFacilityPath = null;
    private String m_destFacilityId = null;
    private String m_destFacilityPath = null;
    private Group m_messageRetryGroup;
    private Text m_messageRetry;
    private JobFileInfo m_jobFileInfo = null;
    private Shell m_shell = null;
    private String m_ownerRoleId = null;

    public FileComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
        this.m_shell = this.getShell();
    }

    private void initialize() {
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.spacing = 1;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.fill = true;
        this.setLayout((Layout)layout);
        Composite composite = null;
        RowLayout rowLayout = null;
        Group group = new Group((Composite)this, 0);
        group.setText(Messages.getString((String)"forward.source"));
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 10;
        rowLayout.marginHeight = 10;
        group.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label srcScopeTitle = new Label(composite, 0);
        srcScopeTitle.setText(String.valueOf(Messages.getString((String)"scope")) + " : ");
        srcScopeTitle.setLayoutData((Object)new RowData(100, 15));
        this.m_srcScope = new Text(composite, 2056);
        this.m_srcScope.setLayoutData((Object)new RowData(200, 15));
        this.m_srcScope.setText("");
        this.m_srcScope.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                FileComposite.this.update();
            }
        });
        this.m_srcScopeSelect = new Button(composite, 0);
        this.m_srcScopeSelect.setText(Messages.getString((String)"refer"));
        this.m_srcScopeSelect.setLayoutData((Object)new RowData(80, 22));
        this.m_srcScopeSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScopeTreeDialog dialog = new ScopeTreeDialog(FileComposite.this.m_shell, FileComposite.this.m_ownerRoleId);
                dialog.setSelectNodeOnly(true);
                if (dialog.open() == 0) {
                    FacilityTreeItem selectItem = dialog.getSelectItem();
                    FacilityInfo info = selectItem.getData();
                    FacilityPath path = new FacilityPath(ClusterControlPlugin.getDefault().getSeparator());
                    FileComposite.this.m_srcFacilityPath = path.getPath(selectItem);
                    FileComposite.this.m_srcFacilityId = info.getFacilityId();
                    FileComposite.this.m_srcScope.setText(FileComposite.this.m_srcFacilityPath);
                }
            }
        });
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label fileTitle = new Label(composite, 0);
        fileTitle.setText(String.valueOf(Messages.getString((String)"file")) + " : ");
        fileTitle.setLayoutData((Object)new RowData(100, 15));
        this.m_srcFile = new Text(composite, 2048);
        this.m_srcFile.setLayoutData((Object)new RowData(200, 15));
        this.m_srcFile.addVerifyListener((VerifyListener)new StringVerifyListener(4096));
        this.m_srcFile.setText("");
        this.m_srcFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                FileComposite.this.update();
            }
        });
        group = new Group((Composite)this, 0);
        group.setText(Messages.getString((String)"forward.destination"));
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 10;
        rowLayout.marginHeight = 10;
        group.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label destScopeTitle = new Label(composite, 0);
        destScopeTitle.setText(String.valueOf(Messages.getString((String)"scope")) + " : ");
        destScopeTitle.setLayoutData((Object)new RowData(100, 15));
        this.m_destScope = new Text(composite, 2056);
        this.m_destScope.setLayoutData((Object)new RowData(200, 15));
        this.m_destScope.setText("");
        this.m_destScope.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                FileComposite.this.update();
            }
        });
        this.m_destScopeSelect = new Button(composite, 0);
        this.m_destScopeSelect.setText(Messages.getString((String)"refer"));
        this.m_destScopeSelect.setLayoutData((Object)new RowData(80, 22));
        this.m_destScopeSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScopeTreeDialog dialog = new ScopeTreeDialog(FileComposite.this.m_shell, FileComposite.this.m_ownerRoleId);
                if (dialog.open() == 0) {
                    FacilityTreeItem selectItem = dialog.getSelectItem();
                    FacilityInfo info = selectItem.getData();
                    FacilityPath path = new FacilityPath(ClusterControlPlugin.getDefault().getSeparator());
                    FileComposite.this.m_destFacilityPath = path.getPath(selectItem);
                    FileComposite.this.m_destFacilityId = info.getFacilityId();
                    FileComposite.this.m_destScope.setText(FileComposite.this.m_destFacilityPath);
                }
            }
        });
        Group methodGroup = new Group((Composite)group, 0);
        methodGroup.setText(Messages.getString((String)"process.method"));
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.marginWidth = 10;
        rowLayout.marginHeight = 10;
        methodGroup.setLayout((Layout)rowLayout);
        this.m_allNode = new Button((Composite)methodGroup, 16);
        this.m_allNode.setText(Messages.getString((String)"forward.all.nodes"));
        this.m_allNode.setLayoutData((Object)new RowData(220, 22));
        this.m_oneNode = new Button((Composite)methodGroup, 16);
        this.m_oneNode.setText(Messages.getString((String)"forward.one.node"));
        this.m_oneNode.setLayoutData((Object)new RowData(250, 22));
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label forwardDirTitle = new Label(composite, 0);
        forwardDirTitle.setText(String.valueOf(Messages.getString((String)"directory")) + " : ");
        forwardDirTitle.setLayoutData((Object)new RowData(100, 15));
        this.m_destDirectory = new Text(composite, 2048);
        this.m_destDirectory.setLayoutData((Object)new RowData(200, 15));
        this.m_destDirectory.addVerifyListener((VerifyListener)new StringVerifyListener(4096));
        this.m_destDirectory.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                FileComposite.this.update();
            }
        });
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        composite.setLayout((Layout)rowLayout);
        this.m_compressionCondition = new Button(composite, 32);
        this.m_compressionCondition.setText(Messages.getString((String)"forward.compression.file"));
        this.m_compressionCondition.setLayoutData((Object)new RowData(220, 22));
        this.m_checkFileCondition = new Button(composite, 32);
        this.m_checkFileCondition.setText(Messages.getString((String)"forward.file.check"));
        this.m_checkFileCondition.setLayoutData((Object)new RowData(250, 22));
        group = new Group((Composite)this, 0);
        group.setText(Messages.getString((String)"effective.user"));
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 10;
        rowLayout.marginHeight = 10;
        group.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_agentUser = new Button(composite, 16);
        this.m_agentUser.setText(Messages.getString((String)"agent.user"));
        this.m_agentUser.setLayoutData((Object)new RowData(350, 22));
        this.m_agentUser.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    FileComposite.this.m_specifyUser.setSelection(false);
                    FileComposite.this.m_user.setEnabled(false);
                }
                FileComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_specifyUser = new Button(composite, 16);
        this.m_specifyUser.setText(Messages.getString((String)"specified.user"));
        this.m_specifyUser.setLayoutData((Object)new RowData(120, 22));
        this.m_specifyUser.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    FileComposite.this.m_agentUser.setSelection(false);
                    FileComposite.this.m_user.setEnabled(true);
                }
                FileComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_user = new Text(composite, 2048);
        this.m_user.setLayoutData((Object)new RowData(300, 15));
        this.m_user.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        this.m_user.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                FileComposite.this.update();
            }
        });
        this.m_messageRetryGroup = new Group((Composite)this, 0);
        this.m_messageRetryGroup.setText(Messages.getString((String)"job.timeout"));
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 5;
        rowLayout.marginHeight = 5;
        rowLayout.spacing = 1;
        this.m_messageRetryGroup.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)this.m_messageRetryGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        composite.setLayout((Layout)rowLayout);
        Label messageRetryTitle = new Label(composite, 16384);
        messageRetryTitle.setText(String.valueOf(Messages.getString((String)"job.retries")) + " : ");
        messageRetryTitle.setLayoutData((Object)new RowData(100, 15));
        this.m_messageRetry = new Text(composite, 2048);
        this.m_messageRetry.setLayoutData((Object)new RowData(300, 15));
        this.m_messageRetry.addVerifyListener((VerifyListener)new NumberVerifyListener(Short.MIN_VALUE, Short.MAX_VALUE));
        this.m_messageRetry.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                FileComposite.this.update();
            }
        });
    }

    public void update() {
        if ("".equals(this.m_srcScope.getText())) {
            this.m_srcScope.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_srcScope.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.m_srcFile.getText())) {
            this.m_srcFile.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_srcFile.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_specifyUser.getSelection() && "".equals(this.m_user.getText())) {
            this.m_user.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_user.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.m_destScope.getText())) {
            this.m_destScope.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_destScope.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.m_destDirectory.getText())) {
            this.m_destDirectory.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_destDirectory.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.m_messageRetry.getText())) {
            this.m_messageRetry.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_messageRetry.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    public void reflectFileInfo() {
        this.m_srcScope.setText("");
        this.m_srcFile.setText("");
        this.m_destScope.setText("");
        this.m_destDirectory.setText("");
        this.m_allNode.setSelection(true);
        this.m_compressionCondition.setSelection(false);
        this.m_checkFileCondition.setSelection(false);
        this.m_agentUser.setSelection(true);
        this.m_specifyUser.setSelection(false);
        this.m_user.setText("");
        this.m_user.setEnabled(false);
        this.m_messageRetry.setText("10");
        if (this.m_jobFileInfo != null) {
            this.m_srcFacilityPath = this.m_jobFileInfo.getSrcScope();
            this.m_srcFacilityId = this.m_jobFileInfo.getSrcFacilityID();
            if (this.m_srcFacilityPath != null && this.m_srcFacilityPath.length() > 0) {
                this.m_srcScope.setText(this.m_srcFacilityPath);
            }
            if (this.m_jobFileInfo.getSrcFile() != null && this.m_jobFileInfo.getSrcFile().length() > 0) {
                this.m_srcFile.setText(this.m_jobFileInfo.getSrcFile());
            }
            this.m_destFacilityPath = this.m_jobFileInfo.getDestScope();
            this.m_destFacilityId = this.m_jobFileInfo.getDestFacilityID();
            if (this.m_destFacilityPath != null && this.m_destFacilityPath.length() > 0) {
                this.m_destScope.setText(this.m_destFacilityPath);
            }
            if (this.m_jobFileInfo.getDestDirectory() != null && this.m_jobFileInfo.getDestDirectory().length() > 0) {
                this.m_destDirectory.setText(this.m_jobFileInfo.getDestDirectory());
            }
            if (this.m_jobFileInfo.getProcessingMethod() == 0) {
                this.m_allNode.setSelection(true);
                this.m_oneNode.setSelection(false);
            } else {
                this.m_allNode.setSelection(false);
                this.m_oneNode.setSelection(true);
            }
            this.m_compressionCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_jobFileInfo.getCompressionFlg()));
            this.m_checkFileCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_jobFileInfo.getCheckFlg()));
            if (this.m_jobFileInfo.getSpecifyUser() == 1) {
                this.m_specifyUser.setSelection(true);
                this.m_agentUser.setSelection(false);
                this.m_user.setEnabled(true);
            } else {
                this.m_specifyUser.setSelection(false);
                this.m_agentUser.setSelection(true);
                this.m_user.setEnabled(false);
            }
            if (this.m_jobFileInfo.getUser() != null && this.m_jobFileInfo.getUser().length() > 0) {
                this.m_user.setText(this.m_jobFileInfo.getUser());
            }
            this.m_messageRetry.setText(String.valueOf(this.m_jobFileInfo.getMessageRetry()));
        }
    }

    public void setFileInfo(JobFileInfo jobFileInfo) {
        this.m_jobFileInfo = jobFileInfo;
    }

    public JobFileInfo getFileInfo() {
        return this.m_jobFileInfo;
    }

    public ValidateResult createFileInfo() {
        ValidateResult result = null;
        this.m_jobFileInfo = new JobFileInfo();
        if (this.m_srcFacilityId == null || this.m_srcFacilityId.length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(String.valueOf(Messages.getString((String)"forward.source")) + Messages.getString((String)"message.hinemos.3"));
            return result;
        }
        this.m_jobFileInfo.setSrcFacilityID(this.m_srcFacilityId);
        this.m_jobFileInfo.setSrcScope(this.m_srcFacilityPath);
        if (this.m_srcFile.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(String.valueOf(Messages.getString((String)"forward.source")) + Messages.getString((String)"message.job.45"));
            return result;
        }
        this.m_jobFileInfo.setSrcFile(this.m_srcFile.getText());
        this.m_jobFileInfo.setSrcWorkDir("");
        if (this.m_destFacilityId == null || this.m_destFacilityId.length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(String.valueOf(Messages.getString((String)"forward.destination")) + Messages.getString((String)"message.hinemos.3"));
            return result;
        }
        this.m_jobFileInfo.setDestFacilityID(this.m_destFacilityId);
        this.m_jobFileInfo.setDestScope(this.m_destFacilityPath);
        if (this.m_destDirectory.getText().length() > 0) {
            this.m_jobFileInfo.setDestDirectory(this.m_destDirectory.getText());
        } else if (this.m_destDirectory.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(String.valueOf(Messages.getString((String)"forward.destination")) + Messages.getString((String)"message.job.46"));
            return result;
        }
        this.m_jobFileInfo.setDestWorkDir("");
        if (this.m_allNode.getSelection()) {
            this.m_jobFileInfo.setProcessingMethod(Integer.valueOf(0));
        } else {
            this.m_jobFileInfo.setProcessingMethod(Integer.valueOf(1));
        }
        this.m_jobFileInfo.setCompressionFlg(Integer.valueOf(YesNoConstant.booleanToType((boolean)this.m_compressionCondition.getSelection())));
        this.m_jobFileInfo.setCheckFlg(Integer.valueOf(YesNoConstant.booleanToType((boolean)this.m_checkFileCondition.getSelection())));
        if (this.m_agentUser.getSelection()) {
            this.m_jobFileInfo.setSpecifyUser(Integer.valueOf(0));
        } else if (this.m_user.getText().length() > 0) {
            this.m_jobFileInfo.setSpecifyUser(Integer.valueOf(1));
            this.m_jobFileInfo.setUser(this.m_user.getText());
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.5"));
            return result;
        }
        try {
            if (this.m_messageRetry.getText().length() <= 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.87"));
                return result;
            }
            this.m_jobFileInfo.setMessageRetry(Integer.valueOf(Integer.parseInt(this.m_messageRetry.getText())));
        }
        catch (NumberFormatException numberFormatException) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.87"));
            return result;
        }
        return null;
    }

    public void setOwnerRoleId(String ownerRoleId) {
        this.m_ownerRoleId = ownerRoleId;
        this.m_destScope.setText("");
        this.m_destFacilityId = null;
        this.m_srcScope.setText("");
        this.m_srcFacilityId = null;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_srcScope.setEnabled(enabled);
        this.m_srcFile.setEnabled(enabled);
        this.m_destScope.setEnabled(enabled);
        this.m_destDirectory.setEnabled(enabled);
        this.m_agentUser.setEnabled(enabled);
        this.m_specifyUser.setEnabled(enabled);
        this.m_user.setEnabled(enabled);
        this.m_srcScopeSelect.setEnabled(enabled);
        this.m_destScopeSelect.setEnabled(enabled);
        this.m_allNode.setEnabled(enabled);
        this.m_oneNode.setEnabled(enabled);
        this.m_compressionCondition.setEnabled(enabled);
        this.m_checkFileCondition.setEnabled(enabled);
        this.m_messageRetry.setEnabled(enabled);
    }
}

