/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.jobmanagement.action.GetJobKickTableDefine;
import com.clustercontrol.jobmanagement.bean.JobTriggerTypeConstant;
import com.clustercontrol.jobmanagement.composite.action.JobKickDoubleClickListener;
import com.clustercontrol.jobmanagement.composite.action.JobKickSelectionChangedListener;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.JobKick;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class JobKickListComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(JobKickListComposite.class);
    private CommonTableViewer m_viewer = null;
    private ArrayList m_selectItem = null;

    public JobKickListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Table table = new Table((Composite)this, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.m_viewer = new CommonTableViewer(table);
        this.m_viewer.createTableColumn(GetJobKickTableDefine.get(), 1, 1);
        this.m_viewer.addSelectionChangedListener(new JobKickSelectionChangedListener(this));
        this.m_viewer.addDoubleClickListener(new JobKickDoubleClickListener(this));
    }

    public void update() {
        ArrayList listInput = new ArrayList();
        for (JobKick jobKick : this.getJobKick()) {
            ArrayList<Object> a = new ArrayList<Object>();
            a.add(JobTriggerTypeConstant.typeToString((int)jobKick.getType()));
            a.add(jobKick.getId());
            a.add(jobKick.getName());
            a.add(jobKick.getJobId());
            a.add(jobKick.getJobName());
            a.add(jobKick.getJobunitId());
            a.add(jobKick.getCalendarId());
            a.add(jobKick.getValid());
            a.add(jobKick.getOwnerRoleId());
            a.add(jobKick.getCreateUser());
            if (jobKick.getCreateTime() == null) {
                a.add(null);
            } else {
                a.add(new Date(jobKick.getCreateTime()));
            }
            a.add(jobKick.getUpdateUser());
            if (jobKick.getUpdateTime() == null) {
                a.add(null);
            } else {
                a.add(new Date(jobKick.getUpdateTime()));
            }
            listInput.add(a);
        }
        this.m_viewer.setInput(listInput);
    }

    private List<JobKick> getJobKick() {
        List<JobKick> jobKick = null;
        try {
            jobKick = JobEndpointWrapper.getJobKickList();
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("getJobSchedule(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        if (jobKick == null) {
            jobKick = new ArrayList<JobKick>();
        }
        return jobKick;
    }

    public TableViewer getTableViewer() {
        return this.m_viewer;
    }

    public Table getTable() {
        return this.m_viewer.getTable();
    }

    public ArrayList getSelectItem() {
        return this.m_selectItem;
    }

    public void setSelectItem(ArrayList selectItem) {
        this.m_selectItem = selectItem;
    }
}

