/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.jobmanagement.dialog.JobDialog;
import com.clustercontrol.jobmanagement.util.JobEditStateUtil;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.jobmanagement.util.JobUtil;
import com.clustercontrol.jobmanagement.view.JobListView;
import com.clustercontrol.jobmanagement.viewer.JobTreeContentProvider;
import com.clustercontrol.jobmanagement.viewer.JobTreeLabelProvider;
import com.clustercontrol.jobmanagement.viewer.JobTreeViewer;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.JobInfo;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class JobTreeComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(JobTreeComposite.class);
    private JobTreeViewer m_viewer = null;
    private JobTreeItem m_selectItem = null;
    private boolean m_treeOnly = false;
    private String m_jobId = null;
    private JobListView m_view = null;
    private boolean m_useForView = false;
    private static List<JobTreeViewer> m_treeViewerList = new ArrayList<JobTreeViewer>();
    private int mode = -1;
    private String ownerRoleId = null;

    public JobTreeComposite(JobListView view, Composite parent, int style, String ownerRoleId) {
        super(parent, style);
        this.m_treeOnly = false;
        this.m_view = view;
        this.ownerRoleId = ownerRoleId;
        this.m_useForView = true;
        this.initialize();
    }

    public JobTreeComposite(Composite parent, int style, String ownerRoleId, boolean treeOnly, boolean useForView) {
        super(parent, style);
        this.m_treeOnly = treeOnly;
        this.ownerRoleId = ownerRoleId;
        this.m_useForView = useForView;
        this.initialize();
    }

    public JobTreeComposite(Composite parent, int style, String ownerRoleId, JobTreeItem selectItem) {
        super(parent, style);
        this.m_treeOnly = true;
        this.m_selectItem = selectItem;
        this.m_jobId = selectItem.getData().getId();
        this.ownerRoleId = ownerRoleId;
        this.m_useForView = false;
        this.initialize();
    }

    public JobTreeComposite(Composite parent, int style, String ownerRoleId, JobTreeItem selectItem, int mode) {
        super(parent, style);
        this.m_treeOnly = true;
        this.m_selectItem = selectItem;
        this.m_jobId = selectItem.getData().getId();
        this.mode = mode;
        this.ownerRoleId = ownerRoleId;
        this.m_useForView = false;
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Tree tree = new Tree((Composite)this, 2052);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        tree.setLayoutData((Object)gridData);
        this.m_viewer = new JobTreeViewer(tree);
        this.m_viewer.setContentProvider((IContentProvider)new JobTreeContentProvider());
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new JobTreeLabelProvider(this.m_useForView));
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                JobTreeComposite.this.m_selectItem = (JobTreeItem)selection.getFirstElement();
            }
        });
        if (this.m_useForView) {
            this.m_viewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    JobTreeItem item = (JobTreeItem)selection.getFirstElement();
                    int type = item.getData().getType();
                    m_log.info((Object)("double click. type=" + type));
                    if (type != 5 && type != 3 && type != 2 && type != 0 && type != 1) {
                        return;
                    }
                    boolean readOnly = !JobEditStateUtil.isLockedJobunitId(item.getData().getJobunitId());
                    JobDialog dialog = new JobDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), readOnly);
                    dialog.setJobTreeItem(item);
                    if (dialog.open() == 0) {
                        if (!readOnly) {
                            JobEditStateUtil.addEditedJobunit(item);
                            if (item.getData().getType() == 0) {
                                JobUtil.setJobunitIdAll(item, item.getData().getJobunitId());
                            }
                        }
                        JobTreeComposite.this.m_viewer.sort(item.getParent());
                        JobTreeComposite.this.m_viewer.refresh(item.getParent());
                        JobTreeComposite.this.m_viewer.refresh(item);
                        JobTreeComposite.this.m_viewer.setSelection((ISelection)new StructuredSelection((Object)item), true);
                    }
                }
            });
        }
        this.updateTree(this.m_useForView);
    }

    public JobTreeViewer getTreeViewer() {
        return this.m_viewer;
    }

    public Tree getTree() {
        return this.m_viewer.getTree();
    }

    public void update() {
        this.updateTree(false);
    }

    public void updateTree(boolean useChache) {
        JobTreeItem jobTree = null;
        if (this.m_useForView) {
            if (useChache) {
                jobTree = JobEditStateUtil.getJobTreeItem();
            }
            if (jobTree == null) {
                jobTree = JobEditStateUtil.updateJobTree(this.ownerRoleId, this.m_treeOnly);
            }
        } else if (this.m_jobId == null) {
            try {
                jobTree = JobEndpointWrapper.getJobTree(this.ownerRoleId, this.m_treeOnly);
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (Exception e) {
                m_log.warn((Object)("update() getJobTree, " + e.getMessage()), (Throwable)e);
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
        } else {
            jobTree = this.mode == 5 ? this.getJobTreeOneUnit(this.m_selectItem) : this.getJobTreeOneLevel(this.m_selectItem);
        }
        this.m_selectItem = null;
        this.m_viewer.setInput(jobTree);
        if (this.m_useForView) {
            for (JobTreeViewer viewer : m_treeViewerList) {
                if (viewer == this.m_viewer) continue;
                viewer.setInput(jobTree);
            }
        }
        this.m_viewer.expandToLevel(2);
    }

    public void update(String jobId) {
        JobTreeItem jobTree = null;
        if (this.m_useForView) {
            jobTree = JobEditStateUtil.updateJobTree(this.ownerRoleId, this.m_treeOnly);
        } else if (this.m_jobId == null) {
            try {
                jobTree = JobEndpointWrapper.getJobTree(this.ownerRoleId, this.m_treeOnly);
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (Exception e) {
                m_log.warn((Object)("update() getJobTree, " + e.getMessage()), (Throwable)e);
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
        } else {
            jobTree = this.getJobTreeOneLevel(this.m_selectItem);
        }
        this.m_selectItem = null;
        this.m_viewer.setInput(jobTree);
        List treeList = jobTree.getChildren();
        this.setFocus(treeList, jobId);
    }

    private void setFocus(List<JobTreeItem> treeList, String jobId) {
        for (JobTreeItem item : treeList) {
            if (jobId.equals(item.getData().getId())) {
                m_log.trace((Object)("item : " + item.getData().getId()));
                this.m_viewer.setSelection((ISelection)new StructuredSelection((Object)item), true);
                break;
            }
            if (item.getChildren() == null || item.getChildren().size() <= 0) continue;
            this.setFocus(item.getChildren(), jobId);
        }
    }

    public JobTreeItem getSelectItem() {
        return this.m_selectItem;
    }

    public void setSelectItem(JobTreeItem item) {
        this.m_selectItem = item;
    }

    public JobTreeItem getJobTreeOneLevel(JobTreeItem self) {
        JobTreeItem parentOrg = self.getParent();
        JobTreeItem parentClone = new JobTreeItem();
        parentClone.setData(this.copyJobInfo(parentOrg.getData()));
        String jobId = self.getData().getId();
        for (JobTreeItem brotherOrg : self.getParent().getChildren()) {
            if (jobId.equals(brotherOrg.getData().getId())) continue;
            JobTreeItem brotherClone = new JobTreeItem();
            brotherClone.setParent(parentClone);
            parentClone.getChildren().add(brotherClone);
            brotherClone.setData(this.copyJobInfo(brotherOrg.getData()));
        }
        return parentClone;
    }

    public JobTreeItem getJobTreeOneUnit(JobTreeItem self) {
        JobTreeItem parentOrg = self.getParent();
        JobTreeItem ret = new JobTreeItem();
        String jobUnitId = self.getData().getJobunitId();
        while (!parentOrg.getData().getId().equals("")) {
            if (parentOrg.getData().getId().equals(jobUnitId)) {
                ret.setData(this.copyJobInfo(parentOrg.getData()));
                break;
            }
            parentOrg = parentOrg.getParent();
        }
        String jobId = self.getData().getId();
        ret = this.cloneChildren(jobId, ret, parentOrg.getChildren());
        return ret;
    }

    private JobTreeItem cloneChildren(String id, JobTreeItem parent, List<JobTreeItem> itemList) {
        for (JobTreeItem childrenOrg : itemList) {
            if (id.equals(childrenOrg.getData().getId())) continue;
            JobTreeItem childrenClone = new JobTreeItem();
            childrenClone.setData(this.copyJobInfo(childrenOrg.getData()));
            if (!childrenOrg.getChildren().isEmpty()) {
                childrenClone = this.cloneChildren(id, childrenClone, childrenOrg.getChildren());
            }
            childrenClone.setParent(parent);
            parent.getChildren().add(childrenClone);
        }
        return parent;
    }

    private JobInfo copyJobInfo(JobInfo orgInfo) {
        JobInfo info = new JobInfo();
        info.setJobunitId(orgInfo.getJobunitId());
        info.setId(orgInfo.getId());
        info.setName(orgInfo.getName());
        info.setType(orgInfo.getType());
        return info;
    }

    public void refresh() {
        for (JobTreeViewer viewer : m_treeViewerList) {
            m_log.debug((Object)("refresh : " + (Object)((Object)viewer)));
            viewer.refresh();
        }
    }

    public void refresh(Object element) {
        for (JobTreeViewer viewer : m_treeViewerList) {
            m_log.debug((Object)("refresh : " + (Object)((Object)viewer)));
            viewer.refresh(element);
        }
    }

    public void addToTreeViewerList() {
        m_log.debug((Object)("add treeViewerList: " + (Object)((Object)this.m_viewer)));
        m_log.debug((Object)m_treeViewerList.size());
        m_treeViewerList.add(this.m_viewer);
        m_log.debug((Object)m_treeViewerList.size());
    }

    public void removeFromTreeViewerList() {
        m_log.debug((Object)("remove treeViewerList: " + (Object)((Object)this.m_viewer)));
        m_log.debug((Object)m_treeViewerList.size());
        m_treeViewerList.remove((Object)this.m_viewer);
        m_log.debug((Object)m_treeViewerList.size());
        super.dispose();
    }
}

