/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.accesscontrol.util.LocalSession;
import com.clustercontrol.jobmanagement.action.GetNodeDetailTableDefine;
import com.clustercontrol.jobmanagement.composite.action.NodeDetailSelectionChangedListener;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.JobNodeDetail;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class NodeDetailComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(NodeDetailComposite.class);
    private CommonTableViewer m_viewer = null;
    private String m_sessionId = null;
    private String m_jobunitId = null;
    private String m_jobId = null;
    private String m_facilityId = null;
    private Label m_idLabel = null;

    public NodeDetailComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_idLabel = new Label((Composite)this, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.m_idLabel.setLayoutData((Object)gridData);
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.m_viewer = new CommonTableViewer(table);
        this.m_viewer.createTableColumn(GetNodeDetailTableDefine.get(), 2, 1);
        this.m_viewer.addSelectionChangedListener(new NodeDetailSelectionChangedListener(this));
    }

    public void update(String sessionId, String jobunitId, String jobId) {
        List<Object> nodeDetailInfo;
        block13: {
            nodeDetailInfo = null;
            if (sessionId != null && jobId != null) {
                try {
                    nodeDetailInfo = JobEndpointWrapper.getNodeDetailList(sessionId, jobunitId, jobId);
                }
                catch (InvalidRole_Exception invalidRole_Exception) {
                    if (LocalSession.isDialogFlag()) {
                        LocalSession.setDialogFlag(false);
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                        LocalSession.setDialogFlag(true);
                    }
                }
                catch (Exception e) {
                    m_log.warn((Object)("update() getNodeDetailList, " + e.getMessage()), (Throwable)e);
                    if (!LocalSession.isDialogFlag()) break block13;
                    LocalSession.setDialogFlag(false);
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
                    LocalSession.setDialogFlag(true);
                }
            }
        }
        if (nodeDetailInfo == null) {
            nodeDetailInfo = new ArrayList();
        }
        ArrayList listInput = new ArrayList();
        for (JobNodeDetail info : nodeDetailInfo) {
            ArrayList<Object> a = new ArrayList<Object>();
            a.add(info.getStatus());
            a.add(info.getEndValue());
            a.add(info.getFacilityId());
            a.add(info.getNodeName());
            if (info.getStartDate() != null) {
                a.add(new Date(info.getStartDate()));
            } else {
                a.add("");
            }
            if (info.getEndDate() != null) {
                a.add(new Date(info.getEndDate()));
            } else {
                a.add("");
            }
            a.add(info.getMessage());
            listInput.add(a);
        }
        this.m_viewer.setInput(listInput);
        this.m_sessionId = sessionId;
        this.m_jobunitId = jobunitId;
        this.m_jobId = jobId;
        if (this.m_sessionId != null && this.m_jobId != null) {
            this.m_idLabel.setText(String.valueOf(Messages.getString((String)"session.id")) + " : " + this.m_sessionId + ",   " + Messages.getString((String)"job.id") + " : " + this.m_jobId);
        } else {
            this.m_idLabel.setText(String.valueOf(Messages.getString((String)"session.id")) + " : " + ",   " + Messages.getString((String)"job.id") + " : ");
        }
    }

    public TableViewer getTableViewer() {
        return this.m_viewer;
    }

    public Table getTable() {
        return this.m_viewer.getTable();
    }

    public String getSessionId() {
        return this.m_sessionId;
    }

    public void setSessionId(String sessionId) {
        this.m_sessionId = sessionId;
    }

    public String getJobId() {
        return this.m_jobId;
    }

    public void setJobId(String jobId) {
        this.m_jobId = jobId;
    }

    public String getFacilityId() {
        return this.m_facilityId;
    }

    public void setFacilityId(String facilityId) {
        this.m_facilityId = facilityId;
    }

    public String getJobunitId() {
        return this.m_jobunitId;
    }

    public void setJobunitId(String jobunitId) {
        this.m_jobunitId = jobunitId;
    }
}

