/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite.action;

import com.clustercontrol.jobmanagement.composite.JobListComposite;
import com.clustercontrol.jobmanagement.composite.JobTreeComposite;
import com.clustercontrol.jobmanagement.view.JobListView;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class JobTreeSelectionChangedListener
implements ISelectionChangedListener {
    private JobTreeComposite m_tree;
    private JobListComposite m_list;

    public JobTreeSelectionChangedListener(JobTreeComposite tree, JobListComposite list) {
        this.m_tree = tree;
        this.m_list = list;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        JobTreeItem selectItem = null;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart viewPart = page.findView("com.clustercontrol.jobmanagement.view.JobListView");
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        if (viewPart != null && selection != null) {
            selectItem = (JobTreeItem)selection.getFirstElement();
            JobListView view = (JobListView)viewPart.getAdapter(JobListView.class);
            if (selectItem instanceof JobTreeItem) {
                this.m_tree.setSelectItem(selectItem);
                if (selectItem.getData().getType() == 0) {
                    view.setEnabledActionAll(true);
                    view.setEnabledAction(selectItem.getData().getType(), selectItem.getData().getJobunitId(), (ISelection)selection);
                } else {
                    view.setEnabledAction(selectItem.getData().getType(), selectItem.getData().getJobunitId(), (ISelection)selection);
                }
            } else {
                this.m_tree.setSelectItem(null);
                view.setEnabledAction(-9, (ISelection)selection);
            }
            this.m_list.update(selectItem);
        }
    }
}

