/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dialog;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.composite.RoleIdListComposite;
import com.clustercontrol.composite.action.StringVerifyListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.fault.JobInvalid;
import com.clustercontrol.jobmanagement.bean.SystemParameterConstant;
import com.clustercontrol.jobmanagement.composite.CommandComposite;
import com.clustercontrol.jobmanagement.composite.ControlComposite;
import com.clustercontrol.jobmanagement.composite.EndDelayComposite;
import com.clustercontrol.jobmanagement.composite.EndStatusComposite;
import com.clustercontrol.jobmanagement.composite.FileComposite;
import com.clustercontrol.jobmanagement.composite.MultiplicityComposite;
import com.clustercontrol.jobmanagement.composite.NotificationsComposite;
import com.clustercontrol.jobmanagement.composite.ParameterComposite;
import com.clustercontrol.jobmanagement.composite.ReferComposite;
import com.clustercontrol.jobmanagement.composite.StartDelayComposite;
import com.clustercontrol.jobmanagement.composite.WaitRuleComposite;
import com.clustercontrol.jobmanagement.util.JobEditStateUtil;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.jobmanagement.util.JobPropertyUtil;
import com.clustercontrol.jobmanagement.util.JobTreeItemUtil;
import com.clustercontrol.jobmanagement.util.JobUtil;
import com.clustercontrol.notify.util.NotifyGroupIdGenerator;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.JobCommandInfo;
import com.clustercontrol.ws.jobmanagement.JobFileInfo;
import com.clustercontrol.ws.jobmanagement.JobInfo;
import com.clustercontrol.ws.jobmanagement.JobNotificationsInfo;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import com.clustercontrol.ws.jobmanagement.JobWaitRuleInfo;
import com.clustercontrol.ws.jobmanagement.OtherUserGetLock_Exception;
import com.clustercontrol.ws.notify.NotifyRelationInfo;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class JobDialog
extends CommonDialog {
    private static Log m_log = LogFactory.getLog(JobDialog.class);
    private Text m_jobIdText = null;
    private Text m_jobNameText = null;
    private Text m_jobAnnotationText = null;
    private WaitRuleComposite m_startComposite = null;
    private ControlComposite m_controlComposite = null;
    private EndStatusComposite m_endComposite = null;
    private CommandComposite m_executeComposite = null;
    private FileComposite m_fileComposite = null;
    private NotificationsComposite m_messageComposite = null;
    private StartDelayComposite m_startDelayComposite = null;
    private EndDelayComposite m_endDelayComposite = null;
    private MultiplicityComposite m_multiplicityComposite = null;
    private ParameterComposite m_parameterComposite = null;
    private ReferComposite m_referComposite = null;
    private JobTreeItem m_jobTreeItem = null;
    private TabFolder m_tabFolder = null;
    private Shell m_shell = null;
    private boolean m_readOnly = false;
    private RoleIdListComposite m_ownerRoleId = null;

    public JobDialog(Shell parent, boolean readOnly) {
        super(parent);
        this.m_readOnly = readOnly;
    }

    @Override
    protected void customizeDialog(Composite parent) {
        this.m_shell = this.getShell();
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.spacing = 0;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.marginBottom = 0;
        layout.fill = true;
        parent.setLayout((Layout)layout);
        Composite composite = null;
        RowLayout rowLayout = null;
        JobInfo info = this.m_jobTreeItem.getData();
        JobPropertyUtil.setJobFull(info);
        if (info instanceof JobInfo) {
            if (info.getType() == 0) {
                parent.getShell().setText(Messages.getString((String)"dialog.job.create.modify.jobunit"));
            } else if (info.getType() == 1) {
                parent.getShell().setText(Messages.getString((String)"dialog.job.create.modify.jobnet"));
            } else if (info.getType() == 2) {
                parent.getShell().setText(Messages.getString((String)"dialog.job.create.modify.job"));
            } else if (info.getType() == 3) {
                parent.getShell().setText(Messages.getString((String)"dialog.job.create.modify.forward.file.job"));
            } else if (info.getType() == 5) {
                parent.getShell().setText(Messages.getString((String)"dialog.job.create.modify.refer.job"));
            }
        }
        boolean initFlag = true;
        if (info.getId() != null && info.getId().length() > 0) {
            initFlag = false;
        }
        composite = new Composite(parent, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label jobIdTitle = new Label(composite, 0);
        jobIdTitle.setText(String.valueOf(Messages.getString((String)"job.id")) + " : ");
        jobIdTitle.setLayoutData((Object)new RowData(120, 15));
        this.m_jobIdText = new Text(composite, 2048);
        this.m_jobIdText.setLayoutData((Object)new RowData(200, 15));
        this.m_jobIdText.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        this.m_jobIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                JobDialog.this.update();
            }
        });
        composite = new Composite(parent, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label jobNameTitle = new Label(composite, 0);
        jobNameTitle.setText(String.valueOf(Messages.getString((String)"job.name")) + " : ");
        jobNameTitle.setLayoutData((Object)new RowData(120, 15));
        this.m_jobNameText = new Text(composite, 2048);
        this.m_jobNameText.setLayoutData((Object)new RowData(200, 15));
        this.m_jobNameText.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        this.m_jobNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                JobDialog.this.update();
            }
        });
        composite = new Composite(parent, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label jobAnnotationTitle = new Label(composite, 0);
        jobAnnotationTitle.setText(String.valueOf(Messages.getString((String)"description")) + " : ");
        jobAnnotationTitle.setLayoutData((Object)new RowData(120, 15));
        this.m_jobAnnotationText = new Text(composite, 2048);
        this.m_jobAnnotationText.setLayoutData((Object)new RowData(200, 15));
        this.m_jobAnnotationText.addVerifyListener((VerifyListener)new StringVerifyListener(256));
        composite = new Composite(parent, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label ownerRoleIdTitle = new Label(composite, 0);
        ownerRoleIdTitle.setText(String.valueOf(Messages.getString((String)"owner.role.id")) + " : ");
        ownerRoleIdTitle.setLayoutData((Object)new RowData(120, 15));
        if (info.getType() == 0 && info.getCreateTime() == null) {
            this.m_ownerRoleId = new RoleIdListComposite(composite, 0, true, RoleIdListComposite.Mode.OWNER_ROLE);
            this.m_ownerRoleId.getComboRoleId().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    JobDialog.this.m_messageComposite.getNotifyId().setOwnerRoleId(JobDialog.this.m_ownerRoleId.getText());
                }
            });
        } else {
            this.m_ownerRoleId = new RoleIdListComposite(composite, 0, false, RoleIdListComposite.Mode.OWNER_ROLE);
        }
        this.m_ownerRoleId.setLayoutData(new RowData(200, 25));
        this.m_tabFolder = new TabFolder(parent, 0);
        if (info instanceof JobInfo) {
            TabItem tabItem2;
            TabItem tabItem1;
            if (info.getType() == 1) {
                this.m_startComposite = new WaitRuleComposite((Composite)this.m_tabFolder, 0);
                tabItem1 = new TabItem(this.m_tabFolder, 0);
                tabItem1.setText(Messages.getString((String)"wait.rule"));
                tabItem1.setControl((Control)this.m_startComposite);
                this.m_controlComposite = new ControlComposite((Composite)this.m_tabFolder, 0);
                tabItem2 = new TabItem(this.m_tabFolder, 0);
                tabItem2.setText(Messages.getString((String)"control"));
                tabItem2.setControl((Control)this.m_controlComposite);
                this.m_startDelayComposite = new StartDelayComposite((Composite)this.m_tabFolder, 0);
                TabItem tabItem3 = new TabItem(this.m_tabFolder, 0);
                tabItem3.setText(Messages.getString((String)"start.delay"));
                tabItem3.setControl((Control)this.m_startDelayComposite);
                this.m_endDelayComposite = new EndDelayComposite((Composite)this.m_tabFolder, 0, false);
                TabItem tabItem4 = new TabItem(this.m_tabFolder, 0);
                tabItem4.setText(Messages.getString((String)"end.delay"));
                tabItem4.setControl((Control)this.m_endDelayComposite);
            } else if (info.getType() == 2) {
                this.m_startComposite = new WaitRuleComposite((Composite)this.m_tabFolder, 0);
                tabItem1 = new TabItem(this.m_tabFolder, 0);
                tabItem1.setText(Messages.getString((String)"wait.rule"));
                tabItem1.setControl((Control)this.m_startComposite);
                this.m_controlComposite = new ControlComposite((Composite)this.m_tabFolder, 0);
                tabItem2 = new TabItem(this.m_tabFolder, 0);
                tabItem2.setText(Messages.getString((String)"control"));
                tabItem2.setControl((Control)this.m_controlComposite);
                this.m_executeComposite = new CommandComposite((Composite)this.m_tabFolder, 0);
                TabItem tabItem3 = new TabItem(this.m_tabFolder, 0);
                tabItem3.setText(Messages.getString((String)"command"));
                tabItem3.setControl((Control)this.m_executeComposite);
                this.m_startDelayComposite = new StartDelayComposite((Composite)this.m_tabFolder, 0);
                TabItem tabItem4 = new TabItem(this.m_tabFolder, 0);
                tabItem4.setText(Messages.getString((String)"start.delay"));
                tabItem4.setControl((Control)this.m_startDelayComposite);
                this.m_endDelayComposite = new EndDelayComposite((Composite)this.m_tabFolder, 0, false);
                TabItem tabItem5 = new TabItem(this.m_tabFolder, 0);
                tabItem5.setText(Messages.getString((String)"end.delay"));
                tabItem5.setControl((Control)this.m_endDelayComposite);
                this.m_multiplicityComposite = new MultiplicityComposite((Composite)this.m_tabFolder, 0, false);
                TabItem tabItem6 = new TabItem(this.m_tabFolder, 0);
                tabItem6.setText(Messages.getString((String)"multiplicity"));
                tabItem6.setControl((Control)this.m_multiplicityComposite);
            } else if (info.getType() == 3) {
                this.m_startComposite = new WaitRuleComposite((Composite)this.m_tabFolder, 0);
                tabItem1 = new TabItem(this.m_tabFolder, 0);
                tabItem1.setText(Messages.getString((String)"wait.rule"));
                tabItem1.setControl((Control)this.m_startComposite);
                this.m_controlComposite = new ControlComposite((Composite)this.m_tabFolder, 0);
                tabItem2 = new TabItem(this.m_tabFolder, 0);
                tabItem2.setText(Messages.getString((String)"control"));
                tabItem2.setControl((Control)this.m_controlComposite);
                this.m_fileComposite = new FileComposite((Composite)this.m_tabFolder, 0);
                TabItem tabItem3 = new TabItem(this.m_tabFolder, 0);
                tabItem3.setText(Messages.getString((String)"forward.file"));
                tabItem3.setControl((Control)this.m_fileComposite);
                this.m_startDelayComposite = new StartDelayComposite((Composite)this.m_tabFolder, 0);
                TabItem tabItem4 = new TabItem(this.m_tabFolder, 0);
                tabItem4.setText(Messages.getString((String)"start.delay"));
                tabItem4.setControl((Control)this.m_startDelayComposite);
                this.m_endDelayComposite = new EndDelayComposite((Composite)this.m_tabFolder, 0, true);
                TabItem tabItem5 = new TabItem(this.m_tabFolder, 0);
                tabItem5.setText(Messages.getString((String)"end.delay"));
                tabItem5.setControl((Control)this.m_endDelayComposite);
                this.m_multiplicityComposite = new MultiplicityComposite((Composite)this.m_tabFolder, 0, true);
                TabItem tabItem6 = new TabItem(this.m_tabFolder, 0);
                tabItem6.setText(Messages.getString((String)"multiplicity"));
                tabItem6.setControl((Control)this.m_multiplicityComposite);
            } else if (info.getType() == 5) {
                this.m_startComposite = new WaitRuleComposite((Composite)this.m_tabFolder, 0);
                tabItem1 = new TabItem(this.m_tabFolder, 0);
                tabItem1.setText(Messages.getString((String)"wait.rule"));
                tabItem1.setControl((Control)this.m_startComposite);
                this.m_referComposite = new ReferComposite((Composite)this.m_tabFolder, 0);
                tabItem2 = new TabItem(this.m_tabFolder, 0);
                tabItem2.setText(Messages.getString((String)"refer"));
                tabItem2.setControl((Control)this.m_referComposite);
            }
            if (info.getType() != 5) {
                this.m_endComposite = new EndStatusComposite((Composite)this.m_tabFolder, 0);
                TabItem tabItem7 = new TabItem(this.m_tabFolder, 0);
                tabItem7.setText(Messages.getString((String)"end.status"));
                tabItem7.setControl((Control)this.m_endComposite);
                this.m_messageComposite = new NotificationsComposite((Composite)this.m_tabFolder, 0);
                TabItem tabItem8 = new TabItem(this.m_tabFolder, 0);
                tabItem8.setText(Messages.getString((String)"notifications"));
                tabItem8.setControl((Control)this.m_messageComposite);
            }
            if (info.getType() == 0) {
                this.m_parameterComposite = new ParameterComposite((Composite)this.m_tabFolder, 0, initFlag);
                TabItem tabItem9 = new TabItem(this.m_tabFolder, 0);
                tabItem9.setText(Messages.getString((String)"job.parameter"));
                tabItem9.setControl((Control)this.m_parameterComposite);
            }
        }
        this.m_tabFolder.setSelection(0);
        Display display = this.m_shell.getDisplay();
        this.m_shell.setLocation((display.getBounds().width - this.m_shell.getSize().x) / 2, (display.getBounds().height - this.m_shell.getSize().y) / 2);
        this.reflectJobInfo(info);
        if (this.m_readOnly) {
            this.m_jobIdText.setEnabled(false);
            this.m_jobNameText.setEnabled(false);
            this.m_jobAnnotationText.setEnabled(false);
            this.m_ownerRoleId.setEnabled(false);
            if (this.m_startComposite != null) {
                this.m_startComposite.setEnabled(false);
            }
            if (this.m_controlComposite != null) {
                this.m_controlComposite.setEnabled(false);
            }
            if (this.m_executeComposite != null) {
                this.m_executeComposite.setEnabled(false);
            }
            if (this.m_fileComposite != null) {
                this.m_fileComposite.setEnabled(false);
            }
            if (this.m_startDelayComposite != null) {
                this.m_startDelayComposite.setEnabled(false);
            }
            if (this.m_endDelayComposite != null) {
                this.m_endDelayComposite.setEnabled(false);
            }
            if (this.m_multiplicityComposite != null) {
                this.m_multiplicityComposite.setEnabled(false);
            }
            if (info.getType() != 5) {
                this.m_endComposite.setEnabled(false);
                this.m_messageComposite.setEnabled(false);
            } else if (this.m_referComposite != null) {
                this.m_referComposite.setEnabled(false);
            }
            if (this.m_parameterComposite != null) {
                this.m_parameterComposite.setEnabled(false);
            }
        }
    }

    public void update() {
        if ("".equals(this.m_jobIdText.getText())) {
            this.m_jobIdText.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_jobIdText.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.m_jobNameText.getText())) {
            this.m_jobNameText.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_jobNameText.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    @Override
    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    private void reflectJobInfo(JobInfo info) {
        if (info instanceof JobInfo) {
            JobWaitRuleInfo jobWaitRuleInfo;
            String jobId = info.getId();
            if (jobId != null) {
                this.m_jobIdText.setText(jobId);
            } else {
                this.m_jobIdText.setText("");
            }
            if (info.getType() == 0 && JobEditStateUtil.getLockedJobunitBackup(info) != null) {
                this.m_jobIdText.setEditable(false);
            }
            if (info.getName() != null) {
                this.m_jobNameText.setText(info.getName());
            } else {
                this.m_jobNameText.setText("");
            }
            if (info.getDescription() != null) {
                this.m_jobAnnotationText.setText(info.getDescription());
            } else {
                this.m_jobAnnotationText.setText("");
            }
            if (info.getOwnerRoleId() != null) {
                this.m_ownerRoleId.setText(info.getOwnerRoleId());
            } else if (info.getType() == 0) {
                this.m_ownerRoleId.setText("ALL_USERS");
            } else {
                JobTreeItem parentItem = this.m_jobTreeItem.getParent();
                if (parentItem != null) {
                    JobInfo parentInfo = parentItem.getData();
                    this.m_ownerRoleId.setText(parentInfo.getOwnerRoleId());
                }
            }
            if (JobEditStateUtil.getLockedJobunitBackup(info) != null) {
                this.m_ownerRoleId.setEnabled(false);
            }
            if (info.getType() != 5) {
                this.m_messageComposite.getNotifyId().setOwnerRoleId(this.m_ownerRoleId.getText());
            }
            if ((jobWaitRuleInfo = info.getWaitRule()) == null) {
                jobWaitRuleInfo = JobTreeItemUtil.getNewJobWaitRuleInfo();
            }
            if (info.getType() == 1) {
                this.m_startComposite.setWaitRuleInfo(jobWaitRuleInfo);
                this.m_startComposite.setJobTreeItem(this.m_jobTreeItem);
                this.m_startComposite.reflectWaitRuleInfo();
                this.m_controlComposite.setWaitRuleInfo(jobWaitRuleInfo);
                this.m_controlComposite.getCalendarId().setOwnerRoleId(this.m_ownerRoleId.getText());
                this.m_controlComposite.reflectWaitRuleInfo();
                this.m_startDelayComposite.setWaitRuleInfo(jobWaitRuleInfo);
                this.m_startDelayComposite.reflectWaitRuleInfo();
                this.m_endDelayComposite.setWaitRuleInfo(jobWaitRuleInfo);
                this.m_endDelayComposite.reflectWaitRuleInfo();
            } else if (info.getType() == 2) {
                this.m_startComposite.setWaitRuleInfo(jobWaitRuleInfo);
                this.m_startComposite.setJobTreeItem(this.m_jobTreeItem);
                this.m_startComposite.reflectWaitRuleInfo();
                this.m_controlComposite.setWaitRuleInfo(jobWaitRuleInfo);
                this.m_controlComposite.getCalendarId().setOwnerRoleId(this.m_ownerRoleId.getText());
                this.m_controlComposite.reflectWaitRuleInfo();
                this.m_executeComposite.setCommandInfo(info.getCommand());
                this.m_executeComposite.setOwnerRoleId(this.m_ownerRoleId.getText());
                this.m_executeComposite.reflectCommandInfo();
                this.m_startDelayComposite.setWaitRuleInfo(jobWaitRuleInfo);
                this.m_startDelayComposite.reflectWaitRuleInfo();
                this.m_endDelayComposite.setWaitRuleInfo(jobWaitRuleInfo);
                this.m_endDelayComposite.reflectWaitRuleInfo();
                this.m_multiplicityComposite.setWaitRuleInfo(jobWaitRuleInfo);
                this.m_multiplicityComposite.reflectWaitRuleInfo();
            } else if (info.getType() == 3) {
                this.m_startComposite.setWaitRuleInfo(jobWaitRuleInfo);
                this.m_startComposite.setJobTreeItem(this.m_jobTreeItem);
                this.m_startComposite.reflectWaitRuleInfo();
                this.m_controlComposite.setWaitRuleInfo(jobWaitRuleInfo);
                this.m_controlComposite.getCalendarId().setOwnerRoleId(this.m_ownerRoleId.getText());
                this.m_controlComposite.reflectWaitRuleInfo();
                this.m_fileComposite.setFileInfo(info.getFile());
                this.m_fileComposite.setOwnerRoleId(this.m_ownerRoleId.getText());
                this.m_fileComposite.reflectFileInfo();
                this.m_startDelayComposite.setWaitRuleInfo(jobWaitRuleInfo);
                this.m_startDelayComposite.reflectWaitRuleInfo();
                this.m_endDelayComposite.setWaitRuleInfo(jobWaitRuleInfo);
                this.m_endDelayComposite.reflectWaitRuleInfo();
                this.m_multiplicityComposite.setWaitRuleInfo(jobWaitRuleInfo);
                this.m_multiplicityComposite.reflectWaitRuleInfo();
            } else if (info.getType() == 5) {
                this.m_startComposite.setWaitRuleInfo(jobWaitRuleInfo);
                this.m_startComposite.setJobTreeItem(this.m_jobTreeItem);
                this.m_startComposite.reflectWaitRuleInfo();
                this.m_referComposite.setReferJobUnitId(info.getReferJobUnitId());
                this.m_referComposite.setReferJobId(info.getReferJobId());
                this.m_referComposite.setJobTreeItem(this.m_jobTreeItem);
                this.m_referComposite.reflectReferInfo();
            }
            if (info.getType() != 5) {
                this.m_endComposite.setEndInfo(info.getEndStatus());
                this.m_endComposite.reflectEndInfo();
                this.m_messageComposite.setNotificationsInfo(info.getNotifications());
                this.m_messageComposite.getNotifyId().setOwnerRoleId(this.m_ownerRoleId.getText());
                this.m_messageComposite.reflectNotificationsInfo();
            }
            if (info.getType() == 0) {
                this.m_parameterComposite.setParamInfo(info.getParam());
                this.m_parameterComposite.reflectParamInfo();
            }
        }
    }

    @Override
    protected ValidateResult validate() {
        ValidateResult result = null;
        result = this.createJobInfo();
        if (result != null) {
            return result;
        }
        JobInfo info = this.m_jobTreeItem.getData();
        if (info instanceof JobInfo) {
            if (info.getType() == 1) {
                result = this.m_startComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_controlComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_startDelayComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_endDelayComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
            } else if (info.getType() == 2) {
                result = this.m_startComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_controlComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_executeComposite.createCommandInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_startDelayComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_endDelayComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_multiplicityComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
            } else if (info.getType() == 3) {
                result = this.m_startComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_controlComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_fileComposite.createFileInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_startDelayComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_endDelayComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_multiplicityComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
            } else if (info.getType() == 5) {
                result = this.m_startComposite.createWaitRuleInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_referComposite.createReferInfo();
                if (result != null) {
                    return result;
                }
            }
            if (info.getType() != 5) {
                result = this.m_endComposite.createEndInfo();
                if (result != null) {
                    return result;
                }
                result = this.m_messageComposite.createNotificationsInfo();
                if (result != null) {
                    return result;
                }
            }
            if (info.getType() == 0 && (result = this.m_parameterComposite.createParamInfo()) != null) {
                return result;
            }
            if (this.m_startComposite != null) {
                info.setWaitRule(this.m_startComposite.getWaitRuleInfo());
            }
            if (this.m_controlComposite != null) {
                info.setWaitRule(this.m_controlComposite.getWaitRuleInfo());
            }
            if (this.m_executeComposite != null) {
                info.setCommand(this.m_executeComposite.getCommandInfo());
            }
            if (this.m_fileComposite != null) {
                info.setFile(this.m_fileComposite.getFileInfo());
            }
            if (this.m_endComposite != null) {
                List jobEndStatusInfoList = info.getEndStatus();
                jobEndStatusInfoList.clear();
                if (this.m_endComposite.getEndInfo() != null) {
                    jobEndStatusInfoList.addAll(this.m_endComposite.getEndInfo());
                }
            }
            if (this.m_startDelayComposite != null) {
                info.setWaitRule(this.m_startDelayComposite.getWaitRuleInfo());
            }
            if (this.m_endDelayComposite != null) {
                info.setWaitRule(this.m_endDelayComposite.getWaitRuleInfo());
            }
            if (this.m_multiplicityComposite != null) {
                info.setWaitRule(this.m_multiplicityComposite.getWaitRuleInfo());
            }
            if (this.m_messageComposite != null) {
                List<JobNotificationsInfo> al = this.m_messageComposite.getNotificationsInfo();
                String notifyGroupId = NotifyGroupIdGenerator.createNotifyGroupIdJob((String)info.getJobunitId(), (String)info.getId(), (Integer)0);
                int i = 0;
                while (i < al.size()) {
                    JobNotificationsInfo jnInfo = al.get(i);
                    jnInfo.setNotifyGroupId(notifyGroupId);
                    if (jnInfo.getNotifyId() != null) {
                        for (NotifyRelationInfo nrInfo : jnInfo.getNotifyId()) {
                            nrInfo.setNotifyGroupId(notifyGroupId);
                        }
                    }
                    ++i;
                }
                List jobNotificationsInfoList = info.getNotifications();
                jobNotificationsInfoList.clear();
                jobNotificationsInfoList.addAll(al);
            }
            if (this.m_parameterComposite != null) {
                List jobParameterInfoinfoList = info.getParam();
                jobParameterInfoinfoList.clear();
                if (this.m_parameterComposite.getParamInfo() != null) {
                    jobParameterInfoinfoList.addAll(this.m_parameterComposite.getParamInfo());
                }
            }
            if (this.m_referComposite != null) {
                if (this.m_referComposite.getReferJobUnitId() != null) {
                    info.setReferJobUnitId(this.m_referComposite.getReferJobUnitId());
                }
                if (this.m_referComposite.getReferJobId() != null) {
                    info.setReferJobId(this.m_referComposite.getReferJobId());
                }
            }
            info.setPropertyFull(true);
        }
        return null;
    }

    private ValidateResult createJobInfo() {
        ValidateResult result = null;
        JobInfo info = this.m_jobTreeItem.getData();
        if (!this.m_readOnly && info.getType() == 0) {
            String oldJobunitId = info.getJobunitId();
            info.setJobunitId(this.m_jobIdText.getText());
            try {
                try {
                    JobUtil.findDuplicateJobunitId(this.m_jobTreeItem.getParent().getParent());
                }
                catch (JobInvalid jobInvalid) {
                    result = new ValidateResult();
                    result.setValid(false);
                    result.setID(Messages.getString((String)"message.hinemos.1"));
                    Object[] args1 = new String[]{this.m_jobIdText.getText()};
                    result.setMessage(Messages.getString((String)"message.job.64", (Object[])args1));
                    ValidateResult validateResult = result;
                    info.setJobunitId(oldJobunitId);
                    return validateResult;
                }
            }
            finally {
                info.setJobunitId(oldJobunitId);
            }
            if (!this.m_jobIdText.getText().matches("^[A-Za-z0-9-_]+$")) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                Object[] args1 = new String[]{this.m_jobIdText.getText(), Messages.getString((String)"job.id")};
                result.setMessage(Messages.getString((String)"message.common.6", (Object[])args1));
                info.setJobunitId(oldJobunitId);
                return result;
            }
            if (JobEditStateUtil.getEditSession(this.m_jobTreeItem.getData()) == null) {
                Integer editSession;
                block34: {
                    editSession = null;
                    try {
                        editSession = JobUtil.getEditLock(this.m_jobIdText.getText(), null, false);
                    }
                    catch (OtherUserGetLock_Exception e) {
                        String message = e.getMessage();
                        if (!MessageDialog.openQuestion(null, (String)Messages.getString((String)"confirmed"), (String)message)) break block34;
                        try {
                            editSession = JobUtil.getEditLock(this.m_jobIdText.getText(), null, true);
                        }
                        catch (Exception exception) {
                            m_log.error((Object)"run() : logical error");
                        }
                    }
                }
                if (editSession == null) {
                    result = new ValidateResult();
                    result.setValid(false);
                    result.setID(Messages.getString((String)"message.hinemos.1"));
                    Object[] args1 = new String[]{this.m_jobIdText.getText()};
                    result.setMessage(Messages.getString((String)"message.job.105", (Object[])args1));
                    return result;
                }
                JobEditStateUtil.addLockedJobunit(info, null, editSession);
            } else if (!this.m_jobIdText.getText().equals(oldJobunitId)) {
                Integer editSession;
                Integer oldEditSession;
                block35: {
                    oldEditSession = JobEditStateUtil.getEditSession(info);
                    editSession = null;
                    try {
                        editSession = JobUtil.getEditLock(this.m_jobIdText.getText(), null, false);
                    }
                    catch (OtherUserGetLock_Exception e) {
                        String message = e.getMessage();
                        if (!MessageDialog.openQuestion(null, (String)Messages.getString((String)"confirmed"), (String)message)) break block35;
                        try {
                            editSession = JobUtil.getEditLock(this.m_jobIdText.getText(), null, true);
                        }
                        catch (Exception exception) {
                            m_log.error((Object)"run() : logical error");
                        }
                    }
                }
                if (editSession == null) {
                    result = new ValidateResult();
                    result.setValid(false);
                    result.setID(Messages.getString((String)"message.hinemos.1"));
                    Object[] args1 = new String[]{this.m_jobIdText.getText()};
                    result.setMessage(Messages.getString((String)"message.job.105", (Object[])args1));
                    return result;
                }
                JobEditStateUtil.addLockedJobunit(info, null, editSession);
                try {
                    JobEndpointWrapper.releaseEditLock(oldEditSession);
                }
                catch (Exception exception) {
                    result = new ValidateResult();
                    result.setValid(false);
                    result.setID(Messages.getString((String)"message.hinemos.1"));
                    Object[] args1 = new String[]{this.m_jobIdText.getText()};
                    result.setMessage(Messages.getString((String)"message.job.105", (Object[])args1));
                    return result;
                }
            }
        }
        if (this.m_jobIdText.getText().length() > 0) {
            Object[] args1;
            String oldId = info.getId();
            info.setId("");
            JobTreeItem unit = JobUtil.getTopJobUnitTreeItem(this.m_jobTreeItem);
            if (unit != null && JobUtil.findJobId(this.m_jobIdText.getText(), unit)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                args1 = new String[]{this.m_jobIdText.getText()};
                result.setMessage(Messages.getString((String)"message.job.42", (Object[])args1));
                info.setId(oldId);
                return result;
            }
            if (!this.m_jobIdText.getText().matches("^[A-Za-z0-9-_]+$")) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                args1 = new String[]{this.m_jobIdText.getText(), Messages.getString((String)"job.id")};
                result.setMessage(Messages.getString((String)"message.common.6", (Object[])args1));
                info.setId(oldId);
                return result;
            }
            info.setId(this.m_jobIdText.getText());
            if (info.getType() == 0) {
                info.setJobunitId(this.m_jobIdText.getText());
            }
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.22"));
            return result;
        }
        if (this.m_jobNameText.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.23"));
            return result;
        }
        info.setName(this.m_jobNameText.getText());
        if (this.m_jobAnnotationText.getText().length() > 0) {
            info.setDescription(this.m_jobAnnotationText.getText());
        } else {
            info.setDescription("");
        }
        String newOwnerRoleId = this.m_ownerRoleId.getText();
        if (newOwnerRoleId.length() > 0) {
            if (!newOwnerRoleId.equals(info.getOwnerRoleId())) {
                JobDialog.changeOwnerRoleId(this.m_jobTreeItem, newOwnerRoleId);
            }
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"owner.role.id"));
            return result;
        }
        return null;
    }

    private static void changeOwnerRoleId(JobTreeItem item, String ownerRoleId) {
        List notifications;
        JobWaitRuleInfo jobWaitRuleInfo;
        List children = item.getChildren();
        if (children != null && children.size() > 0) {
            for (JobTreeItem child : children) {
                JobDialog.changeOwnerRoleId(child, ownerRoleId);
            }
        }
        JobInfo info = item.getData();
        info.setOwnerRoleId(ownerRoleId);
        if (info.getType() == 1) {
            jobWaitRuleInfo = info.getWaitRule();
            if (jobWaitRuleInfo != null) {
                jobWaitRuleInfo.setCalendar(Integer.valueOf(0));
                jobWaitRuleInfo.setCalendarId(null);
            }
        } else if (info.getType() == 2) {
            JobCommandInfo jobCommandInfo;
            jobWaitRuleInfo = info.getWaitRule();
            if (jobWaitRuleInfo != null) {
                jobWaitRuleInfo.setCalendar(Integer.valueOf(0));
                jobWaitRuleInfo.setCalendarId(null);
            }
            if ((jobCommandInfo = info.getCommand()) != null) {
                jobCommandInfo.setFacilityID(SystemParameterConstant.getParamText((String)"FACILITY_ID"));
                jobCommandInfo.setScope(null);
            }
        } else if (info.getType() == 3) {
            JobFileInfo jobFileInfo;
            jobWaitRuleInfo = info.getWaitRule();
            if (jobWaitRuleInfo != null) {
                jobWaitRuleInfo.setCalendar(Integer.valueOf(0));
                jobWaitRuleInfo.setCalendarId(null);
            }
            if ((jobFileInfo = info.getFile()) != null) {
                jobFileInfo.setSrcScope(null);
                jobFileInfo.setSrcFacilityID(null);
                jobFileInfo.setDestScope(null);
                jobFileInfo.setDestFacilityID(null);
            }
        } else if (info.getType() == 5) {
            info.setReferJobUnitId(null);
            info.setReferJobId(null);
        }
        if (info.getType() != 5 && (notifications = info.getNotifications()) != null && notifications.size() > 0) {
            for (JobNotificationsInfo child : notifications) {
                if (child.getType() != 0) continue;
                child.getNotifyId().clear();
            }
        }
        m_log.debug((Object)("changeOwnerRoleId()  jobunitId = " + info.getJobunitId() + " jobId = " + info.getId() + " ownerRoleId = " + info.getOwnerRoleId()));
    }

    public JobTreeItem getJobTreeItem() {
        return this.m_jobTreeItem;
    }

    public void setJobTreeItem(JobTreeItem jobTreeItem) {
        this.m_jobTreeItem = jobTreeItem;
    }
}

