/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.bean.OperationConstant;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.viewer.PropertySheet;
import java.util.ArrayList;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class JobOperationDialog
extends CommonDialog {
    private Property m_property = null;
    private PropertySheet m_propertySheet = null;
    private String m_title = "";

    public JobOperationDialog(Shell parent) {
        super(parent);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    @Override
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(this.m_title);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout((Layout)layout);
        TableTree table = new TableTree(parent, 68354);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.m_propertySheet = new PropertySheet(table);
        this.m_propertySheet.setInput(this.m_property);
        this.m_propertySheet.expandAll();
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
    }

    public Property getProperty() {
        return this.m_property;
    }

    public void setProperty(Property property) {
        this.m_property = property;
    }

    public String getTitleText() {
        return this.m_title;
    }

    public void setTitleText(String title) {
        this.m_title = title;
    }

    @Override
    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    @Override
    protected ValidateResult validate() {
        ValidateResult result = null;
        ArrayList values = PropertyUtil.getPropertyValue(this.m_property, "control");
        Integer control = null;
        if (values.get(0) instanceof String) {
            String controlString = (String)values.get(0);
            control = OperationConstant.stringToType((String)controlString);
        }
        values = PropertyUtil.getPropertyValue(this.m_property, "endValue");
        Integer endValue = null;
        if (values.size() > 0 && values.get(0) instanceof Integer) {
            endValue = (Integer)values.get(0);
        }
        if (control == -1) {
            result = new ValidateResult();
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.115"));
            result.setValid(false);
            return result;
        }
        if ((control == 8 || control == 4 || control == 11) && endValue == null) {
            result = new ValidateResult();
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.35"));
            result.setValid(false);
            return result;
        }
        return result;
    }
}

