/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dialog;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.composite.JobTreeComposite;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class JobTreeDialog
extends CommonDialog {
    private JobTreeComposite treeComposite = null;
    private boolean m_treeOnly = false;
    private JobTreeItem m_jobTreeItem = null;
    private String ownerRoleId = null;
    private int mode = -1;

    public JobTreeDialog(Shell parent, String ownerRoleId) {
        super(parent);
        this.ownerRoleId = ownerRoleId;
        this.m_treeOnly = false;
    }

    public JobTreeDialog(Shell parent, String ownerRoleId, boolean treeOnly) {
        super(parent);
        this.ownerRoleId = ownerRoleId;
        this.m_treeOnly = treeOnly;
    }

    public JobTreeDialog(Shell parent, String ownerRoleId, JobTreeItem jobTreeItem) {
        super(parent);
        this.ownerRoleId = ownerRoleId;
        this.m_jobTreeItem = jobTreeItem;
        this.m_treeOnly = true;
    }

    public JobTreeDialog(Shell parent, String ownerRoleId, JobTreeItem jobTreeItem, int mode) {
        super(parent);
        this.ownerRoleId = ownerRoleId;
        this.m_jobTreeItem = jobTreeItem;
        this.m_treeOnly = true;
        this.mode = mode;
    }

    protected Point getInitialSize() {
        return new Point(400, 400);
    }

    @Override
    protected void customizeDialog(Composite parent) {
        parent.getShell().setText(Messages.getString((String)"select.job"));
        GridLayout layout = new GridLayout(5, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.treeComposite = this.m_jobTreeItem == null ? new JobTreeComposite(parent, 0, this.ownerRoleId, this.m_treeOnly, false) : (this.mode == 5 ? new JobTreeComposite(parent, 0, this.ownerRoleId, this.m_jobTreeItem, this.mode) : new JobTreeComposite(parent, 0, this.ownerRoleId, this.m_jobTreeItem));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 5;
        this.treeComposite.setLayoutData(gridData);
        this.treeComposite.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                JobTreeDialog.this.okPressed();
            }
        });
    }

    public JobTreeItem getSelectItem() {
        return this.treeComposite.getSelectItem();
    }

    @Override
    protected ValidateResult validate() {
        ValidateResult result = null;
        JobTreeItem item = this.getSelectItem();
        if (item instanceof JobTreeItem) {
            if (item.getData().getType() == -1) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.1"));
            } else if (this.mode == 5 && item.getData().getType() != 2 && item.getData().getType() != 3) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.1"));
            }
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.1"));
        }
        return result;
    }

    @Override
    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }
}

