/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dialog;

import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.calendar.composite.CalendarIdListComposite;
import com.clustercontrol.composite.RoleIdListComposite;
import com.clustercontrol.composite.action.ComboModifyListener;
import com.clustercontrol.composite.action.NumberKeyListener;
import com.clustercontrol.composite.action.StringVerifyListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.action.GetJobKick;
import com.clustercontrol.jobmanagement.dialog.JobTreeDialog;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.InvalidSetting_Exception;
import com.clustercontrol.ws.jobmanagement.InvalidUserPass_Exception;
import com.clustercontrol.ws.jobmanagement.JobKickDuplicate_Exception;
import com.clustercontrol.ws.jobmanagement.JobSchedule;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import java.text.DecimalFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ScheduleDialog
extends CommonDialog {
    private static Log m_log = LogFactory.getLog(ScheduleDialog.class);
    private JobSchedule m_jobSchedule;
    private Text txtJobKickId = null;
    private Text txtJobKickName = null;
    private Text txtJobId = null;
    private Text txtJobName = null;
    private CalendarIdListComposite cmpCalendarId = null;
    private Button btnJobSelect = null;
    private Button btnType1 = null;
    private Button btnType2 = null;
    private Button btnType3 = null;
    private Button btnValid = null;
    private Button btnInvalid = null;
    private Combo cmbHours1 = null;
    private Combo cmbMinutes1 = null;
    private Combo cmbMinutesP = null;
    private Combo cmbMinutesQ = null;
    private Combo cmbDayOfWeek = null;
    private Combo cmbHours2 = null;
    private Combo cmbMinutes2 = null;
    private RoleIdListComposite cmpOwnerRoleId = null;
    private Shell m_shell = null;
    private int mode = 0;
    private String m_jobunitId = null;
    private String m_jobKickId;

    public ScheduleDialog(Shell parent) {
        super(parent);
    }

    public ScheduleDialog(Shell parent, String scheduleId, int mode) {
        super(parent);
        this.m_jobKickId = scheduleId;
        this.mode = mode;
    }

    @Override
    protected void customizeDialog(Composite parent) {
        this.m_shell = this.getShell();
        parent.getShell().setText(Messages.getString((String)"dialog.job.add.modify.schedule"));
        GridLayout baseLayout = new GridLayout(1, true);
        baseLayout.marginWidth = 10;
        baseLayout.marginHeight = 10;
        baseLayout.numColumns = 10;
        parent.setLayout((Layout)baseLayout);
        Composite composite = null;
        GridData gridData = null;
        composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 10;
        composite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)gridData);
        Label labelScheduleId = new Label(composite, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelScheduleId.setText(String.valueOf(Messages.getString((String)"jobkick.id")) + " : ");
        labelScheduleId.setLayoutData((Object)gridData);
        this.txtJobKickId = new Text(composite, 2048);
        this.txtJobKickId.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.txtJobKickId.setLayoutData((Object)gridData);
        this.txtJobKickId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ScheduleDialog.this.update();
            }
        });
        Label labelScheduleName = new Label(composite, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelScheduleName.setText(String.valueOf(Messages.getString((String)"jobkick.name")) + " : ");
        labelScheduleName.setLayoutData((Object)gridData);
        this.txtJobKickName = new Text(composite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.txtJobKickName.setLayoutData((Object)gridData);
        this.txtJobKickName.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        this.txtJobKickName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ScheduleDialog.this.update();
            }
        });
        Label labelRoleId = new Label(composite, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelRoleId.setLayoutData((Object)gridData);
        labelRoleId.setText(String.valueOf(Messages.getString((String)"owner.role.id")) + " : ");
        if (this.mode == 0 || this.mode == 3) {
            this.cmpOwnerRoleId = new RoleIdListComposite(composite, 0, true, RoleIdListComposite.Mode.OWNER_ROLE);
            this.cmpOwnerRoleId.getComboRoleId().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ScheduleDialog.this.cmpCalendarId.setOwnerRoleId(ScheduleDialog.this.cmpOwnerRoleId.getText());
                    ScheduleDialog.this.txtJobId.setText("");
                    ScheduleDialog.this.txtJobName.setText("");
                    ScheduleDialog.this.setJobunitId(null);
                }
            });
        } else {
            this.cmpOwnerRoleId = new RoleIdListComposite(composite, 0, false, RoleIdListComposite.Mode.OWNER_ROLE);
        }
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cmpOwnerRoleId.setLayoutData(gridData);
        Label labelJobId = new Label(composite, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelJobId.setText(String.valueOf(Messages.getString((String)"job.id")) + " : ");
        labelJobId.setLayoutData((Object)gridData);
        this.txtJobId = new Text(composite, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.txtJobId.setLayoutData((Object)gridData);
        this.txtJobId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ScheduleDialog.this.update();
            }
        });
        this.btnJobSelect = new Button(composite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.btnJobSelect.setText(Messages.getString((String)"refer"));
        this.btnJobSelect.setLayoutData((Object)gridData);
        this.btnJobSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobTreeDialog dialog = new JobTreeDialog(ScheduleDialog.this.m_shell, ScheduleDialog.this.cmpOwnerRoleId.getText(), true);
                if (dialog.open() == 0) {
                    JobTreeItem selectItem = dialog.getSelectItem();
                    if (selectItem.getData().getType() != -1) {
                        ScheduleDialog.this.txtJobId.setText(selectItem.getData().getId());
                        ScheduleDialog.this.txtJobName.setText(selectItem.getData().getName());
                        ScheduleDialog.this.setJobunitId(selectItem.getData().getJobunitId());
                    } else {
                        ScheduleDialog.this.txtJobId.setText("");
                        ScheduleDialog.this.txtJobName.setText("");
                        ScheduleDialog.this.setJobunitId(null);
                    }
                }
            }
        });
        Label labelJobName = new Label(composite, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelJobName.setText(String.valueOf(Messages.getString((String)"job.name")) + " : ");
        labelJobName.setLayoutData((Object)gridData);
        this.txtJobName = new Text(composite, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.txtJobName.setLayoutData((Object)gridData);
        Label labelCalendarId = new Label(composite, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelCalendarId.setText(String.valueOf(Messages.getString((String)"calendar.id")) + " : ");
        labelCalendarId.setLayoutData((Object)gridData);
        this.cmpCalendarId = new CalendarIdListComposite(composite, 0, false);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cmpCalendarId.setLayoutData(gridData);
        Group groupSchedule = new Group(parent, 0);
        gridData = null;
        layout = new GridLayout(1, true);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.numColumns = 20;
        groupSchedule.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupSchedule.setLayoutData((Object)gridData);
        groupSchedule.setText(Messages.getString((String)"schedule.setting"));
        this.createType1(groupSchedule);
        this.createType2(groupSchedule);
        this.createType3(groupSchedule);
        Group groupValidOrInvalid = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 6;
        groupValidOrInvalid.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupValidOrInvalid.setLayoutData((Object)gridData);
        groupValidOrInvalid.setText(String.valueOf(Messages.getString((String)"valid")) + "/" + Messages.getString((String)"invalid"));
        this.btnValid = new Button((Composite)groupValidOrInvalid, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.btnValid.setText(ValidConstant.STRING_VALID);
        this.btnValid.setLayoutData((Object)gridData);
        this.btnValid.setSelection(true);
        this.btnInvalid = new Button((Composite)groupValidOrInvalid, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.btnInvalid.setText(ValidConstant.STRING_INVALID);
        this.btnInvalid.setLayoutData((Object)gridData);
        this.adjustDialog();
        this.reflectJobSchedule();
        this.update();
    }

    private void adjustDialog() {
        this.m_shell.pack();
        this.m_shell.setSize(new Point(500, this.m_shell.getSize().y));
        Display display = this.m_shell.getDisplay();
        this.m_shell.setLocation((display.getBounds().width - this.m_shell.getSize().x) / 2, (display.getBounds().height - this.m_shell.getSize().y) / 2);
    }

    private void createType1(Group parent) {
        this.btnType1 = new Button((Composite)parent, 16);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.btnType1.setLayoutData((Object)gridData);
        this.btnType1.setText(Messages.getString((String)"everyday"));
        this.btnType1.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleDialog.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        DecimalFormat format = new DecimalFormat("00");
        Label label = new Label((Composite)parent, 0);
        label.setText(Messages.getString((String)""));
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.cmbHours1 = new Combo((Composite)parent, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cmbHours1.setLayoutData((Object)gridData);
        this.cmbHours1.setTextLimit(2);
        this.cmbHours1.setVisibleItemCount(10);
        this.cmbHours1.addKeyListener((KeyListener)new NumberKeyListener());
        this.cmbHours1.addModifyListener((ModifyListener)new ComboModifyListener());
        format = new DecimalFormat("00");
        this.cmbHours1.add("*");
        int hour = 0;
        while (hour <= 48) {
            this.cmbHours1.add(format.format(hour));
            ++hour;
        }
        this.cmbHours1.select(0);
        this.cmbHours1.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ScheduleDialog.this.update();
            }
        });
        Label labelHours = new Label((Composite)parent, 0);
        labelHours.setText(Messages.getString((String)"hr"));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelHours.setLayoutData((Object)gridData);
        this.cmbMinutes1 = new Combo((Composite)parent, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cmbMinutes1.setLayoutData((Object)gridData);
        this.cmbMinutes1.setTextLimit(2);
        this.cmbMinutes1.setVisibleItemCount(10);
        this.cmbMinutes1.addKeyListener((KeyListener)new NumberKeyListener());
        this.cmbMinutes1.addModifyListener((ModifyListener)new ComboModifyListener());
        format = new DecimalFormat("00");
        int minutes = 0;
        while (minutes < 60) {
            this.cmbMinutes1.add(format.format(minutes));
            ++minutes;
        }
        this.cmbMinutes1.select(0);
        this.cmbMinutes1.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ScheduleDialog.this.update();
            }
        });
        Label labelMinutes = new Label((Composite)parent, 0);
        labelMinutes.setText(Messages.getString((String)"min"));
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelMinutes.setLayoutData((Object)gridData);
    }

    private void createType2(Group parent) {
        this.btnType2 = new Button((Composite)parent, 16);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.btnType2.setLayoutData((Object)gridData);
        this.btnType2.setText(Messages.getString((String)"schedule.everyweek"));
        this.btnType2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleDialog.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.cmbDayOfWeek = new Combo((Composite)parent, 0x1000008);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cmbDayOfWeek.setLayoutData((Object)gridData);
        this.cmbDayOfWeek.setTextLimit(3);
        this.cmbDayOfWeek.setVisibleItemCount(10);
        this.cmbDayOfWeek.add(DayOfWeekConstant.STRING_SUNDAY);
        this.cmbDayOfWeek.add(DayOfWeekConstant.STRING_MONDAY);
        this.cmbDayOfWeek.add(DayOfWeekConstant.STRING_TUESDAY);
        this.cmbDayOfWeek.add(DayOfWeekConstant.STRING_WEDNESDAY);
        this.cmbDayOfWeek.add(DayOfWeekConstant.STRING_THURSDAY);
        this.cmbDayOfWeek.add(DayOfWeekConstant.STRING_FRIDAY);
        this.cmbDayOfWeek.add(DayOfWeekConstant.STRING_SATURDAY);
        this.cmbDayOfWeek.select(0);
        this.cmbDayOfWeek.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ScheduleDialog.this.update();
            }
        });
        this.cmbHours2 = new Combo((Composite)parent, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cmbHours2.setLayoutData((Object)gridData);
        this.cmbHours2.setTextLimit(2);
        this.cmbHours2.setVisibleItemCount(10);
        this.cmbHours2.addKeyListener((KeyListener)new NumberKeyListener());
        this.cmbHours2.addModifyListener((ModifyListener)new ComboModifyListener());
        DecimalFormat format = new DecimalFormat("00");
        this.cmbHours2.add("*");
        int hour = 0;
        while (hour <= 48) {
            this.cmbHours2.add(format.format(hour));
            ++hour;
        }
        this.cmbHours2.select(0);
        this.cmbHours2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ScheduleDialog.this.update();
            }
        });
        Label labelHours = new Label((Composite)parent, 0);
        labelHours.setText(Messages.getString((String)"hr"));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelHours.setLayoutData((Object)gridData);
        this.cmbMinutes2 = new Combo((Composite)parent, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cmbMinutes2.setLayoutData((Object)gridData);
        this.cmbMinutes2.setTextLimit(2);
        this.cmbMinutes2.setVisibleItemCount(10);
        this.cmbMinutes2.addKeyListener((KeyListener)new NumberKeyListener());
        this.cmbMinutes2.addModifyListener((ModifyListener)new ComboModifyListener());
        format = new DecimalFormat("00");
        int minutes = 0;
        while (minutes < 60) {
            this.cmbMinutes2.add(format.format(minutes));
            ++minutes;
        }
        this.cmbMinutes2.select(0);
        this.cmbMinutes2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ScheduleDialog.this.update();
            }
        });
        Label labelMinutes = new Label((Composite)parent, 0);
        labelMinutes.setText(Messages.getString((String)"min"));
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelMinutes.setLayoutData((Object)gridData);
    }

    private void createType3(Group parent) {
        this.btnType3 = new Button((Composite)parent, 16);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.btnType3.setLayoutData((Object)gridData);
        this.btnType3.setText(Messages.getString((String)"hourly"));
        this.btnType3.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleDialog.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.cmbMinutesP = new Combo((Composite)parent, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cmbMinutesP.setLayoutData((Object)gridData);
        this.cmbMinutesP.setTextLimit(2);
        this.cmbMinutesP.setVisibleItemCount(10);
        this.cmbMinutesP.addKeyListener((KeyListener)new NumberKeyListener());
        this.cmbMinutesP.addModifyListener((ModifyListener)new ComboModifyListener());
        DecimalFormat format = new DecimalFormat("00");
        this.cmbMinutesP.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ScheduleDialog.this.update();
            }
        });
        Label labelMinutesFrom = new Label((Composite)parent, 0);
        labelMinutesFrom.setText(Messages.getString((String)"schedule.min.start.time"));
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelMinutesFrom.setLayoutData((Object)gridData);
        this.cmbMinutesQ = new Combo((Composite)parent, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cmbMinutesQ.setLayoutData((Object)gridData);
        this.cmbMinutesQ.setTextLimit(2);
        this.cmbMinutesQ.setVisibleItemCount(10);
        this.cmbMinutesQ.addKeyListener((KeyListener)new NumberKeyListener());
        this.cmbMinutesQ.addModifyListener((ModifyListener)new ComboModifyListener());
        format = new DecimalFormat("00");
        this.cmbMinutesQ.add(format.format(5L));
        this.cmbMinutesQ.add(format.format(10L));
        this.cmbMinutesQ.add(format.format(15L));
        this.cmbMinutesQ.add(format.format(20L));
        this.cmbMinutesQ.add(format.format(30L));
        this.cmbMinutesQ.select(0);
        this.cmbMinutesQ.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DecimalFormat format = new DecimalFormat("00");
                int tmp = new Integer(ScheduleDialog.this.cmbMinutesP.getSelectionIndex());
                try {
                    int minutesQ = Integer.parseInt(ScheduleDialog.this.cmbMinutesQ.getText());
                    ScheduleDialog.this.cmbMinutesP.removeAll();
                    int minutes = 0;
                    while (minutes < minutesQ) {
                        ScheduleDialog.this.cmbMinutesP.add(format.format(minutes));
                        ++minutes;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    ScheduleDialog.this.cmbMinutesQ.setText("05");
                }
                if (ScheduleDialog.this.cmbMinutesP.getItemCount() > tmp) {
                    ScheduleDialog.this.cmbMinutesP.select(tmp);
                }
                ScheduleDialog.this.update();
            }
        });
        int minutesQ = Integer.parseInt(this.cmbMinutesQ.getText());
        int minutes = 0;
        while (minutes < minutesQ) {
            this.cmbMinutesP.add(format.format(minutes));
            ++minutes;
        }
        Label labelMinutesTo = new Label((Composite)parent, 0);
        labelMinutesTo.setText(Messages.getString((String)"schedule.min.execution.interval"));
        gridData = new GridData();
        gridData.horizontalSpan = 7;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelMinutesTo.setLayoutData((Object)gridData);
    }

    public void update() {
        if ("".equals(this.txtJobKickId.getText())) {
            this.txtJobKickId.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.txtJobKickId.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.txtJobKickName.getText())) {
            this.txtJobKickName.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.txtJobKickName.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.txtJobId.getText())) {
            this.txtJobId.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.txtJobId.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.cmbMinutes1.getEnabled() && "".equals(this.cmbMinutes1.getText())) {
            this.cmbMinutes1.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.cmbMinutes1.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.cmbDayOfWeek.getEnabled() && "".equals(this.cmbDayOfWeek.getText())) {
            this.cmbDayOfWeek.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.cmbDayOfWeek.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.cmbMinutes2.getEnabled() && "".equals(this.cmbMinutes2.getText())) {
            this.cmbMinutes2.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.cmbMinutes2.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.cmbMinutesP.getEnabled() && "".equals(this.cmbMinutesP.getText())) {
            this.cmbMinutesP.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.cmbMinutesP.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.cmbMinutesQ.getEnabled() && "".equals(this.cmbMinutesQ.getText())) {
            this.cmbMinutesQ.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.cmbMinutesQ.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.btnType1.getSelection()) {
            this.btnType1.setSelection(true);
            this.btnType2.setSelection(false);
            this.btnType3.setSelection(false);
            this.cmbHours1.setEnabled(true);
            this.cmbMinutes1.setEnabled(true);
            this.cmbDayOfWeek.setEnabled(false);
            this.cmbHours2.setEnabled(false);
            this.cmbMinutes2.setEnabled(false);
            this.cmbMinutesP.setEnabled(false);
            this.cmbMinutesQ.setEnabled(false);
        } else if (this.btnType2.getSelection()) {
            this.btnType1.setSelection(false);
            this.btnType2.setSelection(true);
            this.btnType3.setSelection(false);
            this.cmbHours1.setEnabled(false);
            this.cmbMinutes1.setEnabled(false);
            this.cmbDayOfWeek.setEnabled(true);
            this.cmbHours2.setEnabled(true);
            this.cmbMinutes2.setEnabled(true);
            this.cmbMinutesP.setEnabled(false);
            this.cmbMinutesQ.setEnabled(false);
        } else if (this.btnType3.getSelection()) {
            this.btnType1.setSelection(false);
            this.btnType2.setSelection(false);
            this.btnType3.setSelection(true);
            this.cmbHours1.setEnabled(false);
            this.cmbMinutes1.setEnabled(false);
            this.cmbDayOfWeek.setEnabled(false);
            this.cmbHours2.setEnabled(false);
            this.cmbMinutes2.setEnabled(false);
            this.cmbMinutesP.setEnabled(true);
            this.cmbMinutesQ.setEnabled(true);
        }
    }

    private void reflectJobSchedule() {
        int i;
        JobSchedule jobschedule = null;
        if (this.mode == 1 || this.mode == 3) {
            jobschedule = GetJobKick.getJobSchedule(this.m_jobKickId);
        } else {
            jobschedule = new JobSchedule();
            this.btnType1.setSelection(true);
            this.cmbHours1.setEnabled(true);
            this.cmbMinutes1.setEnabled(true);
            this.cmbDayOfWeek.setEnabled(false);
            this.cmbHours2.setEnabled(false);
            this.cmbMinutes2.setEnabled(false);
        }
        this.m_jobSchedule = jobschedule;
        if (jobschedule != null && jobschedule.getOwnerRoleId() != null) {
            this.cmpOwnerRoleId.setText(jobschedule.getOwnerRoleId());
        }
        this.cmpCalendarId.setOwnerRoleId(this.cmpOwnerRoleId.getText());
        if (jobschedule.getId() != null) {
            this.txtJobKickId.setText(jobschedule.getId());
            this.m_jobKickId = jobschedule.getId();
            if (this.mode == 1) {
                this.txtJobKickId.setEnabled(false);
            }
        }
        if (jobschedule.getName() != null) {
            this.txtJobKickName.setText(jobschedule.getName());
        }
        if (jobschedule.getJobId() != null) {
            this.txtJobId.setText(jobschedule.getJobId());
        }
        if (jobschedule.getJobName() != null) {
            this.txtJobName.setText(jobschedule.getJobName());
        }
        if (jobschedule.getJobunitId() != null) {
            String jobunitId = jobschedule.getJobunitId();
            this.setJobunitId(jobunitId);
        }
        if (jobschedule.getCalendarId() != null) {
            if (!this.cmpCalendarId.getEnabled()) {
                this.cmpCalendarId.addText(jobschedule.getCalendarId());
            }
            this.cmpCalendarId.setText(jobschedule.getCalendarId());
        }
        DecimalFormat format = new DecimalFormat("00");
        if (jobschedule.getScheduleType() == 1) {
            this.btnType1.setSelection(true);
            if (jobschedule.getHour() != null) {
                this.cmbHours1.select(0);
                i = 0;
                while (i < this.cmbHours1.getItemCount()) {
                    String hours = format.format(jobschedule.getHour());
                    if (hours.equals(this.cmbHours1.getItem(i))) {
                        this.cmbHours1.select(i);
                        break;
                    }
                    ++i;
                }
            }
            if (jobschedule.getMinute() != null) {
                this.cmbMinutes1.select(0);
                i = 0;
                while (i < this.cmbMinutes1.getItemCount()) {
                    String minutes = format.format(jobschedule.getMinute());
                    if (minutes.equals(this.cmbMinutes1.getItem(i))) {
                        this.cmbMinutes1.select(i);
                        break;
                    }
                    ++i;
                }
            }
        } else if (jobschedule.getScheduleType() == 2) {
            this.btnType2.setSelection(true);
            this.cmbDayOfWeek.select(0);
            i = 0;
            while (i < this.cmbDayOfWeek.getItemCount()) {
                if (jobschedule.getWeek() == null) break;
                String dayOfWeek = DayOfWeekConstant.typeToString(jobschedule.getWeek());
                if (dayOfWeek.equals(this.cmbDayOfWeek.getItem(i))) {
                    this.cmbDayOfWeek.select(i);
                    break;
                }
                ++i;
            }
            if (jobschedule.getHour() != null) {
                this.cmbHours2.select(0);
                i = 0;
                while (i < this.cmbHours2.getItemCount()) {
                    String hours = format.format(jobschedule.getHour());
                    if (hours.equals(this.cmbHours2.getItem(i))) {
                        this.cmbHours2.select(i);
                        break;
                    }
                    ++i;
                }
            }
            if (jobschedule.getMinute() != null) {
                this.cmbMinutes2.select(0);
                i = 0;
                while (i < this.cmbMinutes2.getItemCount()) {
                    String minutes = format.format(jobschedule.getMinute());
                    if (minutes.equals(this.cmbMinutes2.getItem(i))) {
                        this.cmbMinutes2.select(i);
                        break;
                    }
                    ++i;
                }
            }
        } else if (jobschedule.getScheduleType() == 3) {
            String minutes;
            this.btnType3.setSelection(true);
            if (jobschedule.getEveryXminutes() != null) {
                this.cmbMinutesQ.select(0);
                i = 0;
                while (i < this.cmbMinutesQ.getItemCount()) {
                    minutes = format.format(jobschedule.getEveryXminutes());
                    if (minutes.equals(this.cmbMinutesQ.getItem(i))) {
                        this.cmbMinutesQ.select(i);
                        break;
                    }
                    ++i;
                }
            }
            if (jobschedule.getFromXminutes() != null) {
                this.cmbMinutesP.select(0);
                i = 0;
                while (i < this.cmbMinutesP.getItemCount()) {
                    minutes = format.format(jobschedule.getFromXminutes());
                    if (minutes.equals(this.cmbMinutesP.getItem(i))) {
                        this.cmbMinutesP.select(i);
                        break;
                    }
                    ++i;
                }
            }
        }
        if (jobschedule.getValid() != null) {
            Integer effective = jobschedule.getValid();
            if (effective == 1) {
                this.btnValid.setSelection(true);
                this.btnInvalid.setSelection(false);
            } else {
                this.btnValid.setSelection(false);
                this.btnInvalid.setSelection(true);
            }
        }
        this.update();
    }

    private ValidateResult createJobSchedule() {
        ValidateResult result = null;
        this.m_jobSchedule = new JobSchedule();
        if (this.getJobunitId() != null) {
            this.m_jobSchedule.setJobunitId(this.getJobunitId());
        }
        if (this.cmpOwnerRoleId.getText().length() > 0) {
            this.m_jobSchedule.setOwnerRoleId(this.cmpOwnerRoleId.getText());
        }
        if (this.txtJobKickId.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.88"));
            return result;
        }
        this.m_jobSchedule.setId(this.txtJobKickId.getText());
        this.m_jobKickId = this.txtJobKickId.getText();
        if (this.txtJobKickName.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.89"));
            return result;
        }
        this.m_jobSchedule.setName(this.txtJobKickName.getText());
        if (this.txtJobId.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.22"));
            return result;
        }
        this.m_jobSchedule.setJobId(this.txtJobId.getText());
        if (this.txtJobName.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.23"));
            return result;
        }
        this.m_jobSchedule.setJobName(this.txtJobName.getText());
        if (this.cmpCalendarId.getText().length() > 0) {
            this.m_jobSchedule.setCalendarId(this.cmpCalendarId.getText());
        } else {
            this.m_jobSchedule.setCalendarId("");
        }
        Integer hours = null;
        Integer minutes = null;
        Integer week = null;
        Integer fromXminutes = null;
        Integer everyXminutes = null;
        if (this.btnType1.getSelection()) {
            this.m_jobSchedule.setScheduleType(1);
            if (this.cmbHours1.getText().length() > 0) {
                hours = this.cmbHours1.getText().equals("*") ? null : new Integer(this.cmbHours1.getText());
            }
            if (this.cmbMinutes1.getText().length() > 0) {
                minutes = new Integer(this.cmbMinutes1.getText());
            }
            this.m_jobSchedule.setHour(hours);
            this.m_jobSchedule.setMinute(minutes);
        } else if (this.btnType2.getSelection()) {
            this.m_jobSchedule.setScheduleType(2);
            if (this.cmbDayOfWeek.getText().length() <= 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.37"));
                return result;
            }
            week = new Integer(DayOfWeekConstant.stringToType(this.cmbDayOfWeek.getText()));
            if (this.cmbHours2.getText().length() > 0) {
                hours = this.cmbHours2.getText().equals("*") ? null : new Integer(this.cmbHours2.getText());
            }
            if (this.cmbMinutes2.getText().length() > 0) {
                minutes = new Integer(this.cmbMinutes2.getText());
            }
            this.m_jobSchedule.setWeek(week);
            this.m_jobSchedule.setHour(hours);
            this.m_jobSchedule.setMinute(minutes);
        } else if (this.btnType3.getSelection()) {
            this.m_jobSchedule.setScheduleType(3);
            if (this.cmbMinutesP.getText().length() > 0) {
                fromXminutes = new Integer(this.cmbMinutesP.getText());
            }
            if (this.cmbMinutesQ.getText().length() > 0) {
                everyXminutes = new Integer(this.cmbMinutesQ.getText());
            }
            this.m_jobSchedule.setFromXminutes(fromXminutes);
            this.m_jobSchedule.setEveryXminutes(everyXminutes);
        }
        if (this.btnValid.getSelection()) {
            this.m_jobSchedule.setValid(Integer.valueOf(1));
        } else {
            this.m_jobSchedule.setValid(Integer.valueOf(0));
        }
        return result;
    }

    @Override
    protected String getOkButtonText() {
        return Messages.getString((String)"register");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    @Override
    protected ValidateResult validate() {
        ValidateResult result = null;
        result = this.createJobSchedule();
        if (result != null) {
            return result;
        }
        return null;
    }

    public String getJobunitId() {
        return this.m_jobunitId;
    }

    public void setJobunitId(String jobunitId) {
        this.m_jobunitId = jobunitId;
    }

    @Override
    protected boolean action() {
        boolean result = false;
        try {
            if (this.mode == 1) {
                JobEndpointWrapper.modifySchedule(this.m_jobSchedule);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.job.77"));
            } else {
                JobEndpointWrapper.addSchedule(this.m_jobSchedule);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.job.79"));
            }
            result = true;
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (JobKickDuplicate_Exception e) {
            Object[] args = new String[]{this.m_jobSchedule.getId()};
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.job.83", (Object[])args)) + " " + e.getMessage()));
        }
        catch (InvalidUserPass_Exception e) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.job.74")) + " " + e.getMessage()));
        }
        catch (InvalidSetting_Exception e) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.job.74")) + " " + e.getMessage()));
        }
        catch (Exception e) {
            m_log.warn((Object)("action(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        return result;
    }
}

