/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.action.WaitRuleProperty;
import com.clustercontrol.jobmanagement.bean.JudgmentObjectConstant;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.viewer.PropertySheet;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class WaitRuleDialog
extends CommonDialog {
    private PropertySheet m_viewer = null;
    private final int sizeY = 400;
    private Shell m_shell = null;
    private ArrayList m_startCondition = null;
    private JobTreeItem m_jobTreeItem = null;

    public WaitRuleDialog(Shell parent, JobTreeItem jobTreeItem) {
        super(parent);
        this.m_jobTreeItem = jobTreeItem;
    }

    @Override
    protected void customizeDialog(Composite parent) {
        this.m_shell = this.getShell();
        String displayJobId = this.m_jobTreeItem.getData().getId();
        String displayJobName = this.m_jobTreeItem.getData().getName();
        if (displayJobId != null && !"".equals(displayJobId) && displayJobName != null && !"".equals(displayJobName)) {
            parent.getShell().setText(String.valueOf(Messages.getString((String)"wait.rule")) + " : " + displayJobName + "(" + displayJobId + ")");
        } else {
            parent.getShell().setText(Messages.getString((String)"wait.rule"));
        }
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout((Layout)layout);
        Label tableTitle = new Label(parent, 0);
        tableTitle.setText(String.valueOf(Messages.getString((String)"attribute")) + " : ");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        tableTitle.setLayoutData((Object)gridData);
        TableTree table = new TableTree(parent, 68354);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.m_viewer = new PropertySheet(table);
        this.m_viewer.setInput(new WaitRuleProperty().getProperty(this.m_jobTreeItem, 0));
        this.m_viewer.expandAll();
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData((Object)gridData);
        Display display = this.m_shell.getDisplay();
        this.m_shell.setLocation((display.getBounds().width - this.m_shell.getSize().x) / 2, (display.getBounds().height - this.m_shell.getSize().y) / 2);
        this.m_shell.pack();
        this.m_shell.setSize(new Point(this.m_shell.getSize().x, 400));
        this.reflectStartCondition();
        this.m_viewer.expandAll();
    }

    private void reflectStartCondition() {
        Property property = null;
        if (this.m_startCondition instanceof ArrayList) {
            Integer type = (Integer)this.m_startCondition.get(0);
            if (type == 0) {
                property = new WaitRuleProperty().getProperty(this.m_jobTreeItem, 0);
                ArrayList<Property> propertyList = PropertyUtil.getProperty(property, "judgmentObject");
                Property judgmentObject = propertyList.get(0);
                Object[][] values = judgmentObject.getSelectValues();
                judgmentObject.setValue(JudgmentObjectConstant.STRING_JOB_END_STATUS);
                HashMap map = (HashMap)values[1][0];
                ArrayList list = (ArrayList)map.get("property");
                String jobId = (String)this.m_startCondition.get(1);
                ((Property)list.get(0)).setValue(jobId);
                String value = (String)this.m_startCondition.get(2);
                ((Property)list.get(1)).setValue(value);
            } else if (type == 1) {
                property = new WaitRuleProperty().getProperty(this.m_jobTreeItem, 1);
                ArrayList<Property> propertyList = PropertyUtil.getProperty(property, "judgmentObject");
                Property judgmentObject = propertyList.get(0);
                Object[][] values = judgmentObject.getSelectValues();
                judgmentObject.setValue(JudgmentObjectConstant.STRING_JOB_END_VALUE);
                HashMap map = (HashMap)values[1][1];
                ArrayList list = (ArrayList)map.get("property");
                String jobId = (String)this.m_startCondition.get(1);
                ((Property)list.get(0)).setValue(jobId);
                Integer value = (Integer)this.m_startCondition.get(2);
                ((Property)list.get(1)).setValue(value);
            } else {
                property = new WaitRuleProperty().getProperty(this.m_jobTreeItem, 2);
                ArrayList<Property> propertyList = PropertyUtil.getProperty(property, "judgmentObject");
                Property judgmentObject = propertyList.get(0);
                Object[][] values = judgmentObject.getSelectValues();
                judgmentObject.setValue(JudgmentObjectConstant.STRING_TIME);
                HashMap map = (HashMap)values[1][2];
                ArrayList list = (ArrayList)map.get("property");
                Date time = (Date)this.m_startCondition.get(2);
                ((Property)list.get(0)).setValue(time);
            }
            this.m_viewer.setInput(property);
            this.m_viewer.refresh();
        }
    }

    private ValidateResult createStartCondition() {
        ValidateResult result = null;
        this.m_startCondition = new ArrayList();
        Property property = (Property)this.m_viewer.getInput();
        ArrayList values = PropertyUtil.getPropertyValue(property, "judgmentObject");
        String type = (String)values.get(0);
        this.m_startCondition.add(new Integer(JudgmentObjectConstant.stringToType((String)type)));
        if (type.equals(JudgmentObjectConstant.STRING_JOB_END_STATUS)) {
            String jobId = "";
            values = PropertyUtil.getPropertyValue(property, "jobId");
            if (values.get(0) instanceof JobTreeItem) {
                JobTreeItem item = (JobTreeItem)values.get(0);
                jobId = item.getData().getId();
            } else if (values.get(0) instanceof String) {
                jobId = (String)values.get(0);
            }
            if (jobId == null || jobId.length() == 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.22"));
                return result;
            }
            this.m_startCondition.add(jobId);
            values = PropertyUtil.getPropertyValue(property, "conditionEndStatus");
            String value = (String)values.get(0);
            if (value == null || value.length() == 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.17"));
                return result;
            }
            this.m_startCondition.add(value);
        } else if (type.equals(JudgmentObjectConstant.STRING_JOB_END_VALUE)) {
            String jobId = "";
            values = PropertyUtil.getPropertyValue(property, "jobId");
            if (values.get(0) instanceof JobTreeItem) {
                JobTreeItem item = (JobTreeItem)values.get(0);
                jobId = item.getData().getId();
            } else if (values.get(0) instanceof String) {
                jobId = (String)values.get(0);
            }
            if (jobId == null || jobId.length() == 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.22"));
                return result;
            }
            this.m_startCondition.add(jobId);
            values = PropertyUtil.getPropertyValue(property, "conditionEndValue");
            Object value = values.get(0);
            if (value == null || !(value instanceof Integer)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.17"));
                return result;
            }
            this.m_startCondition.add((Integer)value);
        } else {
            this.m_startCondition.add("");
            values = PropertyUtil.getPropertyValue(property, "time");
            Date startTime = null;
            if (values.get(0) instanceof Date) {
                startTime = (Date)values.get(0);
            }
            if (startTime == null) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.18"));
                return result;
            }
            this.m_startCondition.add(startTime);
        }
        return null;
    }

    protected Point getInitialSize() {
        return new Point(350, 400);
    }

    public void setInputData(ArrayList list) {
        this.m_startCondition = list;
    }

    public ArrayList getInputData() {
        return this.m_startCondition;
    }

    @Override
    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    @Override
    protected ValidateResult validate() {
        ValidateResult result = null;
        result = this.createStartCondition();
        if (result != null) {
            return result;
        }
        return null;
    }
}

