/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.util;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.jobmanagement.bean.JobTriggerTypeConstant;
import com.clustercontrol.jobmanagement.bean.OperationConstant;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.ws.jobmanagement.HinemosUnknown_Exception;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.JobHistoryFilter;
import com.clustercontrol.ws.jobmanagement.JobInfo;
import com.clustercontrol.ws.jobmanagement.JobMasterNotFound_Exception;
import com.clustercontrol.ws.jobmanagement.JobOperationInfo;
import com.clustercontrol.ws.jobmanagement.JobPlanFilter;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import com.clustercontrol.ws.jobmanagement.NotifyNotFound_Exception;
import com.clustercontrol.ws.jobmanagement.UserNotFound_Exception;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobPropertyUtil {
    private static Log m_log = LogFactory.getLog(JobPropertyUtil.class);

    public static JobOperationInfo property2jobOperation(Property property) {
        JobOperationInfo info = new JobOperationInfo();
        ArrayList values = PropertyUtil.getPropertyValue(property, "session");
        if (values.get(0) instanceof String && ((String)values.get(0)).length() > 0) {
            info.setSessionId((String)values.get(0));
        }
        if ((values = PropertyUtil.getPropertyValue(property, "jobUnit")).get(0) instanceof String && ((String)values.get(0)).length() > 0) {
            info.setJobunitId((String)values.get(0));
        }
        if ((values = PropertyUtil.getPropertyValue(property, "job")).get(0) instanceof String && ((String)values.get(0)).length() > 0) {
            info.setJobId((String)values.get(0));
        }
        if ((values = PropertyUtil.getPropertyValue(property, "facility")).size() > 0 && values.get(0) instanceof String && ((String)values.get(0)).length() > 0) {
            info.setFacilityId((String)values.get(0));
        }
        values = PropertyUtil.getPropertyValue(property, "control");
        Integer control = null;
        if (values.get(0) instanceof String) {
            String controlString = (String)values.get(0);
            control = OperationConstant.stringToType((String)controlString);
            info.setControl(control);
        }
        if ((values = PropertyUtil.getPropertyValue(property, "endStatus")).size() > 0 && values.get(0) instanceof Integer) {
            info.setEndStatus((Integer)values.get(0));
        }
        if ((values = PropertyUtil.getPropertyValue(property, "endValue")).size() > 0 && values.get(0) instanceof Integer) {
            info.setEndValue((Integer)values.get(0));
        }
        return info;
    }

    public static JobHistoryFilter property2jobHistoryFilter(Property property) {
        JobHistoryFilter filter = new JobHistoryFilter();
        ArrayList values = null;
        values = PropertyUtil.getPropertyValue(property, "startFromDate");
        if (values.get(0) != null && values.get(0) instanceof Date) {
            filter.setStartFromDate(Long.valueOf(((Date)values.get(0)).getTime()));
        }
        if ((values = PropertyUtil.getPropertyValue(property, "startToDate")).get(0) != null && values.get(0) instanceof Date) {
            filter.setStartToDate(Long.valueOf(((Date)values.get(0)).getTime()));
        }
        if ((values = PropertyUtil.getPropertyValue(property, "endFromDate")).get(0) != null && values.get(0) instanceof Date) {
            filter.setEndFromDate(Long.valueOf(((Date)values.get(0)).getTime()));
        }
        if ((values = PropertyUtil.getPropertyValue(property, "endToDate")).get(0) != null && values.get(0) instanceof Date) {
            filter.setEndToDate(Long.valueOf(((Date)values.get(0)).getTime()));
        }
        if ((values = PropertyUtil.getPropertyValue(property, "jobId")).get(0) instanceof JobTreeItem) {
            filter.setJobId(((JobTreeItem)values.get(0)).getData().getId());
        } else if (values.get(0) instanceof String && ((String)values.get(0)).length() > 0) {
            filter.setJobId((String)values.get(0));
        }
        values = PropertyUtil.getPropertyValue(property, "status");
        Integer status = null;
        if (values.get(0) instanceof String) {
            String statusString = (String)values.get(0);
            status = StatusConstant.stringToType((String)statusString);
            filter.setStatus(status);
        }
        values = PropertyUtil.getPropertyValue(property, "triggerType");
        Integer triggerType = null;
        if (values.get(0) instanceof String) {
            String triggerTypeString = (String)values.get(0);
            triggerType = JobTriggerTypeConstant.stringToType((String)triggerTypeString);
            filter.setTriggerType(triggerType);
        }
        values = PropertyUtil.getPropertyValue(property, "triggerInfo");
        String triggerInfo = null;
        if (!"".equals(values.get(0))) {
            triggerInfo = (String)values.get(0);
            filter.setTriggerInfo(triggerInfo);
        }
        values = PropertyUtil.getPropertyValue(property, "ownerRoleId");
        String ownerRoleId = null;
        if (!"".equals(values.get(0))) {
            ownerRoleId = (String)values.get(0);
            filter.setOwnerRoleId(ownerRoleId);
        }
        return filter;
    }

    public static JobPlanFilter property2jobPlanFilter(Property property) {
        JobPlanFilter filter = new JobPlanFilter();
        ArrayList values = null;
        values = PropertyUtil.getPropertyValue(property, "fromDate");
        m_log.trace((Object)"JobPlanFilter fromDate :");
        if (values.get(0) != null && values.get(0) instanceof Date) {
            m_log.trace((Object)(" " + ((Date)values.get(0)).getTime()));
            filter.setFromDate(Long.valueOf(((Date)values.get(0)).getTime()));
        }
        values = PropertyUtil.getPropertyValue(property, "toDate");
        m_log.trace((Object)"JobPlanFilter toDate :");
        if (values.get(0) != null && values.get(0) instanceof Date) {
            m_log.trace((Object)(" " + ((Date)values.get(0)).getTime()));
            filter.setToDate(Long.valueOf(((Date)values.get(0)).getTime()));
        }
        if ((values = PropertyUtil.getPropertyValue(property, "scheduleId")).get(0) != null) {
            m_log.trace((Object)(" " + (String)values.get(0)));
            filter.setJobKickId((String)values.get(0));
        }
        return filter;
    }

    public static void setJobFullTree(JobTreeItem jobTreeItem) {
        JobPropertyUtil.setJobFull(jobTreeItem.getData());
        List children = jobTreeItem.getChildren();
        if (children == null) {
            return;
        }
        for (JobTreeItem child : children) {
            JobPropertyUtil.setJobFullTree(child);
        }
    }

    public static void setJobFull(JobInfo jobInfo) {
        if (jobInfo.isPropertyFull()) {
            return;
        }
        if (jobInfo.getId() == null || "".equals(jobInfo.getId())) {
            return;
        }
        JobInfo ret = null;
        try {
            ret = JobEndpointWrapper.getJobFull(jobInfo);
        }
        catch (JobMasterNotFound_Exception e) {
            m_log.warn((Object)("setJobFull(), " + e.getMessage()), (Throwable)e);
            return;
        }
        catch (NotifyNotFound_Exception e) {
            m_log.warn((Object)("setJobFull() getJobFull, " + e.getMessage()), (Throwable)e);
            return;
        }
        catch (UserNotFound_Exception e) {
            m_log.warn((Object)("setJobFull() getJobFull, " + e.getMessage()), (Throwable)e);
            return;
        }
        catch (HinemosUnknown_Exception e) {
            m_log.warn((Object)("setJobFull() getJobFull, " + e.getMessage()), (Throwable)e);
            return;
        }
        catch (InvalidRole_Exception e) {
            m_log.warn((Object)("setJobFull() getJobFull, " + e.getMessage()), (Throwable)e);
            return;
        }
        catch (Exception e) {
            m_log.warn((Object)("setJobFull() getJobFull, " + e.getMessage()), (Throwable)e);
        }
        jobInfo.setCommand(ret.getCommand());
        jobInfo.setCreateTime(ret.getCreateTime());
        jobInfo.setCreateUser(ret.getCreateUser());
        jobInfo.setDescription(ret.getDescription());
        jobInfo.setOwnerRoleId(ret.getOwnerRoleId());
        List jobEndStatusInfoList = jobInfo.getEndStatus();
        jobEndStatusInfoList.clear();
        if (ret.getEndStatus() != null) {
            jobEndStatusInfoList.addAll(ret.getEndStatus());
        }
        jobInfo.setFile(ret.getFile());
        List jobNotificationsInfoList = jobInfo.getNotifications();
        jobNotificationsInfoList.clear();
        if (ret.getNotifications() != null) {
            jobNotificationsInfoList.addAll(ret.getNotifications());
        }
        List jobParameterInfoList = jobInfo.getParam();
        jobParameterInfoList.clear();
        if (ret.getParam() != null) {
            jobParameterInfoList.addAll(ret.getParam());
        }
        jobInfo.setPropertyFull(true);
        jobInfo.setType(ret.getType());
        jobInfo.setUpdateTime(ret.getUpdateTime());
        jobInfo.setUpdateUser(ret.getUpdateUser());
        jobInfo.setWaitRule(ret.getWaitRule());
        if (ret.getReferJobUnitId() != null) {
            jobInfo.setReferJobUnitId(ret.getReferJobUnitId());
        }
        if (ret.getReferJobId() != null) {
            jobInfo.setReferJobId(ret.getReferJobId());
        }
    }
}

