/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.view;

import com.clustercontrol.jobmanagement.composite.DetailComposite;
import com.clustercontrol.view.CommonViewPart;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class JobDetailView
extends CommonViewPart {
    public static final String ID = "com.clustercontrol.jobmanagement.view.JobDetailView";
    private DetailComposite m_detail = null;

    @Override
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_detail = new DetailComposite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.m_detail.setLayoutData(gridData);
        this.createContextMenu();
        this.update(null, null);
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                JobDetailView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.m_detail.getTable());
        this.m_detail.getTable().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem startJobAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.StartJobAction");
        ActionContributionItem stopJobAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.StopJobAction");
        manager.add(startJobAction.getAction());
        manager.add(stopJobAction.getAction());
    }

    public void update(String sessionId, String jobunitId) {
        this.m_detail.update(sessionId, jobunitId);
    }

    public DetailComposite getComposite() {
        return this.m_detail;
    }

    public void setEnabledAction(int num, ISelection selection) {
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.StartJobAction", selection);
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.StopJobAction", selection);
        if (num > 0) {
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.StartJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.StopJobAction", true);
        } else {
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.StartJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.StopJobAction", false);
        }
    }
}

