/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.view.action;

import com.clustercontrol.jobmanagement.util.JobEditStateUtil;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.jobmanagement.view.JobListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.JobInfo;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class CancelJobAction
implements IViewActionDelegate {
    private static Log m_log = LogFactory.getLog(CancelJobAction.class);
    private IViewPart m_view;

    public void init(IViewPart view) {
        this.m_view = view;
    }

    public void run(IAction action) {
        if (this.m_view instanceof JobListView) {
            JobListView view = (JobListView)this.m_view.getAdapter(JobListView.class);
            String message = JobEditStateUtil.isEdit() ? String.valueOf(Messages.getString((String)"message.job.43")) + "\n" + Messages.getString((String)"message.job.30") : Messages.getString((String)"message.job.30");
            if (MessageDialog.openQuestion(null, (String)Messages.getString((String)"confirmed"), (String)message)) {
                block10: {
                    m_log.debug((Object)("CancelJob start " + new Date()));
                    try {
                        for (JobInfo info : JobEditStateUtil.getLockedJobunitList()) {
                            JobEndpointWrapper.releaseEditLock(JobEditStateUtil.getEditSession(info));
                        }
                    }
                    catch (InvalidRole_Exception invalidRole_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                        JobEditStateUtil.clearEditStateAll();
                        break block10;
                    }
                    catch (Exception e) {
                        try {
                            m_log.warn((Object)("updateJobunitUpdateTime() : " + e.getMessage()), (Throwable)e);
                            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
                            break block10;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            JobEditStateUtil.clearEditStateAll();
                        }
                    }
                    JobEditStateUtil.clearEditStateAll();
                }
                view.update();
                view.getJobTreeComposite().refresh();
                m_log.debug((Object)("CancelJob end " + new Date()));
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

