/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.view.action;

import com.clustercontrol.jobmanagement.composite.JobListComposite;
import com.clustercontrol.jobmanagement.composite.JobTreeComposite;
import com.clustercontrol.jobmanagement.util.JobEditStateUtil;
import com.clustercontrol.jobmanagement.util.JobTreeItemUtil;
import com.clustercontrol.jobmanagement.view.JobListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class DeleteJobAction
implements IViewActionDelegate {
    public static final String ID = "com.clustercontrol.jobmanagement.view.action.DeleteJobAction";
    private IViewPart m_view;

    public void init(IViewPart view) {
        this.m_view = view;
    }

    public void run(IAction action) {
        JobTreeItem item = null;
        JobTreeItem parent = null;
        if (this.m_view instanceof JobListView) {
            JobListView view = (JobListView)this.m_view.getAdapter(JobListView.class);
            JobTreeComposite tree = view.getJobTreeComposite();
            JobListComposite list = view.getJobListComposite();
            if (tree.getTree().isFocusControl()) {
                item = tree.getSelectItem();
                parent = item.getParent();
            } else if (list.getTable().isFocusControl()) {
                item = list.getSelectJobTreeItem();
                if (item instanceof JobTreeItem) {
                    parent = item.getParent();
                }
            } else {
                return;
            }
            if (parent instanceof JobTreeItem && item instanceof JobTreeItem) {
                String message = String.valueOf(Messages.getString((String)"job")) + "[" + item.getData().getId() + "]" + Messages.getString((String)"message.job.2");
                if (MessageDialog.openQuestion(null, (String)Messages.getString((String)"confirmed"), (String)message)) {
                    JobTreeItemUtil.removeChildren(parent, item);
                    if (item.getData().getType() == 0) {
                        JobEditStateUtil.removeEditedJobunit(item);
                        if (JobEditStateUtil.getLockedJobunitBackup(item.getData()) != null) {
                            JobEditStateUtil.addDeletedJobunit(item);
                        }
                    } else {
                        JobEditStateUtil.addEditedJobunit(item);
                    }
                    tree.refresh(parent);
                    tree.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)parent), true);
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

