/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.view.action;

import com.clustercontrol.jobmanagement.composite.JobListComposite;
import com.clustercontrol.jobmanagement.composite.JobTreeComposite;
import com.clustercontrol.jobmanagement.util.JobEditStateUtil;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.jobmanagement.util.JobPropertyUtil;
import com.clustercontrol.jobmanagement.util.JobTreeItemUtil;
import com.clustercontrol.jobmanagement.util.JobUtil;
import com.clustercontrol.jobmanagement.view.JobListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import com.clustercontrol.ws.jobmanagement.OtherUserGetLock_Exception;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class EditModeAction
implements IViewActionDelegate {
    private static Log m_log = LogFactory.getLog(EditModeAction.class);
    public static final String ID = "com.clustercontrol.jobmanagement.view.action.EditModeAction";
    private IViewPart m_view;

    public void init(IViewPart view) {
        this.m_view = view;
    }

    public void run(IAction action) {
        JobTreeItem selectedItem = null;
        JobTreeItem item = null;
        JobTreeItem parent = null;
        boolean isSelected = false;
        if (this.m_view instanceof JobListView) {
            JobListView view = (JobListView)this.m_view.getAdapter(JobListView.class);
            JobTreeComposite tree = view.getJobTreeComposite();
            JobListComposite list = view.getJobListComposite();
            if (tree.getTree().isFocusControl()) {
                selectedItem = tree.getSelectItem();
                item = JobUtil.getTopJobUnitTreeItem(selectedItem);
                parent = item.getParent();
            } else if (list.getTable().isFocusControl()) {
                item = list.getSelectJobTreeItem();
                if (item instanceof JobTreeItem) {
                    parent = item.getParent();
                }
            } else {
                action.setChecked(false);
            }
            if (parent instanceof JobTreeItem && item instanceof JobTreeItem) {
                isSelected = true;
                String jobunitId = item.getData().getJobunitId();
                if (action.isChecked()) {
                    Integer result;
                    block24: {
                        if (JobEditStateUtil.getLockedJobunitList().contains(item.getData())) {
                            return;
                        }
                        Long updateTime = JobEditStateUtil.getJobunitUpdateTime(jobunitId);
                        result = null;
                        try {
                            result = JobUtil.getEditLock(jobunitId, updateTime, false);
                        }
                        catch (OtherUserGetLock_Exception e) {
                            String message = e.getMessage();
                            if (!MessageDialog.openQuestion(null, (String)Messages.getString((String)"confirmed"), (String)message)) break block24;
                            try {
                                result = JobUtil.getEditLock(jobunitId, updateTime, true);
                            }
                            catch (Exception exception) {
                                m_log.error((Object)"run() : logical error");
                            }
                        }
                    }
                    if (result != null) {
                        m_log.debug((Object)("run() : get editLock(jobunitId=" + jobunitId + ")"));
                        JobEditStateUtil.addLockedJobunit(item.getData(), JobTreeItemUtil.clone(item, null), result);
                        view.getJobTreeComposite().refresh(parent);
                        tree.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)selectedItem), true);
                    } else {
                        m_log.debug((Object)("run() : cannot get editLock(jobunitId=" + jobunitId + ")"));
                        action.setChecked(false);
                    }
                } else {
                    if (!JobEditStateUtil.getLockedJobunitList().contains(item.getData())) {
                        return;
                    }
                    try {
                        if (MessageDialog.openQuestion(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.job.103"))) {
                            JobEndpointWrapper.releaseEditLock(JobEditStateUtil.getEditSession(item.getData()));
                            JobTreeItem backup = JobEditStateUtil.getLockedJobunitBackup(item.getData());
                            JobTreeItemUtil.removeChildren(parent, item);
                            if (backup != null) {
                                JobPropertyUtil.setJobFullTree(backup);
                                JobTreeItemUtil.addChildren(parent, backup);
                            }
                            JobEditStateUtil.exitEditMode(item);
                            view.getJobTreeComposite().getTreeViewer().sort(parent);
                            view.getJobTreeComposite().refresh();
                        } else {
                            action.setChecked(true);
                        }
                    }
                    catch (InvalidRole_Exception invalidRole_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    }
                    catch (Exception e) {
                        m_log.warn((Object)("updateJobunitUpdateTime() : " + e.getMessage()), (Throwable)e);
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
                    }
                }
            }
        }
        if (!isSelected) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.job.110"));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

