/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.view.action;

import com.clustercontrol.jobmanagement.composite.JobListComposite;
import com.clustercontrol.jobmanagement.composite.JobTreeComposite;
import com.clustercontrol.jobmanagement.dialog.JobDialog;
import com.clustercontrol.jobmanagement.util.JobEditStateUtil;
import com.clustercontrol.jobmanagement.util.JobUtil;
import com.clustercontrol.jobmanagement.view.JobListView;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class ModifyJobAction
implements IViewActionDelegate {
    public static final String ID = "com.clustercontrol.jobmanagement.view.action.ModifyJobAction";
    private IViewPart m_view;

    public void init(IViewPart view) {
        this.m_view = view;
    }

    public void run(IAction action) {
        JobTreeItem item = null;
        JobTreeItem parent = null;
        boolean focus = false;
        if (this.m_view instanceof JobListView) {
            JobListView view = (JobListView)this.m_view.getAdapter(JobListView.class);
            JobTreeComposite tree = view.getJobTreeComposite();
            JobListComposite list = view.getJobListComposite();
            if (tree.getTree().isFocusControl()) {
                item = tree.getSelectItem();
                parent = item.getParent();
                focus = false;
            } else if (list.getTable().isFocusControl()) {
                item = list.getSelectJobTreeItem();
                if (item instanceof JobTreeItem) {
                    parent = item.getParent();
                }
                focus = true;
            } else {
                return;
            }
            if (parent instanceof JobTreeItem && item instanceof JobTreeItem) {
                boolean readOnly = !JobEditStateUtil.isLockedJobunitId(item.getData().getJobunitId());
                JobDialog dialog = new JobDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), readOnly);
                dialog.setJobTreeItem(item);
                if (dialog.open() == 0 && !readOnly) {
                    JobEditStateUtil.addEditedJobunit(item);
                    if (item.getData().getType() == 0) {
                        JobUtil.setJobunitIdAll(item, item.getData().getJobunitId());
                    }
                }
                if (!focus) {
                    tree.getTreeViewer().sort(parent);
                    tree.refresh(parent);
                    tree.refresh(parent);
                    tree.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)item), true);
                } else {
                    tree.getTreeViewer().sort(parent);
                    tree.refresh(parent);
                    tree.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)parent), true);
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

