/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.view.action;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyDefineConstant;
import com.clustercontrol.jobmanagement.action.OperationJob;
import com.clustercontrol.jobmanagement.bean.OperationConstant;
import com.clustercontrol.jobmanagement.composite.DetailComposite;
import com.clustercontrol.jobmanagement.composite.HistoryComposite;
import com.clustercontrol.jobmanagement.composite.NodeDetailComposite;
import com.clustercontrol.jobmanagement.dialog.JobOperationDialog;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.jobmanagement.view.JobDetailView;
import com.clustercontrol.jobmanagement.view.JobHistoryView;
import com.clustercontrol.jobmanagement.view.JobNodeDetailView;
import com.clustercontrol.jobmanagement.view.action.StartJobAction;
import com.clustercontrol.util.Messages;
import com.clustercontrol.view.CommonViewPart;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class StopJobAction
implements IViewActionDelegate {
    private static Log m_log = LogFactory.getLog(StartJobAction.class);
    public static final String ID = "com.clustercontrol.jobmanagement.view.action.StopJobAction";
    private IViewPart m_view;

    public void init(IViewPart view) {
        this.m_view = view;
    }

    public void run(IAction action) {
        CommonViewPart view;
        String sessionId = null;
        String jobunitId = null;
        String jobId = null;
        String facilityId = null;
        if (this.m_view instanceof JobHistoryView) {
            view = (JobHistoryView)((Object)this.m_view.getAdapter(JobHistoryView.class));
            HistoryComposite historyComposite = ((JobHistoryView)view).getComposite();
            sessionId = historyComposite.getSessionId();
            jobunitId = historyComposite.getJobunitId();
            jobId = historyComposite.getJobId();
        } else if (this.m_view instanceof JobDetailView) {
            view = (JobDetailView)((Object)this.m_view.getAdapter(JobDetailView.class));
            DetailComposite detailComposite = ((JobDetailView)view).getComposite();
            sessionId = detailComposite.getSessionId();
            jobunitId = detailComposite.getJobunitId();
            jobId = detailComposite.getJobId();
        } else if (this.m_view instanceof JobNodeDetailView) {
            view = (JobNodeDetailView)((Object)this.m_view.getAdapter(JobNodeDetailView.class));
            NodeDetailComposite nodeDetailComposite = ((JobNodeDetailView)view).getComposite();
            sessionId = nodeDetailComposite.getSessionId();
            jobunitId = nodeDetailComposite.getJobunitId();
            jobId = nodeDetailComposite.getJobId();
            facilityId = nodeDetailComposite.getFacilityId();
            if (facilityId == null) {
                sessionId = null;
                jobunitId = null;
                jobId = null;
            }
        }
        if (sessionId != null && sessionId.length() > 0 && jobunitId != null && jobunitId.length() > 0 && jobId != null && jobId.length() > 0) {
            JobOperationDialog dialog = new JobOperationDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            dialog.setProperty(this.getStopProperty(sessionId, jobunitId, jobId, facilityId));
            dialog.setTitleText(String.valueOf(Messages.getString((String)"job")) + "[" + Messages.getString((String)"stop") + "]");
            if (dialog.open() == 0) {
                OperationJob operation = new OperationJob();
                operation.operationJob(dialog.getProperty());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private Property getStopProperty(String sessionId, String jobunitId, String jobId, String facilityId) {
        Locale locale = Locale.getDefault();
        Property session = new Property("session", Messages.getString((String)"session.id", (Locale)locale), PropertyDefineConstant.EDITOR_TEXT);
        session.setValue(sessionId);
        Property jobUnit = new Property("jobUnit", Messages.getString((String)"jobunit.id", (Locale)locale), PropertyDefineConstant.EDITOR_TEXT);
        jobUnit.setValue(jobunitId);
        Property job = new Property("job", Messages.getString((String)"job.id", (Locale)locale), PropertyDefineConstant.EDITOR_TEXT);
        job.setValue(jobId);
        Property facility = new Property("facility", Messages.getString((String)"facility.id", (Locale)locale), PropertyDefineConstant.EDITOR_TEXT);
        ArrayList<Property> endList = new ArrayList<Property>();
        if (facilityId != null && facilityId.length() > 0) {
            facility.setValue(facilityId);
        } else {
            facility.setValue("");
        }
        Property endStatus = null;
        if (facilityId == null) {
            endStatus = new Property("endStatus", Messages.getString((String)"end.status", (Locale)locale), PropertyDefineConstant.EDITOR_SELECT);
            Object[][] endStatusList = new Object[][]{{"", EndStatusConstant.STRING_NORMAL, EndStatusConstant.STRING_WARNING, EndStatusConstant.STRING_ABNORMAL}, {"", 0, 1, 2}};
            endStatus.setSelectValues(endStatusList);
            endStatus.setValue("");
            endList.add(endStatus);
        }
        Property endValue = new Property("endValue", Messages.getString((String)"end.value", (Locale)locale), PropertyDefineConstant.EDITOR_NUM, Short.MAX_VALUE, Short.MIN_VALUE);
        endValue.setValue("");
        endList.add(endValue);
        Property control = new Property("control", Messages.getString((String)"control", (Locale)locale), PropertyDefineConstant.EDITOR_SELECT);
        HashMap<String, Object> skipEndMap = new HashMap<String, Object>();
        skipEndMap.put("value", OperationConstant.STRING_STOP_SKIP);
        skipEndMap.put("property", endList);
        HashMap<String, Object> mainteEndMap = new HashMap<String, Object>();
        mainteEndMap.put("value", OperationConstant.STRING_STOP_MAINTENANCE);
        mainteEndMap.put("property", endList);
        HashMap<String, Object> forceEndMap = new HashMap<String, Object>();
        forceEndMap.put("value", OperationConstant.STRING_STOP_FORCE);
        forceEndMap.put("property", endList);
        List<String> values1 = null;
        try {
            values1 = JobEndpointWrapper.getAvailableStopOperation(sessionId, jobunitId, jobId, facilityId);
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("getStopProperty(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        ArrayList<Object> values2 = new ArrayList<Object>();
        if (values1.contains(OperationConstant.STRING_STOP_AT_ONCE)) {
            values2.add(OperationConstant.STRING_STOP_AT_ONCE);
        }
        if (values1.contains(OperationConstant.STRING_STOP_SUSPEND)) {
            values2.add(OperationConstant.STRING_STOP_SUSPEND);
        }
        if (values1.contains(OperationConstant.STRING_STOP_WAIT)) {
            values2.add(OperationConstant.STRING_STOP_WAIT);
        }
        if (values1.contains(OperationConstant.STRING_STOP_SKIP)) {
            values2.add(skipEndMap);
        }
        if (values1.contains(OperationConstant.STRING_STOP_MAINTENANCE)) {
            values2.add(mainteEndMap);
        }
        if (values1.contains(OperationConstant.STRING_STOP_FORCE)) {
            values2.add(forceEndMap);
        }
        Object[][] controlValues = new Object[][]{values1.toArray(), values2.toArray()};
        control.setSelectValues(controlValues);
        if (values1.size() >= 1) {
            control.setValue(values1.get(0));
        } else {
            control.setValue("");
        }
        session.setModify(0);
        jobUnit.setModify(0);
        job.setModify(0);
        facility.setModify(0);
        control.setModify(1);
        if (endStatus != null) {
            endStatus.setModify(1);
        }
        endValue.setModify(1);
        Property property = new Property(null, null, "");
        property.removeChildren();
        property.addChildren(session);
        property.addChildren(jobUnit);
        property.addChildren(job);
        if (facilityId != null) {
            property.addChildren(facility);
        }
        property.addChildren(control);
        String controlStr = (String)control.getValue();
        if (OperationConstant.STRING_STOP_SKIP.equals(controlStr) || OperationConstant.STRING_STOP_MAINTENANCE.equals(controlStr) || OperationConstant.STRING_STOP_FORCE.equals(controlStr)) {
            if (endStatus != null) {
                control.addChildren(endStatus);
            }
            control.addChildren(endValue);
        }
        return property;
    }
}

