/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.viewer;

import com.clustercontrol.bean.JobImageConstant;
import com.clustercontrol.jobmanagement.util.JobEditStateUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.JobInfo;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class JobTreeLabelProvider
extends LabelProvider {
    private boolean printEditable = false;

    public JobTreeLabelProvider() {
        this.printEditable = false;
    }

    public JobTreeLabelProvider(boolean printEditable) {
        this.printEditable = printEditable;
    }

    public String getText(Object element) {
        JobInfo info = ((JobTreeItem)element).getData();
        int type = info.getType();
        String editable = "";
        if (this.printEditable && type == 0 && JobEditStateUtil.isLockedJobunitId(info.getJobunitId())) {
            editable = " [" + Messages.getString((String)"edit.mode") + "]";
        }
        if (type == -1) {
            return info.getName();
        }
        return String.valueOf(info.getName()) + " (" + info.getId() + ")" + editable;
    }

    public Image getImage(Object element) {
        JobTreeItem item = (JobTreeItem)element;
        int type = item.getData().getType();
        return JobImageConstant.typeToImage(type);
    }
}

