/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.logfile.dialog;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.monitor.run.dialog.CommonMonitorStringDialog;
import com.clustercontrol.monitor.util.MonitorSettingEndpointWrapper;
import com.clustercontrol.notify.util.NotifyGroupIdGenerator;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.LogfileCheckInfo;
import com.clustercontrol.ws.monitor.MonitorDuplicate_Exception;
import com.clustercontrol.ws.monitor.MonitorInfo;
import com.clustercontrol.ws.notify.NotifyRelationInfo;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LogfileStringCreateDialog
extends CommonMonitorStringDialog {
    private static Log m_log = LogFactory.getLog(LogfileStringCreateDialog.class);
    private Text m_directory = null;
    private Text m_fileName = null;

    public LogfileStringCreateDialog(Shell parent) {
        super(parent);
        this.logLineFlag = true;
    }

    public LogfileStringCreateDialog(Shell parent, int monitorType) {
        super(parent);
        this.logLineFlag = true;
        this.m_monitorType = monitorType;
    }

    public LogfileStringCreateDialog(Shell parent, String monitorId, boolean updateFlg) {
        super(parent);
        this.logLineFlag = true;
        this.monitorId = monitorId;
        this.updateFlg = updateFlg;
    }

    @Override
    protected void customizeDialog(Composite parent) {
        super.customizeDialog(parent);
        this.shell.setText(Messages.getString((String)"dialog.logfile.create.modify"));
        Label label = null;
        GridData gridData = null;
        Group groupCheckRule = new Group((Composite)this.groupRule, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupCheckRule.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupCheckRule.setLayoutData((Object)gridData);
        groupCheckRule.setText(Messages.getString((String)"check.rule"));
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"directory")) + " : ");
        this.m_directory = new Text((Composite)groupCheckRule, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_directory.setLayoutData((Object)gridData);
        this.m_directory.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                LogfileStringCreateDialog.this.update();
            }
        });
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"file.name")) + "(" + Messages.getString((String)"regex") + ") : ");
        this.m_fileName = new Text((Composite)groupCheckRule, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_fileName.setLayoutData((Object)gridData);
        this.m_fileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                LogfileStringCreateDialog.this.update();
            }
        });
        this.m_fileName.setToolTipText(Messages.getString((String)"dialog.logfile.pattern"));
        this.m_monitorRule.setRunIntervalEnabled(false);
        this.adjustDialog();
        MonitorInfo info = null;
        if (this.monitorId == null) {
            info = new MonitorInfo();
            this.setInfoInitialValue(info);
        } else {
            try {
                info = MonitorSettingEndpointWrapper.getMonitor(this.monitorId, "MON_LOGFILE");
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (Exception e) {
                m_log.warn((Object)("customizeDialog() getMonitor, " + e.getMessage()), (Throwable)e);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
        }
        this.setInputData(info);
    }

    @Override
    public void update() {
        super.update();
        if ("".equals(this.m_directory.getText())) {
            this.m_directory.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_directory.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.m_fileName.getText())) {
            this.m_fileName.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_fileName.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    @Override
    protected void setInputData(MonitorInfo monitor) {
        LogfileCheckInfo logfileInfo;
        super.setInputData(monitor);
        this.inputData = monitor;
        List c = monitor.getNotifyId();
        if (c != null) {
            for (NotifyRelationInfo i : c) {
                m_log.debug((Object)("notifyId : " + i.getNotifyId()));
            }
        }
        if ((logfileInfo = monitor.getLogfileCheckInfo()) == null) {
            logfileInfo = new LogfileCheckInfo();
        }
        if (logfileInfo != null) {
            if (logfileInfo.getDirectory() != null) {
                this.m_directory.setText(logfileInfo.getDirectory());
            }
            if (logfileInfo.getFileName() != null) {
                this.m_fileName.setText(logfileInfo.getFileName());
            }
        }
        this.update();
        this.m_stringValueInfo.setInputData(monitor);
    }

    @Override
    protected MonitorInfo createInputData() {
        super.createInputData();
        if (this.validateResult != null) {
            return null;
        }
        this.monitorInfo.setMonitorTypeId("MON_LOGFILE");
        LogfileCheckInfo logfileInfo = new LogfileCheckInfo();
        logfileInfo.setMonitorTypeId("MON_LOGFILE");
        logfileInfo.setMonitorId(this.monitorInfo.getMonitorId());
        if (this.m_directory.getText() != null && !"".equals(this.m_directory.getText())) {
            logfileInfo.setDirectory(this.m_directory.getText());
        }
        if (this.m_fileName.getText() != null && !"".equals(this.m_fileName.getText())) {
            logfileInfo.setFileName(this.m_fileName.getText());
        }
        this.monitorInfo.setLogfileCheckInfo(logfileInfo);
        this.validateResult = this.m_stringValueInfo.createInputData(this.monitorInfo);
        if (this.validateResult != null) {
            return null;
        }
        this.monitorInfo.setNotifyGroupId(NotifyGroupIdGenerator.createNotifyGroupId((String)"MON_LOGFILE", (String)this.monitorInfo.getMonitorId()));
        this.validateResult = this.m_notifyInfo.createInputData(this.monitorInfo);
        if (this.validateResult != null) {
            if (this.validateResult.getID() == null) {
                if (!this.displayQuestion(this.validateResult)) {
                    this.validateResult = null;
                    return null;
                }
            } else {
                return null;
            }
        }
        return this.monitorInfo;
    }

    @Override
    protected boolean action() {
        boolean result;
        block14: {
            result = false;
            MonitorInfo info = this.inputData;
            if (info != null) {
                Object[] args = new String[]{info.getMonitorId()};
                if (!this.updateFlg) {
                    try {
                        result = MonitorSettingEndpointWrapper.addMonitor(info);
                        if (result) {
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.monitor.33", (Object[])args));
                            break block14;
                        }
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.monitor.34", (Object[])args));
                    }
                    catch (MonitorDuplicate_Exception monitorDuplicate_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.monitor.53", (Object[])args));
                    }
                    catch (Exception e) {
                        String errMessage = "";
                        if (e instanceof InvalidRole_Exception) {
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                        } else {
                            errMessage = ", " + e.getMessage();
                        }
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.monitor.34", (Object[])args)) + errMessage));
                    }
                } else {
                    String errMessage = "";
                    try {
                        result = MonitorSettingEndpointWrapper.modifyMonitor(info);
                    }
                    catch (InvalidRole_Exception invalidRole_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    }
                    catch (Exception e) {
                        errMessage = ", " + e.getMessage();
                    }
                    if (result) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.monitor.35", (Object[])args));
                    } else {
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.monitor.36", (Object[])args)) + errMessage));
                    }
                }
            }
        }
        return result;
    }
}

