/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.maintenance.dialog;

import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.calendar.composite.CalendarIdListComposite;
import com.clustercontrol.composite.action.ComboModifyListener;
import com.clustercontrol.composite.action.NumberKeyListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.maintenance.action.GetMaintenance;
import com.clustercontrol.maintenance.action.ModifyMaintenance;
import com.clustercontrol.maintenance.composite.MaintenanceTypeListComposite;
import com.clustercontrol.maintenance.util.MaintenanceEndpointWrapper;
import com.clustercontrol.maintenance.util.MaintenanceUtil;
import com.clustercontrol.notify.composite.NotifyInfoComposite;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.common.Schedule;
import com.clustercontrol.ws.maintenance.InvalidRole_Exception;
import com.clustercontrol.ws.maintenance.MaintenanceDuplicate_Exception;
import com.clustercontrol.ws.maintenance.MaintenanceInfo;
import java.text.DecimalFormat;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MaintenanceDialog
extends CommonDialog {
    public static final int WIDTH_TITLE = 4;
    public static final int WIDTH_TEXT = 8;
    private Text m_textMaintenanceId = null;
    private int mode;
    private Text m_textDescription = null;
    private MaintenanceTypeListComposite m_maintenance_type = null;
    private Text m_textDataRetentionPeriod = null;
    private CalendarIdListComposite m_calendarId = null;
    private Button m_type1 = null;
    private Button m_type2 = null;
    private Combo m_comboMonth = null;
    private Combo m_comboDay = null;
    private Combo m_comboHours1 = null;
    private Combo m_comboMinutes1 = null;
    private Combo m_comboDayOfWeek = null;
    private Combo m_comboHours2 = null;
    private Combo m_comboMinutes2 = null;
    private String maintenanceId = null;
    private NotifyInfoComposite notifyInfo = null;
    private String m_ownerRoleId = "ADMINISTRATORS";
    private Button confirmValid = null;
    private MaintenanceInfo maintenanceInfo = null;

    public MaintenanceDialog(Shell parent) {
        super(parent);
        this.mode = 0;
    }

    public MaintenanceDialog(Shell parent, String maintenanceId, int mode) {
        super(parent);
        this.maintenanceId = maintenanceId;
        this.mode = mode;
    }

    @Override
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.history.delete.settings.modify"));
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"maintenance.id")) + " : ");
        this.m_textMaintenanceId = new Text(parent, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textMaintenanceId.setLayoutData((Object)gridData);
        if (this.mode == 1 || this.mode == 2) {
            this.m_textMaintenanceId.setEnabled(false);
        }
        this.m_textMaintenanceId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                MaintenanceDialog.this.update();
            }
        });
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"description")) + " : ");
        this.m_textDescription = new Text(parent, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textDescription.setLayoutData((Object)gridData);
        this.m_textDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                MaintenanceDialog.this.update();
            }
        });
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_maintenance_type = new MaintenanceTypeListComposite(parent, 0, true);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_maintenance_type.setLayoutData(gridData);
        this.m_maintenance_type.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                MaintenanceDialog.this.update();
            }
        });
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"maintenance.retention.period")) + " : ");
        this.m_textDataRetentionPeriod = new Text(parent, 18432);
        this.m_textDataRetentionPeriod.setToolTipText(Messages.getString((String)"message.maintenance.23"));
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textDataRetentionPeriod.setLayoutData((Object)gridData);
        this.m_textDataRetentionPeriod.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                MaintenanceDialog.this.update();
            }
        });
        this.m_calendarId = new CalendarIdListComposite(parent, 0, true);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_calendarId.setLayoutData(gridData);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        Group group1 = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 20;
        group1.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        group1.setLayoutData((Object)gridData);
        group1.setText(Messages.getString((String)"schedule"));
        this.createType1(group1);
        this.createType2(group1);
        Group groupNotifyAttribute = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupNotifyAttribute.setLayout((Layout)layout);
        groupNotifyAttribute.setText(Messages.getString((String)"notify.attribute"));
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupNotifyAttribute.setLayoutData((Object)gridData);
        this.notifyInfo = new NotifyInfoComposite((Composite)groupNotifyAttribute, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.notifyInfo.setLayoutData(gridData);
        this.confirmValid = new Button(parent, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.confirmValid.setLayoutData((Object)gridData);
        this.confirmValid.setText(Messages.getString((String)"setting.valid.confirmed"));
        this.confirmValid.setSelection(true);
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 15;
        line.setLayoutData((Object)gridData);
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        MaintenanceInfo info = null;
        if (this.maintenanceId != null) {
            info = new GetMaintenance().getMaintenanceInfo(this.maintenanceId);
        }
        this.setInputData(info);
        this.reflectMaintenanceSchedule();
    }

    private void update() {
        if (this.m_textMaintenanceId.getEnabled() && "".equals(this.m_textMaintenanceId.getText())) {
            this.m_textMaintenanceId.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textMaintenanceId.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.m_maintenance_type.getText())) {
            this.m_maintenance_type.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_maintenance_type.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.m_textDataRetentionPeriod.getText())) {
            this.m_textDataRetentionPeriod.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textDataRetentionPeriod.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_comboHours1.getEnabled() && "".equals(this.m_comboHours1.getText())) {
            this.m_comboHours1.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_comboHours1.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_comboMinutes1.getEnabled() && "".equals(this.m_comboMinutes1.getText())) {
            this.m_comboMinutes1.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_comboMinutes1.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_comboDayOfWeek.getEnabled() && "".equals(this.m_comboDayOfWeek.getText())) {
            this.m_comboDayOfWeek.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_comboDayOfWeek.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_comboHours2.getEnabled() && "".equals(this.m_comboHours2.getText())) {
            this.m_comboHours2.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_comboHours2.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_comboMinutes2.getEnabled() && "".equals(this.m_comboMinutes2.getText())) {
            this.m_comboMinutes2.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_comboMinutes2.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    private void createType1(Group parent) {
        this.m_type1 = new Button((Composite)parent, 16);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_type1.setLayoutData((Object)gridData);
        this.m_type1.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    MaintenanceDialog.this.m_type2.setSelection(false);
                    MaintenanceDialog.this.m_comboMonth.setEnabled(true);
                    MaintenanceDialog.this.m_comboDay.setEnabled(true);
                    MaintenanceDialog.this.m_comboHours1.setEnabled(true);
                    MaintenanceDialog.this.m_comboMinutes1.setEnabled(true);
                    MaintenanceDialog.this.m_comboDayOfWeek.setEnabled(false);
                    MaintenanceDialog.this.m_comboHours2.setEnabled(false);
                    MaintenanceDialog.this.m_comboMinutes2.setEnabled(false);
                }
                MaintenanceDialog.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_comboMonth = new Combo((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboMonth.setLayoutData((Object)gridData);
        this.m_comboMonth.setTextLimit(2);
        this.m_comboMonth.setVisibleItemCount(10);
        this.m_comboMonth.addKeyListener((KeyListener)new NumberKeyListener());
        this.m_comboMonth.addModifyListener((ModifyListener)new ComboModifyListener());
        DecimalFormat format = new DecimalFormat("00");
        this.m_comboMonth.add("");
        int month = 1;
        while (month <= 12) {
            this.m_comboMonth.add(format.format(month));
            ++month;
        }
        Label labelMonth = new Label((Composite)parent, 0);
        labelMonth.setText(Messages.getString((String)"month"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelMonth.setLayoutData((Object)gridData);
        this.m_comboDay = new Combo((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboDay.setLayoutData((Object)gridData);
        this.m_comboDay.setTextLimit(2);
        this.m_comboDay.setVisibleItemCount(10);
        this.m_comboDay.addKeyListener((KeyListener)new NumberKeyListener());
        this.m_comboDay.addModifyListener((ModifyListener)new ComboModifyListener());
        format = new DecimalFormat("00");
        this.m_comboDay.add("");
        int day = 1;
        while (day <= 31) {
            this.m_comboDay.add(format.format(day));
            ++day;
        }
        Label labelDay = new Label((Composite)parent, 0);
        labelDay.setText(Messages.getString((String)"monthday"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelDay.setLayoutData((Object)gridData);
        this.m_comboHours1 = new Combo((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboHours1.setLayoutData((Object)gridData);
        this.m_comboHours1.setTextLimit(2);
        this.m_comboHours1.setVisibleItemCount(10);
        this.m_comboHours1.addKeyListener((KeyListener)new NumberKeyListener());
        this.m_comboHours1.addModifyListener((ModifyListener)new ComboModifyListener());
        format = new DecimalFormat("00");
        this.m_comboHours1.add("");
        int hour = 0;
        while (hour < 24) {
            this.m_comboHours1.add(format.format(hour));
            ++hour;
        }
        this.m_comboHours1.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                MaintenanceDialog.this.update();
            }
        });
        Label labelHours = new Label((Composite)parent, 0);
        labelHours.setText(Messages.getString((String)"hour"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelHours.setLayoutData((Object)gridData);
        this.m_comboMinutes1 = new Combo((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboMinutes1.setLayoutData((Object)gridData);
        this.m_comboMinutes1.setTextLimit(2);
        this.m_comboMinutes1.setVisibleItemCount(10);
        this.m_comboMinutes1.addKeyListener((KeyListener)new NumberKeyListener());
        this.m_comboMinutes1.addModifyListener((ModifyListener)new ComboModifyListener());
        format = new DecimalFormat("00");
        this.m_comboMinutes1.add("");
        int minutes = 0;
        while (minutes < 60) {
            this.m_comboMinutes1.add(format.format(minutes));
            ++minutes;
        }
        this.m_comboMinutes1.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                MaintenanceDialog.this.update();
            }
        });
        Label labelMinutes = new Label((Composite)parent, 0);
        labelMinutes.setText(Messages.getString((String)"minute"));
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelMinutes.setLayoutData((Object)gridData);
        Label label = new Label((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
    }

    private void createType2(Group parent) {
        this.m_type2 = new Button((Composite)parent, 16);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_type2.setLayoutData((Object)gridData);
        this.m_type2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    MaintenanceDialog.this.m_type1.setSelection(false);
                    MaintenanceDialog.this.m_comboMonth.setEnabled(false);
                    MaintenanceDialog.this.m_comboDay.setEnabled(false);
                    MaintenanceDialog.this.m_comboHours1.setEnabled(false);
                    MaintenanceDialog.this.m_comboMinutes1.setEnabled(false);
                    MaintenanceDialog.this.m_comboDayOfWeek.setEnabled(true);
                    MaintenanceDialog.this.m_comboHours2.setEnabled(true);
                    MaintenanceDialog.this.m_comboMinutes2.setEnabled(true);
                }
                MaintenanceDialog.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label labelDummy = new Label((Composite)parent, 0);
        labelDummy.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelDummy.setLayoutData((Object)gridData);
        this.m_comboDayOfWeek = new Combo((Composite)parent, 8);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 5;
        this.m_comboDayOfWeek.setLayoutData((Object)gridData);
        this.m_comboDayOfWeek.setTextLimit(3);
        this.m_comboDayOfWeek.setVisibleItemCount(10);
        this.m_comboDayOfWeek.add(DayOfWeekConstant.STRING_SUNDAY);
        this.m_comboDayOfWeek.add(DayOfWeekConstant.STRING_MONDAY);
        this.m_comboDayOfWeek.add(DayOfWeekConstant.STRING_TUESDAY);
        this.m_comboDayOfWeek.add(DayOfWeekConstant.STRING_WEDNESDAY);
        this.m_comboDayOfWeek.add(DayOfWeekConstant.STRING_THURSDAY);
        this.m_comboDayOfWeek.add(DayOfWeekConstant.STRING_FRIDAY);
        this.m_comboDayOfWeek.add(DayOfWeekConstant.STRING_SATURDAY);
        this.m_comboDayOfWeek.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                MaintenanceDialog.this.update();
            }
        });
        new Label((Composite)parent, 0);
        labelDummy.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelDummy.setLayoutData((Object)gridData);
        this.m_comboHours2 = new Combo((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboHours2.setLayoutData((Object)gridData);
        this.m_comboHours2.setTextLimit(2);
        this.m_comboHours2.setVisibleItemCount(10);
        this.m_comboHours2.addKeyListener((KeyListener)new NumberKeyListener());
        this.m_comboHours2.addModifyListener((ModifyListener)new ComboModifyListener());
        DecimalFormat format = new DecimalFormat("00");
        this.m_comboHours2.add("");
        int hour = 0;
        while (hour < 24) {
            this.m_comboHours2.add(format.format(hour));
            ++hour;
        }
        this.m_comboHours2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                MaintenanceDialog.this.update();
            }
        });
        Label labelHours = new Label((Composite)parent, 0);
        labelHours.setText(Messages.getString((String)"hour"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelHours.setLayoutData((Object)gridData);
        this.m_comboMinutes2 = new Combo((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboMinutes2.setLayoutData((Object)gridData);
        this.m_comboMinutes2.setTextLimit(2);
        this.m_comboMinutes2.setVisibleItemCount(10);
        this.m_comboMinutes2.addKeyListener((KeyListener)new NumberKeyListener());
        this.m_comboMinutes2.addModifyListener((ModifyListener)new ComboModifyListener());
        format = new DecimalFormat("00");
        this.m_comboMinutes2.add("");
        int minutes = 0;
        while (minutes < 60) {
            this.m_comboMinutes2.add(format.format(minutes));
            ++minutes;
        }
        this.m_comboMinutes2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                MaintenanceDialog.this.update();
            }
        });
        Label labelMinutes = new Label((Composite)parent, 0);
        labelMinutes.setText(Messages.getString((String)"minute"));
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelMinutes.setLayoutData((Object)gridData);
        Label label = new Label((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
    }

    private void reflectMaintenanceSchedule() {
        if (this.maintenanceId == null) {
            this.m_type1.setSelection(true);
            this.m_comboMonth.setEnabled(true);
            this.m_comboDay.setEnabled(true);
            this.m_comboHours1.setEnabled(true);
            this.m_comboMinutes1.setEnabled(true);
            this.m_comboDayOfWeek.setEnabled(false);
            this.m_comboHours2.setEnabled(false);
            this.m_comboMinutes2.setEnabled(false);
            this.update();
            return;
        }
        this.maintenanceInfo = new GetMaintenance().getMaintenanceInfo(this.maintenanceId);
        Schedule schedule = this.maintenanceInfo.getSchedule();
        DecimalFormat format = new DecimalFormat("00");
        if (schedule.getType() == 1) {
            this.m_comboMonth.select(0);
            int i = 0;
            while (i < this.m_comboMonth.getItemCount()) {
                if (schedule.getMonth() == null) break;
                String month = format.format(schedule.getMonth());
                if (month.equals(this.m_comboMonth.getItem(i))) {
                    this.m_comboMonth.select(i);
                    break;
                }
                ++i;
            }
            this.m_comboDay.select(0);
            i = 0;
            while (i < this.m_comboDay.getItemCount()) {
                if (schedule.getDay() == null) break;
                String day = format.format(schedule.getDay());
                if (day.equals(this.m_comboDay.getItem(i))) {
                    this.m_comboDay.select(i);
                    break;
                }
                ++i;
            }
            this.m_comboHours1.select(0);
            this.m_comboHours2.select(0);
            i = 0;
            while (i < this.m_comboHours1.getItemCount()) {
                if (schedule.getHour() == null) break;
                String hours = format.format(schedule.getHour());
                if (hours.equals(this.m_comboHours1.getItem(i))) {
                    this.m_comboHours1.select(i);
                    break;
                }
                ++i;
            }
            this.m_comboMinutes1.select(0);
            this.m_comboMinutes2.select(0);
            i = 0;
            while (i < this.m_comboMinutes1.getItemCount()) {
                if (schedule.getMinute() == null) break;
                String minutes = format.format(schedule.getMinute());
                if (minutes.equals(this.m_comboMinutes1.getItem(i))) {
                    this.m_comboMinutes1.select(i);
                    break;
                }
                ++i;
            }
        } else {
            this.m_comboDayOfWeek.select(0);
            String dayOfWeek = DayOfWeekConstant.typeToString(schedule.getWeek());
            int i = 0;
            while (i < this.m_comboDayOfWeek.getItemCount()) {
                if (dayOfWeek.equals(this.m_comboDayOfWeek.getItem(i))) {
                    this.m_comboDayOfWeek.select(i);
                    break;
                }
                ++i;
            }
            this.m_comboHours1.select(0);
            this.m_comboHours2.select(0);
            i = 0;
            while (i < this.m_comboHours2.getItemCount()) {
                if (schedule.getHour() == null) break;
                String hours = format.format(schedule.getHour());
                if (hours.equals(this.m_comboHours2.getItem(i))) {
                    this.m_comboHours2.select(i);
                    break;
                }
                ++i;
            }
            this.m_comboMinutes1.select(0);
            this.m_comboMinutes2.select(0);
            i = 0;
            while (i < this.m_comboMinutes2.getItemCount()) {
                if (schedule.getMinute() == null) break;
                String minutes = format.format(schedule.getMinute());
                if (minutes.equals(this.m_comboMinutes2.getItem(i))) {
                    this.m_comboMinutes2.select(i);
                    break;
                }
                ++i;
            }
        }
        if (schedule.getType() == 1) {
            this.m_type1.setSelection(true);
            this.m_comboMonth.setEnabled(true);
            this.m_comboDay.setEnabled(true);
            this.m_comboHours1.setEnabled(true);
            this.m_comboMinutes1.setEnabled(true);
            this.m_comboDayOfWeek.setEnabled(false);
            this.m_comboHours2.setEnabled(false);
            this.m_comboMinutes2.setEnabled(false);
        } else if (schedule.getType() == 2) {
            this.m_type2.setSelection(true);
            this.m_comboMonth.setEnabled(false);
            this.m_comboDay.setEnabled(false);
            this.m_comboHours1.setEnabled(false);
            this.m_comboMinutes1.setEnabled(false);
            this.m_comboDayOfWeek.setEnabled(true);
            this.m_comboHours2.setEnabled(true);
            this.m_comboMinutes2.setEnabled(true);
        }
        this.update();
    }

    private ValidateResult createMaintenanceInfo() {
        ValidateResult result = null;
        if (this.maintenanceInfo == null) {
            this.maintenanceInfo = new MaintenanceInfo();
        }
        if (this.m_textMaintenanceId.getText().length() > 0) {
            this.maintenanceInfo.setMaintenanceId(this.m_textMaintenanceId.getText());
        }
        if (this.m_ownerRoleId.length() > 0) {
            this.maintenanceInfo.setOwnerRoleId(this.m_ownerRoleId);
        }
        if (this.m_textDescription.getText().length() > 0) {
            this.maintenanceInfo.setDescription(this.m_textDescription.getText());
        }
        if (this.m_maintenance_type.getSelectionIndex() >= 0) {
            this.maintenanceInfo.setTypeId(this.m_maintenance_type.getSelectionTypeId());
        }
        if (this.m_textDataRetentionPeriod.getText().length() > 0) {
            try {
                int period = Integer.valueOf(this.m_textDataRetentionPeriod.getText());
                this.maintenanceInfo.setDataRetentionPeriod(new Integer(period));
            }
            catch (NumberFormatException numberFormatException) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.maintenance.17"));
                return result;
            }
        } else {
            this.maintenanceInfo.setDataRetentionPeriod(null);
        }
        if (this.m_calendarId.getText().length() > 0) {
            this.maintenanceInfo.setCalendarId(this.m_calendarId.getText());
        } else {
            this.maintenanceInfo.setCalendarId(null);
        }
        Schedule schedule = new Schedule();
        Integer month = null;
        Integer day = null;
        Integer hours = null;
        Integer minutes = null;
        Integer week = null;
        if (this.m_type1.getSelection()) {
            if (this.m_comboMonth.getText().length() > 0) {
                month = new Integer(this.m_comboMonth.getText());
            }
            if (this.m_comboDay.getText().length() > 0) {
                day = new Integer(this.m_comboDay.getText());
            }
            if (this.m_comboHours1.getText().length() > 0) {
                hours = new Integer(this.m_comboHours1.getText());
            }
            if (this.m_comboMinutes1.getText().length() > 0) {
                minutes = new Integer(this.m_comboMinutes1.getText());
            }
            schedule.setType(1);
        } else if (this.m_type2.getSelection()) {
            schedule.setType(2);
            if (this.m_comboDayOfWeek.getText().length() > 0) {
                week = new Integer(DayOfWeekConstant.stringToType(this.m_comboDayOfWeek.getText()));
            }
            if (this.m_comboHours2.getText().length() > 0) {
                hours = new Integer(this.m_comboHours2.getText());
            }
            if (this.m_comboMinutes2.getText().length() > 0) {
                minutes = new Integer(this.m_comboMinutes2.getText());
            }
        }
        schedule.setMonth(month);
        schedule.setDay(day);
        schedule.setWeek(week);
        schedule.setHour(hours);
        schedule.setMinute(minutes);
        this.maintenanceInfo.setSchedule(schedule);
        this.maintenanceInfo.setNotifyGroupId(MaintenanceUtil.createNotifyGroupIdMaintenance(this.maintenanceInfo.getMaintenanceId()));
        this.notifyInfo.setNotifyGroupId(this.maintenanceInfo.getNotifyGroupId());
        List notifyRelationInfoList = this.maintenanceInfo.getNotifyId();
        notifyRelationInfoList.clear();
        if (this.notifyInfo.getNotify() != null) {
            notifyRelationInfoList.addAll(this.notifyInfo.getNotify());
        }
        this.maintenanceInfo.setApplication(this.notifyInfo.getApplication());
        if (this.confirmValid.getSelection()) {
            this.maintenanceInfo.setValidFlg(Integer.valueOf(1));
        } else {
            this.maintenanceInfo.setValidFlg(Integer.valueOf(0));
        }
        return result;
    }

    protected void setInputData(MaintenanceInfo info) {
        this.m_calendarId.setOwnerRoleId(this.m_ownerRoleId);
        this.notifyInfo.setOwnerRoleId(this.m_ownerRoleId);
        if (info != null) {
            if (info.getMaintenanceId() != null) {
                this.maintenanceId = info.getMaintenanceId();
                this.m_textMaintenanceId.setText(this.maintenanceId);
            }
            if (info.getDescription() != null) {
                this.m_textDescription.setText(info.getDescription());
            }
            if (info.getDataRetentionPeriod() != null) {
                this.m_textDataRetentionPeriod.setText(info.getDataRetentionPeriod().toString());
            }
            if (info.getCalendarId() != null) {
                if (!this.m_calendarId.getEnabled()) {
                    this.m_calendarId.addText(info.getCalendarId());
                }
                this.m_calendarId.setText(info.getCalendarId());
            }
            if (info.getTypeId() != null) {
                this.m_maintenance_type.setText(this.m_maintenance_type.getMaintenanceTypeName(info.getTypeId()));
            }
            if (info.getNotifyId() != null) {
                this.notifyInfo.setNotify(info.getNotifyId());
            }
            if (info.getApplication() != null) {
                this.notifyInfo.setApplication(info.getApplication());
                this.notifyInfo.update();
            }
            if (info.getValidFlg() != null) {
                this.confirmValid.setSelection(ValidConstant.typeToBoolean((int)info.getValidFlg()));
            }
        }
        this.update();
    }

    @Override
    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    @Override
    protected ValidateResult validate() {
        ValidateResult result = null;
        result = this.createMaintenanceInfo();
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    protected boolean action() {
        boolean result = false;
        if (this.maintenanceInfo != null) {
            if (this.mode == 0) {
                Object[] args = new String[]{this.maintenanceInfo.getMaintenanceId()};
                try {
                    MaintenanceEndpointWrapper.addMaintenance(this.maintenanceInfo);
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.maintenance.1", (Object[])args));
                    result = true;
                }
                catch (MaintenanceDuplicate_Exception maintenanceDuplicate_Exception) {
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.maintenance.11", (Object[])args));
                }
                catch (Exception e) {
                    String errMessage = "";
                    if (e instanceof InvalidRole_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    } else {
                        errMessage = ", " + e.getMessage();
                    }
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.maintenance.2", (Object[])args)) + errMessage));
                }
            } else if (this.mode == 1) {
                result = new ModifyMaintenance().modify(this.maintenanceInfo);
            }
        }
        return result;
    }
}

