/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.maintenance.util;

import com.clustercontrol.util.EndpointManager;
import com.clustercontrol.ws.maintenance.HinemosUnknown_Exception;
import com.clustercontrol.ws.maintenance.InvalidRole_Exception;
import com.clustercontrol.ws.maintenance.InvalidSetting_Exception;
import com.clustercontrol.ws.maintenance.InvalidUserPass_Exception;
import com.clustercontrol.ws.maintenance.MaintenanceDuplicate_Exception;
import com.clustercontrol.ws.maintenance.MaintenanceEndpoint;
import com.clustercontrol.ws.maintenance.MaintenanceInfo;
import com.clustercontrol.ws.maintenance.MaintenanceNotFound_Exception;
import com.clustercontrol.ws.maintenance.MaintenanceTypeMst;
import com.clustercontrol.ws.maintenance.NotifyNotFound_Exception;
import java.util.List;
import javax.xml.ws.WebServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MaintenanceEndpointWrapper {
    private static Log m_log = LogFactory.getLog(MaintenanceEndpointWrapper.class);

    public static MaintenanceInfo getMaintenanceInfo(String maintenanceId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MaintenanceNotFound_Exception, NotifyNotFound_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getMaintenanceEndpoint()) {
            try {
                MaintenanceEndpoint endpoint = (MaintenanceEndpoint)endpointSetting.getEndpoint();
                return endpoint.getMaintenanceInfo(maintenanceId);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getMaintenanceInfo(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<MaintenanceInfo> getMaintenanceList() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MaintenanceNotFound_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getMaintenanceEndpoint()) {
            try {
                MaintenanceEndpoint endpoint = (MaintenanceEndpoint)endpointSetting.getEndpoint();
                return endpoint.getMaintenanceList();
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getMaintenanceList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<MaintenanceTypeMst> getMaintenanceTypeList() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MaintenanceNotFound_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getMaintenanceEndpoint()) {
            try {
                MaintenanceEndpoint endpoint = (MaintenanceEndpoint)endpointSetting.getEndpoint();
                return endpoint.getMaintenanceTypeList();
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getMaintenanceTypeList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void addMaintenance(MaintenanceInfo info) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MaintenanceDuplicate_Exception, InvalidSetting_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getMaintenanceEndpoint()) {
            try {
                MaintenanceEndpoint endpoint = (MaintenanceEndpoint)endpointSetting.getEndpoint();
                endpoint.addMaintenance(info);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("addMaintenance(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void modifyMaintenance(MaintenanceInfo info) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MaintenanceNotFound_Exception, NotifyNotFound_Exception, InvalidSetting_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getMaintenanceEndpoint()) {
            try {
                MaintenanceEndpoint endpoint = (MaintenanceEndpoint)endpointSetting.getEndpoint();
                endpoint.modifyMaintenance(info);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("modifyMaintenance(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void deleteMaintenance(String maintenanceId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MaintenanceNotFound_Exception, NotifyNotFound_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getMaintenanceEndpoint()) {
            try {
                MaintenanceEndpoint endpoint = (MaintenanceEndpoint)endpointSetting.getEndpoint();
                endpoint.deleteMaintenance(maintenanceId);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("deleteMaintenance(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void setMaintenanceStatus(String maintenanceId, boolean validFlag) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, MaintenanceNotFound_Exception, NotifyNotFound_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getMaintenanceEndpoint()) {
            try {
                MaintenanceEndpoint endpoint = (MaintenanceEndpoint)endpointSetting.getEndpoint();
                endpoint.setMaintenanceStatus(maintenanceId, validFlag);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("setMaintenanceStatus(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }
}

