/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.maintenance.view.action;

import com.clustercontrol.maintenance.composite.MaintenanceListComposite;
import com.clustercontrol.maintenance.util.MaintenanceEndpointWrapper;
import com.clustercontrol.maintenance.view.MaintenanceListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.maintenance.InvalidRole_Exception;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class MaintenanceEnableAction
implements IViewActionDelegate {
    private static Log m_log = LogFactory.getLog(MaintenanceEnableAction.class);
    public static final String ID = "com.clustercontrol.maintenance.view.action.MaintenanceEnableAction";
    private IViewPart viewPart;

    public void run(IAction action) {
        MaintenanceListView view = (MaintenanceListView)this.viewPart.getAdapter(MaintenanceListView.class);
        MaintenanceListComposite composite = (MaintenanceListComposite)view.getListComposite();
        StructuredSelection selection = (StructuredSelection)composite.getTableViewer().getSelection();
        Object[] objs = selection.toArray();
        if (objs.length == 0) {
            MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.maintenance.9"));
            return;
        }
        String maintenanceId = null;
        StringBuffer targetList = new StringBuffer();
        StringBuffer successList = new StringBuffer();
        StringBuffer failureList = new StringBuffer();
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (targetList.length() != 0) {
                targetList.append(", ");
            }
            maintenanceId = (String)((ArrayList)o).get(0);
            targetList.append(maintenanceId);
            ++n2;
        }
        Object[] args = new String[]{targetList.toString()};
        if (!MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.maintenance.14", (Object[])args))) {
            return;
        }
        boolean hasRole = true;
        Object[] objectArray2 = objs;
        int n3 = objs.length;
        n = 0;
        while (n < n3) {
            Object o = objectArray2[n];
            maintenanceId = (String)((ArrayList)o).get(0);
            try {
                MaintenanceEndpointWrapper.setMaintenanceStatus(maintenanceId, true);
                successList.append(String.valueOf(maintenanceId) + "\n");
            }
            catch (InvalidRole_Exception e) {
                failureList.append(String.valueOf(maintenanceId) + "\n");
                m_log.warn((Object)("run() setMaintenanceStatus maintenanceId=" + maintenanceId + ", " + e.getMessage()), (Throwable)e);
                hasRole = false;
            }
            catch (Exception e) {
                failureList.append(String.valueOf(maintenanceId) + "\n");
                m_log.warn((Object)("run() setMaintenanceStatus maintenanceId=" + maintenanceId + ", " + e.getMessage()), (Throwable)e);
            }
            ++n;
        }
        if (!hasRole) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        if (successList.length() != 0) {
            args = new String[]{successList.toString()};
            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.maintenance.18", (Object[])args));
        }
        if (failureList.length() != 0) {
            args = new String[]{failureList.toString()};
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.maintenance.19", (Object[])args));
        }
        composite.update();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IViewPart view) {
        this.viewPart = view;
    }
}

