/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.composite;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.accesscontrol.util.LocalSession;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.action.CommentEvent;
import com.clustercontrol.monitor.action.GetEventListTableDefine;
import com.clustercontrol.monitor.dialog.EventInfoDialog;
import com.clustercontrol.monitor.util.ConvertListUtil;
import com.clustercontrol.monitor.util.EventFilterPropertyUtil;
import com.clustercontrol.monitor.util.MonitorEndpointWrapper;
import com.clustercontrol.monitor.view.EventView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.monitor.EventFilterInfo;
import com.clustercontrol.ws.monitor.HinemosUnknown_Exception;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.MonitorNotFound_Exception;
import com.clustercontrol.ws.monitor.ViewListInfo;
import com.sun.xml.internal.ws.client.ClientTransportException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;

public class EventListComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(EventListComposite.class);
    private CommonTableViewer tableViewer = null;
    private Label criticalLabel = null;
    private Label warningLabel = null;
    private Label infoLabel = null;
    private Label unknownLabel = null;
    private Label totalLabel = null;
    private Shell m_shell = null;

    public EventListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
        this.m_shell = this.getShell();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(5, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Table table = new Table((Composite)this, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 5;
        table.setLayoutData((Object)gridData);
        this.criticalLabel = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.criticalLabel.setLayoutData((Object)gridData);
        this.criticalLabel.setBackground(this.getDisplay().getSystemColor(3));
        this.warningLabel = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.warningLabel.setLayoutData((Object)gridData);
        this.warningLabel.setBackground(this.getDisplay().getSystemColor(7));
        this.infoLabel = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.infoLabel.setLayoutData((Object)gridData);
        this.infoLabel.setBackground(this.getDisplay().getSystemColor(5));
        this.unknownLabel = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.unknownLabel.setLayoutData((Object)gridData);
        this.unknownLabel.setBackground(new Color(null, 128, 192, 255));
        this.totalLabel = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.totalLabel.setLayoutData((Object)gridData);
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetEventListTableDefine.getEventListTableDefine(), 1, -1);
        int i = 0;
        while (i < table.getColumnCount()) {
            table.getColumn(i).setMoveable(true);
            ++i;
        }
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                List list = (List)((StructuredSelection)event.getSelection()).getFirstElement();
                EventInfoDialog dialog = new EventInfoDialog(EventListComposite.this.m_shell, list);
                if (dialog.open() == 0) {
                    Property eventdetail = dialog.getInputData();
                    CommentEvent comment = new CommentEvent();
                    comment.updateComment(eventdetail);
                    IWorkbench workbench = ClusterControlPlugin.getDefault().getWorkbench();
                    IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
                    EventView eventView = (EventView)page.findView("com.clustercontrol.monitor.view.EventView");
                    if (eventView != null) {
                        eventView.update();
                    }
                }
            }
        });
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public Table getTable() {
        return this.tableViewer.getTable();
    }

    public void update(String facilityId) {
        ViewListInfo infoList;
        block11: {
            super.update();
            infoList = null;
            try {
                int messages = ClusterControlPlugin.getDefault().getPreferenceStore().getInt("eventMaxMessages");
                infoList = MonitorEndpointWrapper.getEventList(facilityId, null, messages);
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                if (LocalSession.isDialogFlag()) {
                    LocalSession.setDialogFlag(false);
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    LocalSession.setDialogFlag(true);
                }
            }
            catch (MonitorNotFound_Exception e) {
                MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.monitor.63")) + ", " + e.getMessage()));
            }
            catch (HinemosUnknown_Exception e) {
                MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.monitor.63")) + ", " + e.getMessage()));
            }
            catch (Exception e) {
                if (!LocalSession.isDialogFlag()) break block11;
                LocalSession.setDialogFlag(false);
                if (e instanceof ClientTransportException) {
                    m_log.info((Object)("update() getEventList, " + e.getMessage()));
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.transfer")) + ", " + e.getMessage()));
                } else {
                    m_log.warn((Object)("update() getEventListAll, " + e.getMessage()), (Throwable)e);
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
                }
                LocalSession.setDialogFlag(true);
            }
        }
        if (infoList == null) {
            infoList = new ViewListInfo();
            infoList.setTotal(Integer.valueOf(0));
            infoList.setCritical(Integer.valueOf(0));
            infoList.setWarning(Integer.valueOf(0));
            infoList.setInfo(Integer.valueOf(0));
            infoList.setUnKnown(Integer.valueOf(0));
        }
        ArrayList list = ConvertListUtil.eventLogDataListToArrayList(infoList.getEventList());
        List objList = infoList.getEventList();
        objList.clear();
        if (list != null) {
            objList.addAll(list);
        }
        if (ClusterControlPlugin.getDefault().getPreferenceStore().getBoolean("eventMessageFlg") && infoList.getTotal() > infoList.getEventList().size() && LocalSession.isDialogFlag()) {
            LocalSession.setDialogFlag(false);
            MessageDialogWithToggle.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.monitor.12"), (String)Messages.getString((String)"message.will.not.be.displayed"), (boolean)false, (IPreferenceStore)ClusterControlPlugin.getDefault().getPreferenceStore(), (String)"eventMessageFlg");
            LocalSession.setDialogFlag(true);
        }
        this.updateStatus(infoList);
        Object[] args = new Object[]{this.totalLabel.getText()};
        this.totalLabel.setText(Messages.getString((String)"records", (Object[])args));
        this.tableViewer.setInput(infoList.getEventList());
    }

    public void update(String facilityId, Property condition) {
        ViewListInfo infoList;
        block11: {
            super.update();
            infoList = null;
            try {
                int messages = ClusterControlPlugin.getDefault().getPreferenceStore().getInt("eventMaxMessages");
                PropertyUtil.deletePropertyDefine(condition);
                EventFilterInfo filter = EventFilterPropertyUtil.property2dto(condition);
                infoList = MonitorEndpointWrapper.getEventList(facilityId, filter, messages);
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                if (LocalSession.isDialogFlag()) {
                    LocalSession.setDialogFlag(false);
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    LocalSession.setDialogFlag(true);
                }
            }
            catch (MonitorNotFound_Exception e) {
                MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.monitor.63")) + ", " + e.getMessage()));
            }
            catch (HinemosUnknown_Exception e) {
                MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.monitor.63")) + ", " + e.getMessage()));
            }
            catch (Exception e) {
                if (!LocalSession.isDialogFlag()) break block11;
                LocalSession.setDialogFlag(false);
                if (e instanceof ClientTransportException) {
                    m_log.info((Object)("update() getEventList, " + e.getMessage()));
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.transfer")) + ", " + e.getMessage()));
                } else {
                    m_log.warn((Object)("update() getEventList, " + e.getMessage()), (Throwable)e);
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
                }
                LocalSession.setDialogFlag(true);
            }
        }
        if (infoList == null) {
            infoList = new ViewListInfo();
            infoList.setTotal(Integer.valueOf(0));
            infoList.setCritical(Integer.valueOf(0));
            infoList.setWarning(Integer.valueOf(0));
            infoList.setInfo(Integer.valueOf(0));
            infoList.setUnKnown(Integer.valueOf(0));
        }
        ArrayList list = ConvertListUtil.eventLogDataListToArrayList(infoList.getEventList());
        List objList = infoList.getEventList();
        objList.clear();
        if (list != null) {
            objList.addAll(list);
        }
        if (ClusterControlPlugin.getDefault().getPreferenceStore().getBoolean("eventMessageFlg") && infoList.getTotal() > infoList.getEventList().size() && LocalSession.isDialogFlag()) {
            LocalSession.setDialogFlag(false);
            MessageDialogWithToggle.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.monitor.12"), (String)Messages.getString((String)"message.will.not.be.displayed"), (boolean)false, (IPreferenceStore)ClusterControlPlugin.getDefault().getPreferenceStore(), (String)"eventMessageFlg");
            LocalSession.setDialogFlag(true);
        }
        this.updateStatus(infoList);
        Object[] args = new Object[]{this.totalLabel.getText()};
        this.totalLabel.setText(Messages.getString((String)"filtered.records", (Object[])args));
        this.tableViewer.setInput(infoList.getEventList());
    }

    private void updateStatus(ViewListInfo list) {
        int messageNumber = ClusterControlPlugin.getDefault().getPreferenceStore().getInt("eventMaxMessages");
        this.criticalLabel.setText(String.valueOf(list.getCritical()));
        this.warningLabel.setText(String.valueOf(list.getWarning()));
        this.infoLabel.setText(String.valueOf(list.getInfo()));
        this.unknownLabel.setText(String.valueOf(list.getUnKnown()));
        this.totalLabel.setText(String.valueOf(list.getTotal() > messageNumber ? messageNumber : list.getTotal()));
    }
}

