/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.composite;

import com.clustercontrol.bean.RunIntervalConstant;
import com.clustercontrol.calendar.composite.CalendarIdListComposite;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.monitor.MonitorInfo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MonitorRuleComposite
extends Composite {
    public static final int WIDTH_TITLE = 4;
    public static final int WIDTH_VALUE = 5;
    public static final int WIDTH_WHITE_SPACE = 5;
    private Combo m_comboRunInterval = null;
    private CalendarIdListComposite m_calendarId = null;

    public MonitorRuleComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 15;
        this.setLayout((Layout)layout);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"run.interval")) + " : ");
        this.m_comboRunInterval = new Combo((Composite)this, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboRunInterval.setLayoutData((Object)gridData);
        this.m_comboRunInterval.add(RunIntervalConstant.STRING_MIN_01);
        this.m_comboRunInterval.add(RunIntervalConstant.STRING_MIN_05);
        this.m_comboRunInterval.add(RunIntervalConstant.STRING_MIN_10);
        this.m_comboRunInterval.add(RunIntervalConstant.STRING_MIN_30);
        this.m_comboRunInterval.add(RunIntervalConstant.STRING_MIN_60);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_calendarId = new CalendarIdListComposite(this, 0, true);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_calendarId.setLayoutData(gridData);
    }

    public void setInputData(MonitorInfo info) {
        if (info != null) {
            if (this.m_comboRunInterval.isEnabled()) {
                this.m_comboRunInterval.setText(RunIntervalConstant.typeToString((int)info.getRunInterval()));
            } else {
                this.m_comboRunInterval.add("0");
                this.m_comboRunInterval.setText("0");
            }
            if (info.getCalendarId() != null) {
                if (!this.m_calendarId.getEnabled()) {
                    this.m_calendarId.addText(info.getCalendarId());
                }
                this.m_calendarId.setText(info.getCalendarId());
            }
        }
    }

    public ValidateResult createInputData(MonitorInfo info) {
        if (info != null) {
            if (this.m_comboRunInterval.getText() != null && !"".equals(this.m_comboRunInterval.getText().trim())) {
                if ("0".equals(this.m_comboRunInterval.getText())) {
                    info.setRunInterval(0);
                } else {
                    info.setRunInterval(RunIntervalConstant.stringToType((String)this.m_comboRunInterval.getText()));
                }
            }
            if (this.m_calendarId.getText() != null && !"".equals(this.m_calendarId.getText().trim())) {
                info.setCalendarId(this.m_calendarId.getText());
            }
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        this.m_comboRunInterval.setEnabled(enabled);
        this.m_calendarId.setEnabled(enabled);
    }

    public void setRunIntervalEnabled(boolean enabled) {
        this.m_comboRunInterval.setEnabled(enabled);
    }

    protected ValidateResult setValidateResult(String id, String message) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        return validateResult;
    }

    public CalendarIdListComposite getCalendarId() {
        return this.m_calendarId;
    }
}

