/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.view;

import com.clustercontrol.accesscontrol.util.ObjectBean;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.composite.MonitorListComposite;
import com.clustercontrol.monitor.composite.action.MonitorListSelectionChangedListener;
import com.clustercontrol.view.CommonViewPart;
import com.clustercontrol.view.ObjectPrivilegeTargetListView;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class MonitorListView
extends CommonViewPart
implements ObjectPrivilegeTargetListView {
    public static final String ID = "com.clustercontrol.monitor.view.MonitorListView";
    private MonitorListComposite composite = null;
    private Property condition = null;

    @Override
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.composite = new MonitorListComposite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.composite.setLayoutData(gridData);
        this.createContextMenu();
        this.composite.getTableViewer().addSelectionChangedListener(new MonitorListSelectionChangedListener());
        this.update();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MonitorListView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.composite.getTable());
        this.composite.getTable().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem monitorAdd = (ActionContributionItem)toolbar.find("com.clustercontrol.monitor.view.action.MonitorAddAction");
        ActionContributionItem monitorModify = (ActionContributionItem)toolbar.find("com.clustercontrol.monitor.view.action.MonitorModifyAction");
        ActionContributionItem monitorDelete = (ActionContributionItem)toolbar.find("com.clustercontrol.monitor.view.action.MonitorDeleteAction");
        ActionContributionItem monitorCopy = (ActionContributionItem)toolbar.find("com.clustercontrol.monitor.view.action.MonitorCopyAction");
        ActionContributionItem monitorEnable = (ActionContributionItem)toolbar.find("com.clustercontrol.monitor.view.action.MonitorEnableAction");
        ActionContributionItem monitorDisable = (ActionContributionItem)toolbar.find("com.clustercontrol.monitor.view.action.MonitorDisableAction");
        ActionContributionItem collectorEnable = (ActionContributionItem)toolbar.find("com.clustercontrol.monitor.view.action.CollectorEnableAction");
        ActionContributionItem collectorDisable = (ActionContributionItem)toolbar.find("com.clustercontrol.monitor.view.action.CollectorDisableAction");
        ActionContributionItem objPrivilege = (ActionContributionItem)toolbar.find("com.clustercontrol.view.action.ObjectPrivilegeAction");
        manager.add(monitorAdd.getAction());
        manager.add(monitorModify.getAction());
        manager.add(monitorDelete.getAction());
        manager.add((IContributionItem)new Separator());
        manager.add(monitorCopy.getAction());
        manager.add((IContributionItem)new Separator());
        manager.add(monitorEnable.getAction());
        manager.add(monitorDisable.getAction());
        manager.add(collectorEnable.getAction());
        manager.add(collectorDisable.getAction());
        manager.add((IContributionItem)new Separator());
        manager.add(objPrivilege.getAction());
    }

    public Composite getListComposite() {
        return this.composite;
    }

    public void update(Property condition) {
        this.condition = condition;
        this.update();
    }

    @Override
    public void update() {
        this.composite.update(this.condition);
    }

    public void setEnabledAction(int num, ISelection selection) {
        super.setEnabledAction("com.clustercontrol.view.action.ObjectPrivilegeAction", selection);
        super.setEnabledAction("com.clustercontrol.monitor.view.action.MonitorCopyAction", selection);
        super.setEnabledAction("com.clustercontrol.monitor.view.action.MonitorDeleteAction", selection);
        super.setEnabledAction("com.clustercontrol.monitor.view.action.MonitorModifyAction", selection);
        super.setEnabledAction("com.clustercontrol.monitor.view.action.MonitorDisableAction", selection);
        super.setEnabledAction("com.clustercontrol.monitor.view.action.MonitorEnableAction", selection);
        super.setEnabledAction("com.clustercontrol.monitor.view.action.CollectorDisableAction", selection);
        super.setEnabledAction("com.clustercontrol.monitor.view.action.CollectorEnableAction", selection);
        if (num > 0) {
            super.setEnabledAction("com.clustercontrol.monitor.view.action.MonitorDisableAction", true);
            super.setEnabledAction("com.clustercontrol.monitor.view.action.MonitorEnableAction", true);
            super.setEnabledAction("com.clustercontrol.monitor.view.action.CollectorDisableAction", true);
            super.setEnabledAction("com.clustercontrol.monitor.view.action.CollectorEnableAction", true);
            super.setEnabledAction("com.clustercontrol.view.action.ObjectPrivilegeAction", true);
            if (num == 1) {
                super.setEnabledAction("com.clustercontrol.monitor.view.action.MonitorCopyAction", true);
                super.setEnabledAction("com.clustercontrol.monitor.view.action.MonitorDeleteAction", true);
                super.setEnabledAction("com.clustercontrol.monitor.view.action.MonitorModifyAction", true);
            } else {
                super.setEnabledAction("com.clustercontrol.monitor.view.action.MonitorCopyAction", false);
                super.setEnabledAction("com.clustercontrol.monitor.view.action.MonitorDeleteAction", false);
                super.setEnabledAction("com.clustercontrol.monitor.view.action.MonitorModifyAction", false);
            }
        } else {
            super.setEnabledAction("com.clustercontrol.view.action.ObjectPrivilegeAction", false);
            super.setEnabledAction("com.clustercontrol.monitor.view.action.MonitorCopyAction", false);
            super.setEnabledAction("com.clustercontrol.monitor.view.action.MonitorDeleteAction", false);
            super.setEnabledAction("com.clustercontrol.monitor.view.action.MonitorModifyAction", false);
            super.setEnabledAction("com.clustercontrol.monitor.view.action.MonitorDisableAction", false);
            super.setEnabledAction("com.clustercontrol.monitor.view.action.MonitorEnableAction", false);
            super.setEnabledAction("com.clustercontrol.monitor.view.action.CollectorDisableAction", false);
            super.setEnabledAction("com.clustercontrol.monitor.view.action.CollectorEnableAction", false);
        }
    }

    @Override
    public List<ObjectBean> getSelectedObjectBeans() {
        StructuredSelection selection = (StructuredSelection)this.composite.getTableViewer().getSelection();
        Object[] objs = selection.toArray();
        String objectType = "MON";
        String objectId = null;
        ArrayList<ObjectBean> objectBeans = new ArrayList<ObjectBean>();
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            objectId = (String)((List)obj).get(0);
            ObjectBean objectBean = new ObjectBean(objectType, objectId);
            objectBeans.add(objectBean);
            ++n2;
        }
        return objectBeans;
    }

    @Override
    public String getSelectedOwnerRoleId() {
        StructuredSelection selection = (StructuredSelection)this.composite.getTableViewer().getSelection();
        List list = (List)selection.getFirstElement();
        String id = null;
        if (list != null) {
            id = (String)list.get(9);
        }
        return id;
    }
}

