/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.view.action;

import com.clustercontrol.monitor.composite.StatusListComposite;
import com.clustercontrol.monitor.util.ConvertListUtil;
import com.clustercontrol.monitor.util.MonitorEndpointWrapper;
import com.clustercontrol.monitor.view.StatusView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.monitor.HinemosUnknown_Exception;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.MonitorNotFound_Exception;
import com.clustercontrol.ws.monitor.StatusDataInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class StatusDeleteAction
implements IViewActionDelegate {
    private static Log m_log = LogFactory.getLog(StatusDeleteAction.class);
    public static final String ID = "com.clustercontrol.monitor.view.action.StatusDeleteAction";
    private IViewPart viewPart;

    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    public void run(IAction action) {
        ArrayList<StatusDataInfo> statusList;
        StatusView view = (StatusView)((Object)this.viewPart.getAdapter(StatusView.class));
        StatusListComposite composite = (StatusListComposite)view.getListComposite();
        StructuredSelection selection = (StructuredSelection)composite.getTableViewer().getSelection();
        List list = selection.toList();
        if (list != null && (statusList = ConvertListUtil.listToStatusInfoDataList(list)) != null && statusList.size() > 0) {
            try {
                MonitorEndpointWrapper.deleteStatus(statusList);
                view.update();
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (MonitorNotFound_Exception e) {
                MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.monitor.61")) + ", " + e.getMessage()));
            }
            catch (HinemosUnknown_Exception e) {
                MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.monitor.61")) + ", " + e.getMessage()));
            }
            catch (Exception e) {
                m_log.warn((Object)("run(), " + e.getMessage()), (Throwable)e);
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

