/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.action;

import com.clustercontrol.notify.util.NotifyEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.notify.InvalidRole_Exception;
import com.clustercontrol.ws.notify.NotifyInfo;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;

public class GetNotify {
    private static Log m_log = LogFactory.getLog(GetNotify.class);

    public NotifyInfo getNotify(String notifyId) {
        NotifyInfo info = null;
        try {
            info = NotifyEndpointWrapper.getNotify(notifyId);
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("useCheck(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        return info;
    }

    public List<NotifyInfo> getNotifyList() {
        List<NotifyInfo> records = null;
        try {
            records = NotifyEndpointWrapper.getNotifyList();
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("getNotifyList(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        return records;
    }

    public List<NotifyInfo> getNotifyListByOwnerRole(String ownerRoleId) throws InvalidRole_Exception {
        List<NotifyInfo> records = null;
        try {
            records = NotifyEndpointWrapper.getNotifyListByOwnerRole(ownerRoleId);
        }
        catch (InvalidRole_Exception e) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            throw e;
        }
        catch (Exception e) {
            m_log.warn((Object)("getNotifyListByOwnerRole(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        return records;
    }
}

