/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.composite;

import com.clustercontrol.notify.dialog.NotifyListDialog;
import com.clustercontrol.notify.util.NotifyTypeUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.notify.NotifyRelationInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class NotifyIdListComposite
extends Composite {
    private String m_text = null;
    private Label m_labelNotifyId = null;
    private Table m_NotifyIdTable = null;
    private Button m_buttonRefer = null;
    private List<NotifyRelationInfo> notify;
    private int notifyIdType = 0;
    private String m_ownerRoleId = null;

    public NotifyIdListComposite(Composite parent, int style, boolean labelFlg) {
        super(parent, style);
        this.m_text = Messages.getString((String)"notify.id");
        this.initialize(parent, labelFlg);
    }

    public NotifyIdListComposite(Composite parent, int style, boolean labelFlg, int notifyIdType) {
        super(parent, style);
        this.m_text = Messages.getString((String)"notify.id");
        this.notifyIdType = notifyIdType;
        this.initialize(parent, labelFlg);
    }

    public NotifyIdListComposite(Composite parent, int style, String text) {
        super(parent, style);
        this.m_text = text;
        this.initialize(parent, true);
    }

    private void initialize(Composite parent, boolean labelFlg) {
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = labelFlg ? 15 : 10;
        this.setLayout((Layout)layout);
        if (labelFlg) {
            this.m_labelNotifyId = new Label((Composite)this, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 4;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.m_labelNotifyId.setLayoutData((Object)gridData);
            this.m_labelNotifyId.setText(String.valueOf(this.m_text) + " : ");
        }
        this.m_NotifyIdTable = new Table((Composite)this, 68100);
        this.m_NotifyIdTable.setHeaderVisible(true);
        this.m_NotifyIdTable.setLinesVisible(true);
        this.m_NotifyIdTable.setLayoutData((Object)new RowData(200, 100));
        TableColumn col = new TableColumn(this.m_NotifyIdTable, 16384);
        col.setText(Messages.getString((String)"NotifyIdListComposite.notifyId"));
        col.setWidth(130);
        TableColumn col2 = new TableColumn(this.m_NotifyIdTable, 16384);
        col2.setText(Messages.getString((String)"NotifyIdListComposite.notifyType"));
        col2.setWidth(100);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.heightHint = 100;
        this.m_NotifyIdTable.setLayoutData((Object)gridData);
        this.m_buttonRefer = new Button((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_buttonRefer.setLayoutData((Object)gridData);
        this.m_buttonRefer.setText(Messages.getString((String)"select"));
        this.m_buttonRefer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                NotifyListDialog dialog = new NotifyListDialog(shell, true, NotifyIdListComposite.this.notifyIdType, NotifyIdListComposite.this.m_ownerRoleId);
                if (NotifyIdListComposite.this.notify != null) {
                    dialog.setSelectNotify(NotifyIdListComposite.this.notify);
                }
                dialog.open();
                NotifyIdListComposite.this.setNotify(dialog.getSelectNotify());
                NotifyIdListComposite.this.update();
            }
        });
    }

    public void update() {
    }

    public void setEnabled(boolean enabled) {
        this.m_buttonRefer.setEnabled(enabled);
        this.m_NotifyIdTable.setEnabled(enabled);
    }

    public void setButtonEnabled(boolean enabled) {
        this.m_buttonRefer.setEnabled(enabled);
    }

    public List<NotifyRelationInfo> getNotify() {
        return this.notify;
    }

    public void setNotify(List<NotifyRelationInfo> notify) {
        this.notify = notify;
        this.m_NotifyIdTable.removeAll();
        int i = 0;
        while (i < notify.size()) {
            TableItem ti = new TableItem(this.m_NotifyIdTable, 0);
            NotifyRelationInfo nri = (NotifyRelationInfo)((ArrayList)notify).get(i);
            String notifyType = NotifyTypeUtil.typeToString(nri.getNotifyType());
            String[] repData = new String[]{nri.getNotifyId(), notifyType};
            ti.setText(repData);
            ++i;
        }
        this.m_NotifyIdTable.update();
    }

    public boolean setNotifyGroupId(String string) {
        if (this.notify != null && this.notify.size() != 0) {
            int i = 0;
            while (i < this.notify.size()) {
                NotifyRelationInfo nri = (NotifyRelationInfo)((ArrayList)this.notify).get(i);
                nri.setNotifyGroupId(string);
                ++i;
            }
            return true;
        }
        return false;
    }

    public String getOwnerRoleId() {
        return this.m_ownerRoleId;
    }

    public void setOwnerRoleId(String ownerRoleId) {
        this.m_ownerRoleId = ownerRoleId;
        this.m_NotifyIdTable.removeAll();
        this.notify = null;
    }
}

