/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.composite;

import com.clustercontrol.bean.Property;
import com.clustercontrol.notify.action.GetNotify;
import com.clustercontrol.notify.action.GetNotifyTableDefineCheckBox;
import com.clustercontrol.notify.action.GetNotifyTableDefineNoCheckBox;
import com.clustercontrol.notify.composite.action.NotifyDoubleClickListener;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.notify.InvalidRole_Exception;
import com.clustercontrol.ws.notify.NotifyInfo;
import com.clustercontrol.ws.notify.NotifyRelationInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class NotifyListComposite
extends Composite {
    private CommonTableViewer tableViewer = null;
    private boolean isSelect = false;
    private Label totalLabel = null;
    private Property condition = null;
    private List<NotifyRelationInfo> notify;
    private String ownerRoleId = null;
    private boolean showFlg = true;

    public NotifyListComposite(Composite parent, int style, boolean isSelect, String ownerRoleId) {
        super(parent, style);
        this.isSelect = isSelect;
        this.ownerRoleId = ownerRoleId;
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        final Table table = new Table((Composite)this, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.tableViewer = new CommonTableViewer(table);
        if (this.isSelect) {
            this.tableViewer.createTableColumn(GetNotifyTableDefineCheckBox.get(), 2, 1);
        } else {
            this.tableViewer.createTableColumn(GetNotifyTableDefineNoCheckBox.get(), 0, 1);
            this.tableViewer.addDoubleClickListener(new NotifyDoubleClickListener(this));
        }
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        if (this.isSelect) {
            table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableItem[] ti = table.getSelection();
                    int i = 0;
                    while (i < ti.length) {
                        ArrayList al = (ArrayList)ti[i].getData();
                        if (((Boolean)al.get(0)).booleanValue()) {
                            al.set(0, false);
                        } else {
                            al.set(0, true);
                        }
                        ++i;
                    }
                    NotifyListComposite.this.tableViewer.refresh();
                }
            });
        } else {
            this.totalLabel = new Label((Composite)this, 131072);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 4;
            this.totalLabel.setLayoutData((Object)gridData);
        }
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public Table getTable() {
        return this.tableViewer.getTable();
    }

    public void update() {
        List<NotifyInfo> list = null;
        ArrayList<ArrayList> listInput = new ArrayList<ArrayList>();
        if (this.isSelect) {
            if (this.ownerRoleId != null && !this.ownerRoleId.equals("")) {
                try {
                    list = new GetNotify().getNotifyListByOwnerRole(this.ownerRoleId);
                }
                catch (InvalidRole_Exception invalidRole_Exception) {
                    this.setShowFlg(false);
                    return;
                }
            }
        } else {
            list = new GetNotify().getNotifyList();
        }
        if (list == null) {
            list = new ArrayList<NotifyInfo>();
        }
        for (NotifyInfo info : list) {
            ArrayList<Object> a = new ArrayList<Object>();
            if (this.isSelect) {
                a.add(false);
                a.add(info.getValidFlg());
                a.add(info.getNotifyId());
                a.add(info.getDescription());
                a.add(info.getNotifyType());
            } else {
                a.add(info.getNotifyId());
                a.add(info.getDescription());
                a.add(info.getNotifyType());
                a.add(info.getValidFlg());
            }
            a.add(info.getOwnerRoleId());
            a.add(info.getRegUser());
            a.add(info.getRegDate() == null ? null : new Date(info.getRegDate()));
            a.add(info.getUpdateUser());
            a.add(info.getUpdateDate() == null ? null : new Date(info.getUpdateDate()));
            listInput.add(a);
        }
        if (this.notify == null) {
            this.notify = new ArrayList<NotifyRelationInfo>();
        }
        if (this.isSelect) {
            boolean flg = false;
            Iterator<NotifyRelationInfo> it = this.notify.iterator();
            NotifyRelationInfo nri = null;
            while (it.hasNext()) {
                nri = it.next();
                nri.setNotifyGroupId(null);
                flg = false;
                int i = 0;
                while (i < list.size()) {
                    NotifyInfo info = list.get(i);
                    ArrayList objList = (ArrayList)listInput.get(i);
                    String tableNotifyId = info.getNotifyId();
                    if (tableNotifyId.equals(nri.getNotifyId())) {
                        objList.set(0, true);
                        flg = true;
                    }
                    objList.set(1, info.getValidFlg());
                    objList.set(2, info.getNotifyId());
                    objList.set(3, info.getDescription());
                    objList.set(4, info.getNotifyType());
                    objList.set(5, info.getOwnerRoleId());
                    objList.set(6, info.getRegUser());
                    objList.set(7, new Date(info.getRegDate()));
                    objList.set(8, info.getUpdateUser());
                    objList.set(9, new Date(info.getUpdateDate()));
                    listInput.set(i, objList);
                    ++i;
                }
                if (flg || nri == null) continue;
                this.notify.remove(nri);
            }
        } else {
            Object[] args = new String[]{String.valueOf(list.size())};
            String message = null;
            message = this.condition == null ? Messages.getString((String)"records", (Object[])args) : Messages.getString((String)"filtered.records", (Object[])args);
            this.totalLabel.setText(message);
        }
        this.tableViewer.setInput(listInput);
    }

    public void setSelectNotify(List<NotifyRelationInfo> notify) {
        if (notify != null) {
            this.notify = new ArrayList<NotifyRelationInfo>();
        }
        this.notify = notify;
    }

    public List<NotifyRelationInfo> getSelectNotify() {
        return this.notify;
    }

    public boolean makeNotifyData() {
        TableItem[] ti = this.tableViewer.getTable().getItems();
        ArrayList<NotifyRelationInfo> ct = new ArrayList<NotifyRelationInfo>();
        if (this.isSelect) {
            int i = 0;
            while (i < ti.length) {
                ArrayList al = (ArrayList)ti[i].getData();
                if (((Boolean)al.get(0)).booleanValue()) {
                    NotifyRelationInfo nri = new NotifyRelationInfo();
                    nri.setNotifyGroupId(null);
                    nri.setNotifyId((String)al.get(2));
                    nri.setNotifyType((Integer)al.get(4));
                    nri.setNotifyFlg(Integer.valueOf(0));
                    ct.add(nri);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < ti.length) {
                ArrayList al = (ArrayList)ti[i].getData();
                ++i;
            }
        }
        this.notify.clear();
        this.notify.addAll(ct);
        return true;
    }

    public ArrayList<String> getSelectionData() {
        ArrayList<String> data = new ArrayList<String>();
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        List list = selection.toList();
        if (list != null) {
            int index = 0;
            while (index < list.size()) {
                ArrayList info = (ArrayList)list.get(index);
                if (info != null && info.size() > 0) {
                    String notifyId = (String)info.get(2);
                    data.add(notifyId);
                }
                ++index;
            }
        }
        return data;
    }

    public boolean isShowFlg() {
        return this.showFlg;
    }

    private void setShowFlg(boolean showFlg) {
        this.showFlg = showFlg;
    }
}

