/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.dialog;

import com.clustercontrol.bean.PriorityColorConstant;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.notify.action.AddNotify;
import com.clustercontrol.notify.action.GetNotify;
import com.clustercontrol.notify.action.ModifyNotify;
import com.clustercontrol.notify.dialog.NotifyBasicCreateDialog;
import com.clustercontrol.notify.mail.composite.MailTemplateIdListComposite;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.notify.NotifyInfo;
import com.clustercontrol.ws.notify.NotifyMailInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NotifyMailCreateDialog
extends NotifyBasicCreateDialog {
    private static final int WIDTH_PRIORITY = 2;
    private static final int WIDTH_CHECK = 2;
    private static final int WIDTH_MAIL_ADDRESS = 11;
    private final int TYPE_MAIL = 2;
    private NotifyInfo inputData = null;
    protected ValidateResult validateResult = null;
    private MailTemplateIdListComposite m_compositeMailTemplateIdList = null;
    private Button m_checkMailNormalInfo = null;
    private Button m_checkMailNormalWarning = null;
    private Button m_checkMailNormalCritical = null;
    private Button m_checkMailNormalUnknown = null;
    private Text m_textMailAddressInfo = null;
    private Text m_textMailAddressWarning = null;
    private Text m_textMailAddressCritical = null;
    private Text m_textMailAddressUnknown = null;
    private String ownerRoleId = null;

    public NotifyMailCreateDialog(Shell parent) {
        super(parent);
    }

    public NotifyMailCreateDialog(Shell parent, int notifyIdType) {
        super(parent, notifyIdType);
    }

    public NotifyMailCreateDialog(Shell parent, String notifyId, boolean updateFlg) {
        super(parent, notifyId, updateFlg);
    }

    @Override
    protected void customizeDialog(Composite parent) {
        super.customizeDialog(parent);
        NotifyInfo info = null;
        info = this.notifyId != null ? new GetNotify().getNotify(this.notifyId) : new NotifyInfo();
        this.setInputData(info);
    }

    @Override
    protected void customizeSettingDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.notify.mail.create.modify"));
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        Group groupMail = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupMail.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupMail.setLayoutData((Object)gridData);
        groupMail.setText(Messages.getString((String)"notifies.mail"));
        this.m_compositeMailTemplateIdList = new MailTemplateIdListComposite((Composite)groupMail, 0, true);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.m_compositeMailTemplateIdList.setLayoutData(gridData);
        label = new Label((Composite)groupMail, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupMail, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"priority"));
        label = new Label((Composite)groupMail, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 2;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"notify.attribute"));
        label = new Label((Composite)groupMail, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 11;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"email.address.ssv"));
        label = this.getLabelPriority((Composite)groupMail, Messages.getString((String)"info"), PriorityColorConstant.COLOR_INFO);
        this.m_checkMailNormalInfo = this.getCheckMailNormal((Composite)groupMail);
        this.m_checkMailNormalInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyMailCreateDialog.this.m_textMailAddressInfo.setEnabled(NotifyMailCreateDialog.this.m_checkMailNormalInfo.getSelection());
                NotifyMailCreateDialog.this.update();
            }
        });
        this.m_textMailAddressInfo = this.getTextMailAddress((Composite)groupMail);
        this.m_textMailAddressInfo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NotifyMailCreateDialog.this.update();
            }
        });
        label = this.getLabelPriority((Composite)groupMail, Messages.getString((String)"warning"), PriorityColorConstant.COLOR_WARNING);
        this.m_checkMailNormalWarning = this.getCheckMailNormal((Composite)groupMail);
        this.m_checkMailNormalWarning.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyMailCreateDialog.this.m_textMailAddressWarning.setEnabled(NotifyMailCreateDialog.this.m_checkMailNormalWarning.getSelection());
                NotifyMailCreateDialog.this.update();
            }
        });
        this.m_textMailAddressWarning = this.getTextMailAddress((Composite)groupMail);
        this.m_textMailAddressWarning.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NotifyMailCreateDialog.this.update();
            }
        });
        label = this.getLabelPriority((Composite)groupMail, Messages.getString((String)"critical"), PriorityColorConstant.COLOR_CRITICAL);
        this.m_checkMailNormalCritical = this.getCheckMailNormal((Composite)groupMail);
        this.m_checkMailNormalCritical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyMailCreateDialog.this.m_textMailAddressCritical.setEnabled(NotifyMailCreateDialog.this.m_checkMailNormalCritical.getSelection());
                NotifyMailCreateDialog.this.update();
            }
        });
        this.m_textMailAddressCritical = this.getTextMailAddress((Composite)groupMail);
        this.m_textMailAddressCritical.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NotifyMailCreateDialog.this.update();
            }
        });
        label = this.getLabelPriority((Composite)groupMail, Messages.getString((String)"unknown"), PriorityColorConstant.COLOR_UNKNOWN);
        this.m_checkMailNormalUnknown = this.getCheckMailNormal((Composite)groupMail);
        this.m_checkMailNormalUnknown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifyMailCreateDialog.this.m_textMailAddressUnknown.setEnabled(NotifyMailCreateDialog.this.m_checkMailNormalUnknown.getSelection());
                NotifyMailCreateDialog.this.update();
            }
        });
        this.m_textMailAddressUnknown = this.getTextMailAddress((Composite)groupMail);
        this.m_textMailAddressUnknown.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NotifyMailCreateDialog.this.update();
            }
        });
    }

    public void update() {
        this.m_textMailAddressInfo.setEnabled(this.m_checkMailNormalInfo.getSelection());
        this.m_textMailAddressWarning.setEnabled(this.m_checkMailNormalWarning.getSelection());
        this.m_textMailAddressCritical.setEnabled(this.m_checkMailNormalCritical.getSelection());
        this.m_textMailAddressUnknown.setEnabled(this.m_checkMailNormalUnknown.getSelection());
        if (this.m_checkMailNormalInfo.getSelection() && "".equals(this.m_textMailAddressInfo.getText())) {
            this.m_textMailAddressInfo.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textMailAddressInfo.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_checkMailNormalWarning.getSelection() && "".equals(this.m_textMailAddressWarning.getText())) {
            this.m_textMailAddressWarning.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textMailAddressWarning.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_checkMailNormalCritical.getSelection() && "".equals(this.m_textMailAddressCritical.getText())) {
            this.m_textMailAddressCritical.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textMailAddressCritical.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_checkMailNormalUnknown.getSelection() && "".equals(this.m_textMailAddressUnknown.getText())) {
            this.m_textMailAddressUnknown.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textMailAddressUnknown.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    @Override
    public NotifyInfo getInputData() {
        return this.inputData;
    }

    @Override
    protected void setInputData(NotifyInfo notify) {
        this.inputData = notify;
        this.m_notifyBasic.setInputData(notify, this.updateFlg);
        this.m_notifyInitial.setInputData(notify);
        this.m_notifyInhibition.setInputData(notify);
        List list = notify.getNotifyMailInfo();
        if (list != null && list.size() > 0) {
            int index = 0;
            while (index < list.size()) {
                NotifyMailInfo mail = (NotifyMailInfo)list.get(index);
                if (mail != null) {
                    if (3 == mail.getPriority()) {
                        this.setInputDataForMail(mail, this.m_checkMailNormalInfo, this.m_textMailAddressInfo, null);
                        if (mail.getMailTemplateId() != null) {
                            this.m_compositeMailTemplateIdList.setText(mail.getMailTemplateId());
                        }
                    } else if (2 == mail.getPriority()) {
                        this.setInputDataForMail(mail, this.m_checkMailNormalWarning, this.m_textMailAddressWarning, null);
                    } else if (mail.getPriority() == 0) {
                        this.setInputDataForMail(mail, this.m_checkMailNormalCritical, this.m_textMailAddressCritical, null);
                    } else if (1 == mail.getPriority()) {
                        this.setInputDataForMail(mail, this.m_checkMailNormalUnknown, this.m_textMailAddressUnknown, null);
                    }
                }
                ++index;
            }
        }
        if (notify.getValidFlg() != null && notify.getValidFlg() == 0) {
            this.m_confirmValid.setSelection(false);
        } else {
            this.m_confirmValid.setSelection(true);
        }
        this.update();
    }

    protected void setInputDataForMail(NotifyMailInfo info, Button checkMailNormal, Text textMailAddress, Button checkMailInhibition) {
        if (info.getValidFlg() != null && info.getValidFlg() == 1) {
            checkMailNormal.setSelection(true);
        }
        if (info.getMailAddress() != null) {
            textMailAddress.setText(info.getMailAddress());
        }
    }

    @Override
    protected NotifyInfo createInputData() {
        NotifyInfo info = new NotifyInfo();
        info.setNotifyType(Integer.valueOf(2));
        this.validateResult = this.m_notifyBasic.createInputData(info, this.notifyId);
        if (this.validateResult != null) {
            return null;
        }
        this.validateResult = this.m_notifyInitial.createInputData(info);
        if (this.validateResult != null) {
            return null;
        }
        this.validateResult = this.m_notifyInhibition.createInputData(info);
        if (this.validateResult != null) {
            return null;
        }
        ArrayList<NotifyMailInfo> list = new ArrayList<NotifyMailInfo>();
        list = this.createInputDataForMail(list, 3, this.m_checkMailNormalInfo, this.m_textMailAddressInfo);
        list = this.createInputDataForMail(list, 2, this.m_checkMailNormalWarning, this.m_textMailAddressWarning);
        list = this.createInputDataForMail(list, 0, this.m_checkMailNormalCritical, this.m_textMailAddressCritical);
        if ((list = this.createInputDataForMail(list, 1, this.m_checkMailNormalUnknown, this.m_textMailAddressUnknown)) == null) {
            return null;
        }
        List notifyMailInfo = info.getNotifyMailInfo();
        notifyMailInfo.clear();
        notifyMailInfo.addAll(list);
        if (this.m_confirmValid.getSelection()) {
            info.setValidFlg(Integer.valueOf(1));
        } else {
            info.setValidFlg(Integer.valueOf(0));
        }
        return info;
    }

    private ArrayList<NotifyMailInfo> createInputDataForMail(ArrayList<NotifyMailInfo> list, int priority, Button checkMailNormal, Text textMailAddress) {
        String mailTemplateId;
        if (list == null) {
            return null;
        }
        NotifyMailInfo mail = new NotifyMailInfo();
        mail.setPriority(Integer.valueOf(priority));
        if (checkMailNormal.getSelection()) {
            mail.setValidFlg(new Integer(1));
        } else {
            mail.setValidFlg(new Integer(0));
        }
        if (textMailAddress.getText() != null && !"".equals(textMailAddress.getText().trim())) {
            mail.setMailAddress(textMailAddress.getText());
        }
        if ((mailTemplateId = this.m_compositeMailTemplateIdList.getText()) != null && !"".equals(mailTemplateId.trim())) {
            mail.setMailTemplateId(mailTemplateId);
        }
        list.add(mail);
        return list;
    }

    @Override
    protected ValidateResult validate() {
        this.inputData = this.createInputData();
        if (this.inputData != null) {
            return super.validate();
        }
        return this.validateResult;
    }

    @Override
    protected boolean action() {
        boolean result = false;
        NotifyInfo info = this.getInputData();
        if (info != null) {
            result = !this.updateFlg ? new AddNotify().add(info) : new ModifyNotify().modify(info);
        }
        return result;
    }

    @Override
    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    @Override
    protected void setValidateResult(String id, String message) {
        this.validateResult = new ValidateResult();
        this.validateResult.setValid(false);
        this.validateResult.setID(id);
        this.validateResult.setMessage(message);
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.referenceFlg) {
            super.createButtonsForButtonBar(parent);
        } else {
            this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
        }
    }

    @Override
    protected void setEnabled(boolean enable) {
        this.m_notifyBasic.setEnabled(enable);
        this.m_notifyInhibition.setEnabled(enable);
    }

    private Label getLabelPriority(Composite parent, String text, Color background) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(text) + " : ");
        label.setBackground(background);
        return label;
    }

    private Button getCheckMailNormal(Composite parent) {
        Button button = new Button(parent, 32);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 2;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        return button;
    }

    private Text getTextMailAddress(Composite parent) {
        Text text = new Text(parent, 2048);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 11;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)gridData);
        return text;
    }

    @Override
    public void setOwnerRoleId(String ownerRoleId) {
        super.setOwnerRoleId(ownerRoleId);
        this.m_compositeMailTemplateIdList.update(ownerRoleId);
    }
}

