/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.dialog;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.notify.bean.NotifyTypeConstant;
import com.clustercontrol.notify.composite.NotifyTypeListComposite;
import com.clustercontrol.notify.util.NotifyTypeUtil;
import com.clustercontrol.notify.view.action.NotifyModifyAction;
import com.clustercontrol.util.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class NotifyTypeDialog
extends CommonDialog {
    private static Log m_log = LogFactory.getLog(NotifyTypeDialog.class);
    private final int sizeX = 300;
    private final int sizeY = 300;
    private NotifyTypeListComposite listComposite = null;
    private ListViewer notifyTypeList = null;
    Composite composite = null;

    public NotifyTypeDialog(Shell parent, Composite composite) {
        super(parent);
        this.composite = composite;
    }

    protected Point getInitialSize() {
        return new Point(300, 300);
    }

    @Override
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        parent.getShell().setText(Messages.getString((String)"notify.type.list"));
        GridLayout layout = new GridLayout(5, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.listComposite = new NotifyTypeListComposite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 5;
        this.listComposite.setLayoutData(gridData);
        this.notifyTypeList = this.listComposite.getNotifyTypeList();
        this.notifyTypeList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Integer notifyType = (Integer)element;
                return NotifyTypeUtil.typeToString(notifyType);
            }
        });
        for (Integer type : NotifyTypeConstant.getList()) {
            this.notifyTypeList.add((Object)type);
        }
        this.notifyTypeList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NotifyTypeDialog.this.okPressed();
            }
        });
        shell.pack();
        shell.setSize(new Point(shell.getSize().x, shell.getSize().y));
    }

    public Integer getSelectItem() {
        return this.listComposite.getSelectItem();
    }

    @Override
    protected void okPressed() {
        ValidateResult result = null;
        if (this.getSelectItem() == null) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.notify.28"));
            this.displayError(result);
        }
        Integer notifyType = this.getSelectItem();
        NotifyModifyAction action = new NotifyModifyAction();
        if (action.openDialog(this.getParentShell(), null, notifyType) == 0) {
            this.composite.update();
        }
    }

    @Override
    protected String getOkButtonText() {
        return Messages.getString((String)"next");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }
}

