/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.mail.dialog;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.composite.RoleIdListComposite;
import com.clustercontrol.composite.TextWithParameterComposite;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.notify.mail.util.MailTemplateEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.mailtemplate.InvalidRole_Exception;
import com.clustercontrol.ws.mailtemplate.MailTemplateDuplicate_Exception;
import com.clustercontrol.ws.mailtemplate.MailTemplateInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MailTemplateCreateDialog
extends CommonDialog {
    private static Log m_log = LogFactory.getLog(MailTemplateCreateDialog.class);
    public static final int WIDTH = 15;
    public static final int WIDTH_LABEL = 4;
    public static final int WIDTH_TEXT = 10;
    private MailTemplateInfo inputData = null;
    protected ValidateResult validateResult = null;
    private int mode;
    private String mailTemplateId = null;
    private Text textMailTemplateId = null;
    private Text textDescription = null;
    private RoleIdListComposite m_ownerRoleId = null;
    private TextWithParameterComposite textSubject = null;
    private TextWithParameterComposite textBody = null;

    public MailTemplateCreateDialog(Shell parent) {
        super(parent);
        this.mode = 0;
    }

    public MailTemplateCreateDialog(Shell parent, String mailTemplateId, int mode) {
        super(parent);
        this.mailTemplateId = mailTemplateId;
        this.mode = mode;
    }

    @Override
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.mail.template.create.modify"));
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"mail.template.id")) + " : ");
        this.textMailTemplateId = new Text(parent, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textMailTemplateId.setLayoutData((Object)gridData);
        if (this.mode == 2 || this.mode == 1) {
            this.textMailTemplateId.setEnabled(false);
        }
        this.textMailTemplateId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                MailTemplateCreateDialog.this.update();
            }
        });
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"description")) + " : ");
        this.textDescription = new Text(parent, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textDescription.setLayoutData((Object)gridData);
        Label labelRoleId = new Label(parent, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelRoleId.setLayoutData((Object)gridData);
        labelRoleId.setText(String.valueOf(Messages.getString((String)"owner.role.id")) + " : ");
        this.m_ownerRoleId = this.mode == 0 ? new RoleIdListComposite(parent, 0, true, RoleIdListComposite.Mode.OWNER_ROLE) : new RoleIdListComposite(parent, 0, false, RoleIdListComposite.Mode.OWNER_ROLE);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_ownerRoleId.setLayoutData(gridData);
        Group groupMailTemplate = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        groupMailTemplate.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupMailTemplate.setLayoutData((Object)gridData);
        groupMailTemplate.setText(Messages.getString((String)"mail.template.setting"));
        label = new Label((Composite)groupMailTemplate, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"subject")) + " : ");
        this.textSubject = new TextWithParameterComposite((Composite)groupMailTemplate, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 13;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textSubject.setLayoutData(gridData);
        this.textSubject.setToolTipText(Messages.getString((String)"notify.parameter.tooltip"));
        this.textSubject.setColor(new Color((Device)groupMailTemplate.getDisplay(), new RGB(0, 0, 255)));
        this.textSubject.setInputUpper(256);
        label = new Label((Composite)groupMailTemplate, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"response.body")) + " : ");
        this.textBody = new TextWithParameterComposite((Composite)groupMailTemplate, 19202);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.verticalSpan = 50;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.textBody.setLayoutData(gridData);
        this.textBody.setToolTipText(Messages.getString((String)"notify.parameter.tooltip"));
        this.textBody.setColor(new Color((Device)groupMailTemplate.getDisplay(), new RGB(0, 0, 255)));
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        line.setLayoutData((Object)gridData);
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        MailTemplateInfo info = null;
        if (this.mailTemplateId != null) {
            try {
                info = MailTemplateEndpointWrapper.getMailTemplateInfo(this.mailTemplateId);
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (Exception e) {
                m_log.warn((Object)("customizeDialog() getMailTemplateInfo, " + e.getMessage()), (Throwable)e);
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
        } else {
            info = new MailTemplateInfo();
        }
        this.setInputData(info);
    }

    public void update() {
        if ("".equals(this.textMailTemplateId.getText())) {
            this.textMailTemplateId.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.textMailTemplateId.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    public MailTemplateInfo getInputData() {
        return this.inputData;
    }

    protected void setInputData(MailTemplateInfo mailTemplate) {
        this.inputData = mailTemplate;
        if (mailTemplate.getMailTemplateId() != null) {
            this.textMailTemplateId.setText(mailTemplate.getMailTemplateId());
        }
        if (mailTemplate.getDescription() != null) {
            this.textDescription.setText(mailTemplate.getDescription());
        }
        if (mailTemplate.getSubject() != null) {
            this.textSubject.setText(mailTemplate.getSubject());
        }
        if (mailTemplate.getBody() != null) {
            this.textBody.setText(mailTemplate.getBody());
        }
        if (mailTemplate.getOwnerRoleId() != null) {
            this.m_ownerRoleId.setText(mailTemplate.getOwnerRoleId());
        }
        if (this.mode == 2) {
            this.textMailTemplateId.setEnabled(false);
            this.textDescription.setEnabled(false);
            this.textSubject.setEnabled(false);
            this.textBody.setEnabled(false);
        }
        this.update();
    }

    private MailTemplateInfo createInputData() {
        MailTemplateInfo info = new MailTemplateInfo();
        if (this.textMailTemplateId.getText() != null && !"".equals(this.textMailTemplateId.getText().trim())) {
            info.setMailTemplateId(this.textMailTemplateId.getText());
        }
        if (this.textDescription.getText() != null && !"".equals(this.textDescription.getText().trim())) {
            info.setDescription(this.textDescription.getText());
        }
        if (this.textSubject.getText() != null && !"".equals(this.textSubject.getText().trim())) {
            info.setSubject(this.textSubject.getText());
        }
        if (this.textBody.getText() != null && !"".equals(this.textBody.getText().trim())) {
            info.setBody(this.textBody.getText());
        }
        if (this.m_ownerRoleId.getText().length() > 0) {
            info.setOwnerRoleId(this.m_ownerRoleId.getText());
        }
        return info;
    }

    @Override
    protected ValidateResult validate() {
        this.inputData = this.createInputData();
        if (this.inputData != null) {
            return super.validate();
        }
        return this.validateResult;
    }

    @Override
    protected boolean action() {
        boolean result = false;
        MailTemplateInfo info = this.getInputData();
        if (info != null) {
            String errMessage = "";
            Object[] args = new String[]{info.getMailTemplateId()};
            if (this.mode == 0) {
                try {
                    result = MailTemplateEndpointWrapper.addMailTemplate(info);
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.notify.mail.1", (Object[])args));
                }
                catch (MailTemplateDuplicate_Exception mailTemplateDuplicate_Exception) {
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.notify.mail.10", (Object[])args));
                }
                catch (Exception e) {
                    if (e instanceof InvalidRole_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    } else {
                        errMessage = ", " + e.getMessage();
                    }
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.notify.mail.2", (Object[])args)) + errMessage));
                }
            } else if (this.mode == 1) {
                try {
                    result = MailTemplateEndpointWrapper.modifyMailTemplate(info);
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.notify.mail.3", (Object[])args));
                }
                catch (Exception e) {
                    if (e instanceof InvalidRole_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    } else {
                        errMessage = ", " + e.getMessage();
                    }
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.notify.mail.4", (Object[])args)) + errMessage));
                }
            }
        }
        return result;
    }

    @Override
    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.mode != 2) {
            super.createButtonsForButtonBar(parent);
        } else {
            this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
        }
    }
}

