/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.util;

import com.clustercontrol.util.EndpointManager;
import com.clustercontrol.ws.notify.HinemosUnknown_Exception;
import com.clustercontrol.ws.notify.InvalidRole_Exception;
import com.clustercontrol.ws.notify.InvalidSetting_Exception;
import com.clustercontrol.ws.notify.InvalidUserPass_Exception;
import com.clustercontrol.ws.notify.NotifyDuplicate_Exception;
import com.clustercontrol.ws.notify.NotifyEndpoint;
import com.clustercontrol.ws.notify.NotifyInfo;
import com.clustercontrol.ws.notify.NotifyNotFound_Exception;
import java.util.List;
import javax.xml.ws.WebServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NotifyEndpointWrapper {
    private static Log m_log = LogFactory.getLog(NotifyEndpointWrapper.class);

    public static boolean addNotify(NotifyInfo notifyInfo) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, NotifyDuplicate_Exception, InvalidSetting_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getNotifyEndpoint()) {
            try {
                NotifyEndpoint endpoint = (NotifyEndpoint)endpointSetting.getEndpoint();
                return endpoint.addNotify(notifyInfo);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("addNotify(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static boolean modifyNotify(NotifyInfo notifyInfo) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, NotifyDuplicate_Exception, InvalidSetting_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getNotifyEndpoint()) {
            try {
                NotifyEndpoint endpoint = (NotifyEndpoint)endpointSetting.getEndpoint();
                return endpoint.modifyNotify(notifyInfo);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("modifyNotify(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static boolean deleteNotify(String notifyId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, NotifyNotFound_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getNotifyEndpoint()) {
            try {
                NotifyEndpoint endpoint = (NotifyEndpoint)endpointSetting.getEndpoint();
                return endpoint.deleteNotify(notifyId);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("deleteNotify(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<String> checkNotifyId(String notifyId) throws HinemosUnknown_Exception, NotifyNotFound_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getNotifyEndpoint()) {
            try {
                NotifyEndpoint endpoint = (NotifyEndpoint)endpointSetting.getEndpoint();
                return endpoint.checkNotifyId(notifyId);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("checkNotifyId(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static NotifyInfo getNotify(String notifyId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, NotifyNotFound_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getNotifyEndpoint()) {
            try {
                NotifyEndpoint endpoint = (NotifyEndpoint)endpointSetting.getEndpoint();
                return endpoint.getNotify(notifyId);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getNotify(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<NotifyInfo> getNotifyList() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, NotifyNotFound_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getNotifyEndpoint()) {
            try {
                NotifyEndpoint endpoint = (NotifyEndpoint)endpointSetting.getEndpoint();
                return endpoint.getNotifyList();
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getNotifyList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<NotifyInfo> getNotifyListByOwnerRole(String ownerRoleId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, NotifyNotFound_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getNotifyEndpoint()) {
            try {
                NotifyEndpoint endpoint = (NotifyEndpoint)endpointSetting.getEndpoint();
                return endpoint.getNotifyListByOwnerRole(ownerRoleId);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getNotifyListByOwnerRole(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void setNotifyStatus(String notifyId, boolean validFlag) throws NotifyNotFound_Exception, NotifyDuplicate_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getNotifyEndpoint()) {
            try {
                NotifyEndpoint endpoint = (NotifyEndpoint)endpointSetting.getEndpoint();
                endpoint.setNotifyStatus(notifyId, validFlag);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("setNotifyStatus(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }
}

