/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.action;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.performance.util.CollectorEndpointWrapper;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.ws.collector.HinemosUnknown_Exception;
import com.clustercontrol.ws.collector.InvalidRole_Exception;
import com.clustercontrol.ws.collector.InvalidUserPass_Exception;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RecordDataWriter
implements Runnable {
    private static Log m_log = LogFactory.getLog(RecordDataWriter.class);
    private String monitorId;
    private String facilityId;
    private boolean headerFlag;
    private boolean archiveFlag;
    private String folderName = null;
    private int progress;
    private int dlMaxWait = 1;
    private int waitSleep = 1000;
    private int waitCount = 60;
    private boolean canceled;
    private String cancelMessage = null;

    public RecordDataWriter(String monitorId, String facilityId, boolean headerFlag, boolean archiveFlag, String folderName) {
        this.monitorId = monitorId;
        this.facilityId = facilityId;
        this.headerFlag = headerFlag;
        this.archiveFlag = archiveFlag;
        this.folderName = folderName;
        m_log.debug((Object)("RecordDataWriter() monitorId = " + monitorId + ", facilityId = " + facilityId + ", headerFlag = " + headerFlag + ", archiveFlag = " + archiveFlag + ", folderName = " + folderName));
        this.dlMaxWait = ClusterControlPlugin.getDefault().getPreferenceStore().getInt("downloadMaxWait");
        this.waitCount = this.dlMaxWait * 60 * 1000 / this.waitSleep;
        m_log.debug((Object)("RecordDataWriter() dlMaxWait = " + this.dlMaxWait + ", waitCount = " + this.waitCount));
    }

    public List<String> export() {
        List<String> downloadFileList = null;
        try {
            downloadFileList = CollectorEndpointWrapper.createPerfFile(this.monitorId, this.facilityId, this.headerFlag, this.archiveFlag);
        }
        catch (HinemosUnknown_Exception e) {
            this.setCancelMessage(String.valueOf(Messages.getString("GET_COLLECTEDDATA_ERROR_MESSAGE")) + ":" + e.getMessage());
            this.setCanceled(true);
            m_log.warn((Object)"export()", (Throwable)e);
        }
        catch (InvalidUserPass_Exception e) {
            this.setCancelMessage(String.valueOf(Messages.getString("GET_COLLECTEDDATA_ERROR_MESSAGE")) + ":" + e.getMessage());
            this.setCanceled(true);
            m_log.warn((Object)"export()", (Throwable)e);
        }
        catch (InvalidRole_Exception e) {
            this.setCancelMessage(String.valueOf(Messages.getString("GET_COLLECTEDDATA_ERROR_MESSAGE")) + ":" + e.getMessage());
            this.setCanceled(true);
            m_log.warn((Object)"export()", (Throwable)e);
        }
        if (m_log.isDebugEnabled()) {
            if (downloadFileList == null || downloadFileList.size() == 0) {
                m_log.debug((Object)"export() downloadFileList is null");
            } else {
                for (String fileName : downloadFileList) {
                    m_log.debug((Object)("export() downloadFileName = " + fileName));
                }
            }
        }
        return downloadFileList;
    }

    public void download(String fileName) {
        m_log.debug((Object)("download() downloadFileName = " + fileName));
        m_log.info((Object)("download perf file  = " + fileName));
        FileOutputStream fileOutputStream = null;
        DataHandler handler = null;
        try {
            m_log.info((Object)("download perf file = " + fileName + ", waitCount = " + this.waitCount));
            int i = 0;
            while (i < this.waitCount) {
                if (!this.canceled) {
                    Thread.sleep(this.waitSleep);
                    m_log.debug((Object)("download perf file = " + fileName + ", create check. count = " + i));
                    handler = CollectorEndpointWrapper.downloadPerfFile(fileName);
                    if (handler != null) {
                        m_log.info((Object)("download perf file = " + fileName + ", created !"));
                        break;
                    }
                }
                ++i;
            }
            if (handler == null) {
                m_log.info((Object)"download handler is null");
                this.setCancelMessage(String.valueOf(Messages.getString("GET_COLLECTEDDATA_ERROR_MESSAGE")) + ": cannot create collected data for client-timeout");
                this.setCanceled(true);
                return;
            }
            try {
                File file = new File(String.valueOf(this.folderName) + "\\" + fileName);
                file.createNewFile();
                fileOutputStream = new FileOutputStream(file);
                handler.writeTo((OutputStream)fileOutputStream);
                m_log.info((Object)("download perf file  = " + fileName + ", succeed !"));
                m_log.debug((Object)"download() succeed!");
            }
            catch (HinemosUnknown_Exception e) {
                this.setCancelMessage(String.valueOf(Messages.getString("GET_COLLECTEDDATA_ERROR_MESSAGE")) + ":" + e.getMessage());
                this.setCanceled(true);
                m_log.warn((Object)"download()", (Throwable)e);
            }
            catch (InvalidUserPass_Exception e) {
                this.setCancelMessage(String.valueOf(Messages.getString("GET_COLLECTEDDATA_ERROR_MESSAGE")) + ":" + e.getMessage());
                this.setCanceled(true);
                m_log.warn((Object)"download()", (Throwable)e);
            }
            catch (InvalidRole_Exception e) {
                this.setCancelMessage(String.valueOf(Messages.getString("GET_COLLECTEDDATA_ERROR_MESSAGE")) + ":" + e.getMessage());
                this.setCanceled(true);
                m_log.warn((Object)"download()", (Throwable)e);
            }
            catch (InterruptedException e) {
                this.setCancelMessage(String.valueOf(Messages.getString("GET_COLLECTEDDATA_ERROR_MESSAGE")) + ":" + e.getMessage());
                this.setCanceled(true);
                m_log.warn((Object)"download()", (Throwable)e);
            }
            catch (IOException e) {
                this.setCancelMessage(String.valueOf(Messages.getString("GET_COLLECTEDDATA_ERROR_WRITE")) + ":" + e.getMessage());
                this.setCanceled(true);
                m_log.warn((Object)"download()", (Throwable)e);
            }
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                this.setCancelMessage(String.valueOf(Messages.getString("GET_COLLECTEDDATA_ERROR_WRITE")) + ":" + e.getMessage());
                this.setCanceled(true);
                m_log.warn((Object)"download()", (Throwable)e);
            }
        }
    }

    public void delete(List<String> fileNameList) {
        m_log.debug((Object)"delete()");
        try {
            if (fileNameList != null && fileNameList.size() > 0) {
                m_log.debug((Object)"delete() run delete!");
                CollectorEndpointWrapper.deletePerfFile(new ArrayList<String>(fileNameList));
            }
            m_log.debug((Object)"delete() succeed!");
        }
        catch (HinemosUnknown_Exception e) {
            this.setCancelMessage(String.valueOf(Messages.getString("GET_COLLECTEDDATA_ERROR_DELETE")) + ":" + e.getMessage());
            this.setCanceled(true);
            m_log.warn((Object)"delete()", (Throwable)e);
        }
        catch (InvalidUserPass_Exception e) {
            this.setCancelMessage(String.valueOf(Messages.getString("GET_COLLECTEDDATA_ERROR_DELETE")) + ":" + e.getMessage());
            this.setCanceled(true);
            m_log.warn((Object)"delete()", (Throwable)e);
        }
        catch (InvalidRole_Exception e) {
            this.setCancelMessage(String.valueOf(Messages.getString("GET_COLLECTEDDATA_ERROR_DELETE")) + ":" + e.getMessage());
            this.setCanceled(true);
            m_log.warn((Object)"delete()", (Throwable)e);
        }
    }

    @Override
    public void run() {
        this.progress = 0;
        List<String> downloadFileList = null;
        if (this.canceled) {
            this.progress = 100;
            return;
        }
        downloadFileList = this.export();
        if (downloadFileList == null || downloadFileList.size() == 0) {
            if (!this.isCanceled()) {
                this.setCancelMessage(Messages.getString("INSUFFICIENT_DATA"));
                this.setCanceled(true);
            }
            return;
        }
        for (String downloadFile : downloadFileList) {
            if (this.canceled) {
                this.delete(downloadFileList);
                this.progress = 100;
                return;
            }
            this.download(downloadFile);
            this.progress += 50 / downloadFileList.size();
        }
        this.delete(downloadFileList);
        this.progress = 100;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setCanceled(boolean b) {
        this.canceled = b;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public String getCancelMessage() {
        return this.cancelMessage;
    }

    public void setCancelMessage(String cancelMessage) {
        this.cancelMessage = cancelMessage;
    }
}

