/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.util;

import com.clustercontrol.repository.util.RepositoryEndpointWrapper;
import com.clustercontrol.util.EndpointManager;
import com.clustercontrol.ws.collector.CollectedDataSet;
import com.clustercontrol.ws.collector.CollectorEndpoint;
import com.clustercontrol.ws.collector.CollectorItemInfo;
import com.clustercontrol.ws.collector.HashMapInfo;
import com.clustercontrol.ws.collector.HinemosUnknown_Exception;
import com.clustercontrol.ws.collector.InvalidRole_Exception;
import com.clustercontrol.ws.collector.InvalidUserPass_Exception;
import com.clustercontrol.ws.collector.PerformanceDataSettings;
import com.clustercontrol.ws.collector.PerformanceFilterInfo;
import com.clustercontrol.ws.collector.PerformanceListInfo;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;
import javax.xml.ws.WebServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CollectorEndpointWrapper {
    private static Log m_log = LogFactory.getLog(CollectorEndpointWrapper.class);

    public static PerformanceDataSettings getPerformanceGraphInfo(String monitorId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectorEndpoint()) {
            try {
                CollectorEndpoint endpoint = (CollectorEndpoint)endpointSetting.getEndpoint();
                PerformanceDataSettings settings = endpoint.getPerformanceGraphInfo(monitorId);
                RepositoryEndpointWrapper.setTreeParent(settings.getFacilityTreeItem());
                return settings;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getPerformanceGraphInfo(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static CollectedDataSet getRecordCollectedDataFromIdList(List<String> facilityIdList, List<CollectorItemInfo> itemInfoList, Long startDate, Long endDate) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectorEndpoint()) {
            try {
                CollectorEndpoint endpoint = (CollectorEndpoint)endpointSetting.getEndpoint();
                return endpoint.getRecordCollectedDataFromIdList(facilityIdList, itemInfoList, startDate, endDate);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getRecordCollectedDataFromIdList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<CollectorItemInfo> getAvailableCollectorItemList(String facilityId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectorEndpoint()) {
            try {
                CollectorEndpoint endpoint = (CollectorEndpoint)endpointSetting.getEndpoint();
                return endpoint.getAvailableCollectorItemList(facilityId);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getAvailableCollectorItemList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<PerformanceListInfo> getPerformanceList() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectorEndpoint()) {
            try {
                CollectorEndpoint endpoint = (CollectorEndpoint)endpointSetting.getEndpoint();
                return endpoint.getPerformanceList();
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getPerformanceList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<PerformanceListInfo> getPerformanceList(PerformanceFilterInfo condition) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectorEndpoint()) {
            try {
                CollectorEndpoint endpoint = (CollectorEndpoint)endpointSetting.getEndpoint();
                return endpoint.getPerformanceListByCondition(condition);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getPerformanceList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static HashMapInfo getItemCodeMap() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectorEndpoint()) {
            try {
                CollectorEndpoint endpoint = (CollectorEndpoint)endpointSetting.getEndpoint();
                return endpoint.getItemCodeMap();
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getItemCodeMap(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<String> createPerfFile(String monitorId, String facilityId, boolean header, boolean archive) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectorEndpoint()) {
            try {
                CollectorEndpoint endpoint = (CollectorEndpoint)endpointSetting.getEndpoint();
                return endpoint.createPerfFile(monitorId, facilityId, header, archive);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("createPerformanceFile(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static DataHandler downloadPerfFile(String fileName) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectorEndpoint()) {
            try {
                CollectorEndpoint endpoint = (CollectorEndpoint)endpointSetting.getEndpoint();
                return endpoint.downloadPerfFile(fileName);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("downloadPerformanceFile(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void deletePerfFile(ArrayList<String> fileNameList) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getCollectorEndpoint()) {
            try {
                CollectorEndpoint endpoint = (CollectorEndpoint)endpointSetting.getEndpoint();
                endpoint.deletePerfFile(fileNameList);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("deletePerformanceFile(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }
}

