/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.util;

import com.clustercontrol.performance.action.RecordController;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.ws.collector.CollectorItemInfo;
import com.clustercontrol.ws.collector.CollectorItemTreeItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CollectorItemCodeFactory {
    private static Log log = LogFactory.getLog(CollectorItemCodeFactory.class);
    public static HashMap<String, CollectorItemTreeItem> m_codeTable = null;

    private CollectorItemCodeFactory() {
    }

    public static void init() {
        m_codeTable = new RecordController().getItemCodeTreeMap();
    }

    public static String getItemName(String itemCode) {
        if (m_codeTable == null) {
            CollectorItemCodeFactory.init();
        }
        if (m_codeTable.get(itemCode).getItemCodeData() != null) {
            return m_codeTable.get(itemCode).getItemCodeData().getItemName();
        }
        return null;
    }

    public static String getFullItemName(String itemCode, String displayName) {
        log.debug((Object)("getFullItemName() itemCode = " + itemCode + ", displayName = " + displayName));
        if (m_codeTable == null) {
            CollectorItemCodeFactory.init();
        }
        String name = displayName == null || displayName.equals(Messages.getString("NONE")) || displayName.equals("") ? CollectorItemCodeFactory.getItemName(itemCode) : String.valueOf(CollectorItemCodeFactory.getItemName(itemCode)) + "[" + displayName + "]";
        log.debug((Object)("getFullItemName() name = " + name));
        return name;
    }

    public static String getFullItemName(CollectorItemInfo collectorItemInfo) {
        String itemCode;
        if (m_codeTable == null) {
            CollectorItemCodeFactory.init();
        }
        if (CollectorItemCodeFactory.isDeviceSupport(itemCode = collectorItemInfo.getItemCode())) {
            return CollectorItemCodeFactory.getFullItemName(collectorItemInfo.getItemCode(), collectorItemInfo.getDisplayName());
        }
        return CollectorItemCodeFactory.getItemName(itemCode);
    }

    public static String getMeasure(String itemCode) {
        if (m_codeTable == null) {
            CollectorItemCodeFactory.init();
        }
        if (m_codeTable.get(itemCode).getItemCodeData() != null) {
            return m_codeTable.get(itemCode).getItemCodeData().getMeasure();
        }
        return null;
    }

    public static boolean isRangeFixed(String itemCode, int graphType) {
        log.debug((Object)("isRangeFixed() itemCode = " + itemCode + ", graphType = " + graphType));
        boolean isFixed = false;
        if (m_codeTable == null) {
            CollectorItemCodeFactory.init();
        }
        if (m_codeTable.get(itemCode) == null) {
            isFixed = false;
        } else {
            boolean rangeFixed = false;
            if (m_codeTable.get(itemCode).getItemCodeData() != null) {
                rangeFixed = m_codeTable.get(itemCode).getItemCodeData().getGraphRange() == 1;
            }
            isFixed = rangeFixed && graphType != 1;
        }
        log.debug((Object)("isRangeFixed() isFixed = " + isFixed));
        return isFixed;
    }

    public static boolean isDeviceSupport(String itemCode) {
        if (m_codeTable == null) {
            CollectorItemCodeFactory.init();
        }
        if (m_codeTable.get(itemCode).getItemCodeData() != null) {
            return m_codeTable.get(itemCode).getItemCodeData().getDeviceSupport() == 1;
        }
        return false;
    }

    public static List<String> getSubItemCode(String itemCode) {
        if (m_codeTable == null) {
            CollectorItemCodeFactory.init();
        }
        ArrayList<String> itemCodeList = new ArrayList<String>();
        CollectorItemTreeItem treeItem = m_codeTable.get(itemCode);
        String subItemCode = null;
        for (CollectorItemTreeItem item : treeItem.getChildren()) {
            if (item.getItemCodeData() != null) {
                subItemCode = item.getItemCodeData().getItemCode();
            }
            itemCodeList.add(subItemCode);
        }
        return itemCodeList;
    }
}

