/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.port.dialog;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.monitor.run.dialog.CommonMonitorNumericDialog;
import com.clustercontrol.monitor.util.MonitorSettingEndpointWrapper;
import com.clustercontrol.notify.util.NotifyGroupIdGenerator;
import com.clustercontrol.port.bean.PortRunCountConstant;
import com.clustercontrol.port.bean.PortRunIntervalConstant;
import com.clustercontrol.port.bean.ProtocolConstant;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.MonitorDuplicate_Exception;
import com.clustercontrol.ws.monitor.MonitorInfo;
import com.clustercontrol.ws.monitor.PortCheckInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PortCreateDialog
extends CommonMonitorNumericDialog {
    private static Log m_log = LogFactory.getLog(PortCreateDialog.class);
    private Text m_textTimeout = null;
    private Button m_radioTCP = null;
    private Button m_radioService = null;
    private Combo m_comboService = null;
    private Text m_textPortNo = null;
    private Combo m_comboRunCount = null;
    private Combo m_comboRunInterval = null;

    public PortCreateDialog(Shell parent) {
        super(parent);
    }

    public PortCreateDialog(Shell parent, String monitorId, boolean updateFlg) {
        super(parent);
        this.monitorId = monitorId;
        this.updateFlg = updateFlg;
    }

    @Override
    protected void customizeDialog(Composite parent) {
        this.item1 = Messages.getString((String)"response.time.milli.sec");
        this.item2 = Messages.getString((String)"response.time.milli.sec");
        super.customizeDialog(parent);
        this.m_numericValueInfo.setInfoWarnText("0", "1000", "1000", "3000");
        this.shell.setText(Messages.getString((String)"dialog.port.create.modify"));
        Label label = null;
        GridData gridData = null;
        Group groupCheckRule = new Group((Composite)this.groupRule, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupCheckRule.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupCheckRule.setLayoutData((Object)gridData);
        groupCheckRule.setText(Messages.getString((String)"check.rule"));
        this.m_radioTCP = new Button((Composite)groupCheckRule, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_radioTCP.setLayoutData((Object)gridData);
        this.m_radioTCP.setText(Messages.getString((String)"tcp.connect.only"));
        this.m_radioTCP.setSelection(true);
        this.m_radioService = new Button((Composite)groupCheckRule, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_radioService.setLayoutData((Object)gridData);
        this.m_radioService.setText(Messages.getString((String)"service.protocol"));
        this.m_radioService.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PortCreateDialog.this.setEnabledComboService(PortCreateDialog.this.m_radioService.getSelection());
            }
        });
        this.m_comboService = new Combo((Composite)groupCheckRule, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboService.setLayoutData((Object)gridData);
        this.m_comboService.add(ProtocolConstant.STRING_PROTOCOL_FTP);
        this.m_comboService.add(ProtocolConstant.STRING_PROTOCOL_SMTP);
        this.m_comboService.add(ProtocolConstant.STRING_PROTOCOL_SMTPS);
        this.m_comboService.add(ProtocolConstant.STRING_PROTOCOL_POP3);
        this.m_comboService.add(ProtocolConstant.STRING_PROTOCOL_POP3S);
        this.m_comboService.add(ProtocolConstant.STRING_PROTOCOL_IMAP);
        this.m_comboService.add(ProtocolConstant.STRING_PROTOCOL_IMAPS);
        this.m_comboService.add(ProtocolConstant.STRING_PROTOCOL_NTP);
        this.m_comboService.add(ProtocolConstant.STRING_PROTOCOL_DNS);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"port.number")) + " : ");
        this.m_textPortNo = new Text((Composite)groupCheckRule, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textPortNo.setLayoutData((Object)gridData);
        this.m_textPortNo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                PortCreateDialog.this.update();
            }
        });
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 9;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"trial.run.count")) + " : ");
        this.m_comboRunCount = new Combo((Composite)groupCheckRule, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboRunCount.setLayoutData((Object)gridData);
        this.m_comboRunCount.add(PortRunCountConstant.STRING_COUNT_01);
        this.m_comboRunCount.add(PortRunCountConstant.STRING_COUNT_02);
        this.m_comboRunCount.add(PortRunCountConstant.STRING_COUNT_03);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 9;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"trial.run.interval")) + " : ");
        this.m_comboRunInterval = new Combo((Composite)groupCheckRule, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboRunInterval.setLayoutData((Object)gridData);
        this.m_comboRunInterval.add(PortRunIntervalConstant.STRING_SEC_01);
        this.m_comboRunInterval.add(PortRunIntervalConstant.STRING_SEC_02);
        this.m_comboRunInterval.add(PortRunIntervalConstant.STRING_SEC_05);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 9;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"time.out")) + " : ");
        this.m_textTimeout = new Text((Composite)groupCheckRule, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textTimeout.setLayoutData((Object)gridData);
        this.m_textTimeout.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                PortCreateDialog.this.update();
            }
        });
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"milli.sec"));
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 7;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.itemName.setText(Messages.getString((String)"response.time"));
        this.measure.setText(Messages.getString((String)"time.msec"));
        this.adjustDialog();
        MonitorInfo info = null;
        if (this.monitorId == null) {
            info = new MonitorInfo();
            this.setInfoInitialValue(info);
        } else {
            try {
                info = MonitorSettingEndpointWrapper.getMonitor(this.monitorId, "MON_PRT");
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (Exception e) {
                m_log.warn((Object)("customizeDialog(), " + e.getMessage()), (Throwable)e);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
        }
        this.setInputData(info);
    }

    protected void setEnabledComboService(boolean enable) {
        this.m_comboService.setEnabled(enable);
    }

    @Override
    public void update() {
        super.update();
        if (this.m_textPortNo.getEnabled() && "".equals(this.m_textPortNo.getText())) {
            this.m_textPortNo.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textPortNo.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_textTimeout.getEnabled() && "".equals(this.m_textTimeout.getText())) {
            this.m_textTimeout.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textTimeout.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    @Override
    protected void setInputData(MonitorInfo monitor) {
        super.setInputData(monitor);
        this.inputData = monitor;
        PortCheckInfo portInfo = monitor.getPortCheckInfo();
        if (portInfo.getServiceId() == null || portInfo.getServiceId().equals("001")) {
            this.m_radioTCP.setSelection(true);
            this.m_radioService.setSelection(false);
            this.setEnabledComboService(this.m_radioService.getSelection());
        } else {
            this.m_radioTCP.setSelection(false);
            this.m_radioService.setSelection(true);
            this.setEnabledComboService(this.m_radioService.getSelection());
            this.m_comboService.setText(ProtocolConstant.typeToString((String)portInfo.getServiceId()));
        }
        if (portInfo.getPortNo() != null) {
            this.m_textPortNo.setText(portInfo.getPortNo().toString());
        }
        if (portInfo.getRunCount() != null) {
            this.m_comboRunCount.setText(PortRunCountConstant.typeToString((int)portInfo.getRunCount()));
        }
        if (portInfo.getRunInterval() != null) {
            this.m_comboRunInterval.setText(PortRunIntervalConstant.typeToString((int)portInfo.getRunInterval()));
        }
        if (portInfo.getTimeout() != null) {
            this.m_textTimeout.setText(portInfo.getTimeout().toString());
        }
        this.m_numericValueInfo.setInputData(monitor);
    }

    @Override
    protected MonitorInfo createInputData() {
        super.createInputData();
        if (this.validateResult != null) {
            return null;
        }
        this.monitorInfo.setMonitorTypeId("MON_PRT");
        PortCheckInfo portInfo = new PortCheckInfo();
        if (this.m_radioTCP.getSelection()) {
            portInfo.setServiceId("001");
        } else if (this.m_radioService.getSelection() && this.m_comboService.getText() != null && !"".equals(this.m_comboService.getText().trim())) {
            portInfo.setServiceId(ProtocolConstant.stringToType((String)this.m_comboService.getText()));
        }
        if (this.m_textPortNo.getText() != null && !"".equals(this.m_textPortNo.getText().trim())) {
            try {
                Integer portNo = new Integer(this.m_textPortNo.getText().trim());
                portInfo.setPortNo(portNo);
            }
            catch (NumberFormatException numberFormatException) {
                this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.port.8"));
                return null;
            }
        }
        if (this.m_comboRunCount.getText() != null && !"".equals(this.m_comboRunCount.getText().trim())) {
            portInfo.setRunCount(Integer.valueOf(PortRunCountConstant.stringToType((String)this.m_comboRunCount.getText())));
        }
        if (this.m_comboRunInterval.getText() != null && !"".equals(this.m_comboRunInterval.getText().trim())) {
            portInfo.setRunInterval(Integer.valueOf(PortRunIntervalConstant.stringToType((String)this.m_comboRunInterval.getText())));
        }
        if (!"".equals(this.m_textTimeout.getText().trim())) {
            try {
                Integer timeout = new Integer(this.m_textTimeout.getText().trim());
                portInfo.setTimeout(timeout);
            }
            catch (NumberFormatException numberFormatException) {
                this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.port.3"));
                return null;
            }
        }
        this.monitorInfo.setPortCheckInfo(portInfo);
        this.validateResult = this.m_numericValueInfo.createInputData(this.monitorInfo);
        if (this.validateResult != null) {
            return null;
        }
        this.monitorInfo.setNotifyGroupId(NotifyGroupIdGenerator.createNotifyGroupId((String)"MON_PRT", (String)this.monitorInfo.getMonitorId()));
        this.validateResult = this.m_notifyInfo.createInputData(this.monitorInfo);
        if (this.validateResult != null) {
            if (this.validateResult.getID() == null) {
                if (!this.displayQuestion(this.validateResult)) {
                    this.validateResult = null;
                    return null;
                }
            } else {
                return null;
            }
        }
        return this.monitorInfo;
    }

    @Override
    protected boolean action() {
        boolean result;
        block14: {
            result = false;
            MonitorInfo info = this.inputData;
            if (info != null) {
                Object[] args = new String[]{info.getMonitorId()};
                if (!this.updateFlg) {
                    try {
                        result = MonitorSettingEndpointWrapper.addMonitor(info);
                        if (result) {
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.monitor.33", (Object[])args));
                            break block14;
                        }
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.monitor.34", (Object[])args));
                    }
                    catch (MonitorDuplicate_Exception monitorDuplicate_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.monitor.53", (Object[])args));
                    }
                    catch (Exception e) {
                        String errMessage = "";
                        if (e instanceof InvalidRole_Exception) {
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                        } else {
                            errMessage = ", " + e.getMessage();
                        }
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.monitor.34", (Object[])args)) + errMessage));
                    }
                } else {
                    String errMessage = "";
                    try {
                        result = MonitorSettingEndpointWrapper.modifyMonitor(info);
                    }
                    catch (InvalidRole_Exception invalidRole_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    }
                    catch (Exception e) {
                        errMessage = ", " + e.getMessage();
                    }
                    if (result) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.monitor.35", (Object[])args));
                    } else {
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.monitor.36", (Object[])args)) + errMessage));
                    }
                }
            }
        }
        return result;
    }

    @Override
    protected void setInfoInitialValue(MonitorInfo monitor) {
        super.setInfoInitialValue(monitor);
        PortCheckInfo portCheckInfo = new PortCheckInfo();
        portCheckInfo.setPortNo(Integer.valueOf(80));
        portCheckInfo.setRunCount(Integer.valueOf(1));
        portCheckInfo.setRunInterval(Integer.valueOf(1000));
        portCheckInfo.setTimeout(Integer.valueOf(5000));
        monitor.setPortCheckInfo(portCheckInfo);
    }
}

