/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.action;

import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.util.NodePropertyUtil;
import com.clustercontrol.repository.util.RepositoryEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.ws.repository.InvalidRole_Exception;
import com.clustercontrol.ws.repository.NodeInfo;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;

public class GetNodeList {
    private static Log m_log = LogFactory.getLog(GetNodeList.class);

    public List<NodeInfo> getAll() {
        List<NodeInfo> records = null;
        try {
            records = RepositoryEndpointWrapper.getNodeListAll();
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("getAll(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        return records;
    }

    public List<NodeInfo> get(Property property) {
        PropertyUtil.deletePropertyDefine(property);
        List<NodeInfo> records = null;
        try {
            NodeInfo nodeInfo = null;
            nodeInfo = NodePropertyUtil.property2node(property);
            records = RepositoryEndpointWrapper.getFilterNodeList(nodeInfo);
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("get(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        return records;
    }
}

