/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.composite;

import com.clustercontrol.repository.action.GetAgentListTableDefine;
import com.clustercontrol.repository.util.RepositoryEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.repository.AgentStatusInfo;
import com.clustercontrol.ws.repository.InvalidRole_Exception;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class AgentListComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(AgentListComposite.class);
    private CommonTableViewer tableViewer = null;
    private Label statuslabel = null;
    private Label totalLabel = null;

    public AgentListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.statuslabel = new Label((Composite)this, 16384);
        this.statuslabel.setText("");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.statuslabel.setLayoutData((Object)gridData);
        Table table = new Table((Composite)this, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetAgentListTableDefine.get(), 0, 1);
        this.totalLabel = new Label((Composite)this, 131072);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.totalLabel.setLayoutData((Object)gridData);
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public Table getTable() {
        return this.tableViewer.getTable();
    }

    public void update() {
        List<AgentStatusInfo> list = null;
        this.statuslabel.setText("");
        try {
            list = RepositoryEndpointWrapper.getAgentStatusList();
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("update(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        if (list == null) {
            list = new ArrayList<AgentStatusInfo>();
        }
        ArrayList listInput = new ArrayList();
        for (AgentStatusInfo node : list) {
            ArrayList<Object> aList = new ArrayList<Object>();
            aList.add(node.getFacilityId());
            aList.add(node.getFacilityName());
            aList.add(new Date(node.getStartupTime()));
            aList.add(new Date(node.getLastLogin()));
            aList.add(node.getMultiplicity());
            if (node.isNewFlag()) {
                aList.add(Messages.getString((String)"done"));
            } else {
                aList.add(Messages.getString((String)"not.yet"));
            }
            listInput.add(aList);
        }
        this.tableViewer.setInput(listInput);
        Object[] args = new String[]{String.valueOf(list.size())};
        String message = null;
        message = Messages.getString((String)"records", (Object[])args);
        this.totalLabel.setText(message);
    }
}

