/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.dialog;

import com.clustercontrol.accesscontrol.util.LocalSession;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.repository.composite.NodeFilterComposite;
import com.clustercontrol.repository.dialog.NodeFilterDialog;
import com.clustercontrol.repository.util.RepositoryEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.repository.InvalidRole_Exception;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class NodeAssignDialog
extends CommonDialog {
    private final int sizeX = 500;
    private final int sizeY = 500;
    private String facilityId = "";
    private NodeFilterComposite nodeList = null;
    private List<String> filterItems = null;

    public NodeAssignDialog(Shell parent, String facilityId) {
        super(parent);
        this.facilityId = facilityId;
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    @Override
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.repository.select.nodes"));
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout((Layout)layout);
        this.nodeList = new NodeFilterComposite(parent, 0, this.facilityId, true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        this.nodeList.setLayoutData(gridData);
        this.nodeList.update();
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        shell.pack();
        shell.setSize(new Point(shell.getSize().x, 500));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 11, Messages.getString((String)"filter"), false);
        this.getButton(11).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NodeFilterDialog dialog = new NodeFilterDialog(NodeAssignDialog.this.getShell());
                if (dialog.open() == 0) {
                    NodeAssignDialog.this.nodeList.update(dialog.getInputData());
                }
            }
        });
        super.createButtonsForButtonBar(parent);
    }

    @Override
    protected ValidateResult validate() {
        return super.validate();
    }

    public String getScopeId() {
        return this.facilityId;
    }

    public List<String> getFilterItems() {
        return this.filterItems;
    }

    @Override
    protected String getOkButtonText() {
        return Messages.getString((String)"assign");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    @Override
    protected void okPressed() {
        StructuredSelection selection = (StructuredSelection)this.nodeList.getTableViewer().getSelection();
        Object[] items = selection.toArray();
        if (items != null) {
            int size = items.length;
            this.filterItems = new ArrayList<String>();
            int i = 0;
            while (i < size) {
                this.filterItems.add((String)((ArrayList)items[i]).get(0));
                ++i;
            }
        }
        try {
            RepositoryEndpointWrapper.assignNodeScope(this.facilityId, this.filterItems);
            LocalSession.doCheck();
            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.repository.6"));
            super.okPressed();
        }
        catch (Exception e) {
            String errMessage = "";
            if (e instanceof InvalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            } else {
                errMessage = ", " + e.getMessage();
            }
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.repository.7")) + errMessage));
        }
    }
}

