/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.util;

import com.clustercontrol.util.EndpointManager;
import com.clustercontrol.ws.access.UsedOwnerRole_Exception;
import com.clustercontrol.ws.repository.AgentStatusInfo;
import com.clustercontrol.ws.repository.FacilityDuplicate_Exception;
import com.clustercontrol.ws.repository.FacilityInfo;
import com.clustercontrol.ws.repository.FacilityNotFound_Exception;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import com.clustercontrol.ws.repository.HinemosUnknown_Exception;
import com.clustercontrol.ws.repository.InvalidRole_Exception;
import com.clustercontrol.ws.repository.InvalidSetting_Exception;
import com.clustercontrol.ws.repository.InvalidUserPass_Exception;
import com.clustercontrol.ws.repository.NodeInfo;
import com.clustercontrol.ws.repository.RepositoryEndpoint;
import com.clustercontrol.ws.repository.RepositoryTableInfo;
import com.clustercontrol.ws.repository.ScopeInfo;
import com.clustercontrol.ws.repository.UsedFacility_Exception;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.WebServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryEndpointWrapper {
    private static Log m_log = LogFactory.getLog(RepositoryEndpointWrapper.class);

    public static List<RepositoryTableInfo> getPlatformList() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                return endpoint.getPlatformList();
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getPlatformList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void addNode(NodeInfo nodeInfo) throws FacilityDuplicate_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                endpoint.addNode(nodeInfo);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("addNode(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void addScope(String parentId, ScopeInfo scopeInfo) throws FacilityDuplicate_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                endpoint.addScope(parentId, scopeInfo);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("addScope(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void assignNodeScope(String scopeId, List<String> nodeId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                endpoint.assignNodeScope(scopeId, nodeId);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("assignNodeScope(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void deleteNode(String facilityId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UsedFacility_Exception, UsedOwnerRole_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                endpoint.deleteNode(facilityId);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("deleteNode(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void deleteScope(String facilityId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, UsedFacility_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                endpoint.deleteScope(facilityId);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("deleteScope(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static Long getLastUpdate() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                return endpoint.getLastUpdate();
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getLastUpdate(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static NodeInfo getNode(String facilityId) throws FacilityNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                return endpoint.getNode(facilityId);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getNode(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static NodeInfo getNodePropertyBySNMP(String ipAddress, int port, String community, String version) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                return endpoint.getNodePropertyBySNMP(ipAddress, port, community, version);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getNodePropertyBySNMP(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<String> getNodeScopeList(String facilityId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                return endpoint.getNodeScopeList(facilityId);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getNodeScopeList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<FacilityInfo> getFacilityList(String facilityId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                return endpoint.getFacilityList(facilityId);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getScopeList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static ScopeInfo getScope(String facilityId) throws FacilityNotFound_Exception, HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                return endpoint.getScope(facilityId);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getScope(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void modifyNode(NodeInfo nodeInfo) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                endpoint.modifyNode(nodeInfo);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("modifyNode(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void modifyScope(ScopeInfo scopeInfo) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                endpoint.modifyScope(scopeInfo);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("modifyScope(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void releaseNodeScope(String scopeId, List<String> nodeIdList) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception, InvalidSetting_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                endpoint.releaseNodeScope(scopeId, nodeIdList);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("releaseNodeScope(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<RepositoryTableInfo> getCollectorSubPlatformTableInfoList() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                return endpoint.getCollectorSubPlatformTableInfoList();
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getCollectorSubPlatformMstList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<String> getVmProtocolMstList() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                return endpoint.getVmProtocolMstList();
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getVmProtocolMstList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<RepositoryTableInfo> getHostList() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                return endpoint.getHostList();
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getHostList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<NodeInfo> getOpenFlowSwitchList() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                return endpoint.getOpenFlowSwitchList();
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getOpenFlowSwitchList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static String getFacilityPath(String facilityId, String parentFacilityId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                return endpoint.getFacilityPath(facilityId, parentFacilityId);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getFacilityPath(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<NodeInfo> getFilterNodeList(NodeInfo nodeInfo) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                return endpoint.getFilterNodeList(nodeInfo);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getFilterNodeList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<NodeInfo> getNodeList(String parentFacilityId, int level) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                return endpoint.getNodeList(parentFacilityId, level);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getNodeList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<NodeInfo> getNodeListAll() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                return endpoint.getNodeListAll();
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getNodeListAll(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<AgentStatusInfo> getAgentStatusList() throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                return endpoint.getAgentStatusList();
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getAgentStatusList(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static FacilityTreeItem getFacilityTree(String ownerRoleId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                FacilityTreeItem item = endpoint.getFacilityTree(ownerRoleId);
                RepositoryEndpointWrapper.setTreeParent(item);
                return item;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getFacilityTree(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static FacilityTreeItem getExecTargetFacilityTreeByFacilityId(String facilityId, String ownerRoleId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                FacilityTreeItem item = endpoint.getExecTargetFacilityTreeByFacilityId(facilityId, ownerRoleId);
                if (item != null) {
                    RepositoryEndpointWrapper.setTreeParent(item);
                }
                return item;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getExecTargetFacilityTreeByFacilityId(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static FacilityTreeItem getNodeFacilityTree(String ownerRoleId) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                FacilityTreeItem item = endpoint.getNodeFacilityTree(ownerRoleId);
                if (item != null) {
                    RepositoryEndpointWrapper.setTreeParent(item);
                }
                return item;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("getNodeFacilityTree(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void setTreeParent(FacilityTreeItem item) {
        List children = item.getChildren();
        for (FacilityTreeItem child : children) {
            child.setParent(item);
            RepositoryEndpointWrapper.setTreeParent(child);
        }
    }

    public static void restartAgent(ArrayList<String> facilityIdList, int agentCommand) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                endpoint.restartAgent(facilityIdList, agentCommand);
                return;
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("restartAgent(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static String replaceNodeVariable(String facilityId, String replaceObject) throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
        WebServiceException wse = null;
        for (EndpointManager.EndpointSetting endpointSetting : EndpointManager.getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint)endpointSetting.getEndpoint();
                return endpoint.replaceNodeVariable(facilityId, replaceObject);
            }
            catch (WebServiceException e) {
                wse = e;
                m_log.warn((Object)("replaceNodeVariable(), " + e.getMessage()), (Throwable)e);
                EndpointManager.changeEndpoint();
            }
        }
        throw wse;
    }
}

