/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.view;

import com.clustercontrol.repository.composite.AgentListComposite;
import com.clustercontrol.view.CommonViewPart;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class AgentListView
extends CommonViewPart {
    public static final String ID = "com.clustercontrol.repository.view.AgentListView";
    private AgentListComposite composite = null;

    @Override
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.composite = new AgentListComposite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.composite.setLayoutData(gridData);
        this.createContextMenu();
        this.composite.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IViewPart viewPart = page.findView(AgentListView.ID);
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (viewPart != null && selection != null) {
                    AgentListView view = (AgentListView)((Object)viewPart.getAdapter(AgentListView.class));
                    view.setEnabledAction(selection.size(), event.getSelection());
                }
            }
        });
        this.update();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AgentListView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.composite.getTable());
        this.composite.getTable().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem agentRestartAction = (ActionContributionItem)toolbar.find("com.clustercontrol.repository.view.action.AgentRestartAction");
        ActionContributionItem agentUpdateAction = (ActionContributionItem)toolbar.find("com.clustercontrol.repository.view.action.AgentUpdateAction");
        manager.add(agentRestartAction.getAction());
        manager.add(agentUpdateAction.getAction());
    }

    public AgentListComposite getComposite() {
        return this.composite;
    }

    public void update() {
        this.composite.update();
    }

    public void setEnabledAction(int num, ISelection selection) {
        super.setEnabledAction("com.clustercontrol.repository.view.action.AgentRestartAction", selection);
        super.setEnabledAction("com.clustercontrol.repository.view.action.AgentUpdateAction", selection);
        if (num > 0) {
            super.setEnabledAction("com.clustercontrol.repository.view.action.AgentRestartAction", true);
            super.setEnabledAction("com.clustercontrol.repository.view.action.AgentUpdateAction", true);
        } else {
            super.setEnabledAction("com.clustercontrol.repository.view.action.AgentRestartAction", false);
            super.setEnabledAction("com.clustercontrol.repository.view.action.AgentUpdateAction", false);
        }
    }
}

