/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.view;

import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.composite.NodeListComposite;
import com.clustercontrol.repository.composite.action.NodeListSelectionChangedListener;
import com.clustercontrol.view.CommonViewPart;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class NodeListView
extends CommonViewPart {
    public static final String ID = "com.clustercontrol.repository.view.NodeListView";
    private NodeListComposite composite = null;
    private Property condition = null;

    @Override
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.composite = new NodeListComposite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.composite.setLayoutData(gridData);
        this.createContextMenu();
        this.composite.getTableViewer().addSelectionChangedListener(new NodeListSelectionChangedListener());
        this.update();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NodeListView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.composite.getTable());
        this.composite.getTable().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem nodeAddAction = (ActionContributionItem)toolbar.find("com.clustercontrol.repository.view.action.NodeAddAction");
        ActionContributionItem nodeModifyAction = (ActionContributionItem)toolbar.find("com.clustercontrol.repository.view.action.NodeModifyAction");
        ActionContributionItem nodeDeleteAction = (ActionContributionItem)toolbar.find("com.clustercontrol.repository.view.action.NodeDeleteAction");
        ActionContributionItem nodeCopyAction = (ActionContributionItem)toolbar.find("com.clustercontrol.repository.view.action.NodeCopyAction");
        ActionContributionItem programExecutionAction = (ActionContributionItem)toolbar.find("com.clustercontrol.repository.view.action.ProgramExecutionAction");
        manager.add(nodeAddAction.getAction());
        manager.add(nodeModifyAction.getAction());
        manager.add(nodeDeleteAction.getAction());
        manager.add((IContributionItem)new Separator());
        manager.add(nodeCopyAction.getAction());
        manager.add(programExecutionAction.getAction());
    }

    public NodeListComposite getComposite() {
        return this.composite;
    }

    public void update(Property condition) {
        this.condition = condition;
        this.update();
    }

    public void update() {
        this.composite.update(this.condition);
    }

    public void setEnabledAction(int num, ISelection selection) {
        super.setEnabledAction("com.clustercontrol.repository.view.action.NodeCopyAction", selection);
        super.setEnabledAction("com.clustercontrol.repository.view.action.NodeDeleteAction", selection);
        super.setEnabledAction("com.clustercontrol.repository.view.action.NodeModifyAction", selection);
        super.setEnabledAction("com.clustercontrol.repository.view.action.ProgramExecutionAction", selection);
        if (num > 0) {
            super.setEnabledAction("com.clustercontrol.repository.view.action.NodeCopyAction", true);
            super.setEnabledAction("com.clustercontrol.repository.view.action.NodeDeleteAction", true);
            super.setEnabledAction("com.clustercontrol.repository.view.action.NodeModifyAction", true);
            super.setEnabledAction("com.clustercontrol.repository.view.action.ProgramExecutionAction", true);
        } else {
            super.setEnabledAction("com.clustercontrol.repository.view.action.NodeCopyAction", false);
            super.setEnabledAction("com.clustercontrol.repository.view.action.NodeDeleteAction", false);
            super.setEnabledAction("com.clustercontrol.repository.view.action.NodeModifyAction", false);
            super.setEnabledAction("com.clustercontrol.repository.view.action.ProgramExecutionAction", false);
        }
    }
}

