/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.view;

import com.clustercontrol.accesscontrol.util.LocalSession;
import com.clustercontrol.accesscontrol.util.ObjectBean;
import com.clustercontrol.composite.FacilityTreeComposite;
import com.clustercontrol.repository.composite.ScopeListComposite;
import com.clustercontrol.repository.composite.action.FacilityTreeSelectionChangedListener;
import com.clustercontrol.repository.composite.action.ScopeListSelectionChangedListener;
import com.clustercontrol.view.ObjectPrivilegeTargetListView;
import com.clustercontrol.view.ScopeListBaseView;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class ScopeListView
extends ScopeListBaseView
implements ObjectPrivilegeTargetListView {
    public static final String ID = "com.clustercontrol.repository.view.ScopeListView";
    private ScopeListComposite composite = null;

    @Override
    protected Composite createListContents(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.composite = new ScopeListComposite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.composite.setLayoutData(gridData);
        this.createContextMenu();
        super.getScopeTreeComposite().getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)new FacilityTreeSelectionChangedListener());
        this.composite.getTableViewer().addSelectionChangedListener(new ScopeListSelectionChangedListener(this.composite));
        this.update();
        return this.composite;
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ScopeListView.this.fillContextMenu(manager);
            }
        });
        Menu treeMenu = menuManager.createContextMenu((Control)this.getScopeTreeComposite().getTree());
        this.getScopeTreeComposite().getTree().setMenu(treeMenu);
        Menu listMenu = menuManager.createContextMenu((Control)this.composite.getTable());
        this.composite.getTable().setMenu(listMenu);
    }

    private void fillContextMenu(IMenuManager manager) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem scopeAddAction = (ActionContributionItem)toolbar.find("com.clustercontrol.repository.view.action.ScopeAddAction");
        ActionContributionItem scopeModifyAction = (ActionContributionItem)toolbar.find("com.clustercontrol.repository.view.action.ScopeModifyAction");
        ActionContributionItem scopeDeleteAction = (ActionContributionItem)toolbar.find("com.clustercontrol.repository.view.action.ScopeDeleteAction");
        ActionContributionItem nodeAssignAction = (ActionContributionItem)toolbar.find("com.clustercontrol.repository.view.action.NodeAllocateAction");
        ActionContributionItem nodeReleaseAction = (ActionContributionItem)toolbar.find("com.clustercontrol.repository.view.action.NodeReleaseAction");
        ActionContributionItem objPrivilege = (ActionContributionItem)toolbar.find("com.clustercontrol.repository.view.action.ScopeObjectPrivilegeAction");
        manager.add(scopeAddAction.getAction());
        manager.add(scopeModifyAction.getAction());
        manager.add(scopeDeleteAction.getAction());
        manager.add(nodeAssignAction.getAction());
        manager.add(nodeReleaseAction.getAction());
        manager.add((IContributionItem)new Separator());
        manager.add(objPrivilege.getAction());
    }

    @Override
    protected void doSelectTreeItem(FacilityTreeItem item) {
        this.composite.update(item);
    }

    @Override
    public void update() {
        LocalSession.doCheck();
    }

    @Override
    public Object getAdapter(Class cls) {
        if (cls.isInstance(this)) {
            return this;
        }
        return super.getAdapter(cls);
    }

    public void setEnabledAction(boolean builtin, int type, ISelection selection, boolean notReferFlg) {
        if (builtin) {
            super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeAddAction", false);
            super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeModifyAction", false);
            super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeDeleteAction", false);
            super.setEnabledAction("com.clustercontrol.repository.view.action.NodeAllocateAction", false);
            super.setEnabledAction("com.clustercontrol.repository.view.action.NodeReleaseAction", false);
            super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeObjectPrivilegeAction", selection);
        } else if (this.getScopeTreeComposite().getTree().isFocusControl() || this.composite.getTable().isFocusControl()) {
            super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeAddAction", selection);
            super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeModifyAction", selection);
            super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeDeleteAction", selection);
            super.setEnabledAction("com.clustercontrol.repository.view.action.NodeAllocateAction", selection);
            super.setEnabledAction("com.clustercontrol.repository.view.action.NodeReleaseAction", selection);
            super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeObjectPrivilegeAction", selection);
            if (type == 2) {
                super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeAddAction", true);
                super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeModifyAction", false);
                super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeDeleteAction", false);
                super.setEnabledAction("com.clustercontrol.repository.view.action.NodeAllocateAction", false);
                super.setEnabledAction("com.clustercontrol.repository.view.action.NodeReleaseAction", false);
                super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeObjectPrivilegeAction", false);
            } else if (type == 0) {
                super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeAddAction", !notReferFlg);
                super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeModifyAction", !notReferFlg);
                super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeDeleteAction", !notReferFlg);
                super.setEnabledAction("com.clustercontrol.repository.view.action.NodeAllocateAction", !notReferFlg);
                super.setEnabledAction("com.clustercontrol.repository.view.action.NodeReleaseAction", !notReferFlg);
                super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeObjectPrivilegeAction", !notReferFlg);
            } else if (type == 1) {
                super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeAddAction", false);
                super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeModifyAction", false);
                super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeDeleteAction", false);
                super.setEnabledAction("com.clustercontrol.repository.view.action.NodeAllocateAction", false);
                super.setEnabledAction("com.clustercontrol.repository.view.action.NodeReleaseAction", false);
                super.setEnabledAction("com.clustercontrol.repository.view.action.ScopeObjectPrivilegeAction", false);
            }
        }
    }

    @Override
    public List<ObjectBean> getSelectedObjectBeans() {
        FacilityTreeItem item = this.getSelectedScopeItem();
        ArrayList<ObjectBean> objectBeans = new ArrayList<ObjectBean>();
        if (item != null) {
            String objectId = item.getData().getFacilityId();
            String objectType = "PLT_REP";
            ObjectBean objectBean = new ObjectBean(objectType, objectId);
            objectBeans.add(objectBean);
        }
        return objectBeans;
    }

    @Override
    public String getSelectedOwnerRoleId() {
        FacilityTreeItem item = this.getSelectedScopeItem();
        String ownerRoleId = null;
        if (item != null) {
            ownerRoleId = item.getData().getOwnerRoleId();
        }
        return ownerRoleId;
    }

    private FacilityTreeItem getSelectedScopeItem() {
        FacilityTreeComposite tree = this.getScopeTreeComposite();
        ScopeListComposite list = (ScopeListComposite)this.getListComposite();
        FacilityTreeItem item = null;
        if (tree.getTree().isFocusControl()) {
            item = tree.getSelectItem();
        } else if (list.getTableViewer().getTable().isFocusControl()) {
            item = list.getSelectItem();
        }
        if (item != null && item.getData().getFacilityType() == 0) {
            return item;
        }
        return null;
    }
}

