/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.view.action;

import com.clustercontrol.repository.bean.AgentCommandConstant;
import com.clustercontrol.repository.util.RepositoryEndpointWrapper;
import com.clustercontrol.repository.view.AgentListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.repository.InvalidRole_Exception;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class AgentUpdateAction
implements IViewActionDelegate {
    private static Log m_log = LogFactory.getLog(AgentUpdateAction.class);
    public static final String ID = "com.clustercontrol.repository.view.action.AgentUpdateAction";
    private IViewPart viewPart;

    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    public void run(IAction action) {
        AgentListView view = (AgentListView)((Object)this.viewPart.getAdapter(AgentListView.class));
        StructuredSelection selection = (StructuredSelection)view.getComposite().getTableViewer().getSelection();
        List selectionList = selection.toList();
        if (selectionList.size() == 0) {
            return;
        }
        ArrayList<String> facilityIdList = new ArrayList<String>();
        String message = "";
        boolean flag = true;
        for (Object o : selectionList) {
            List list = (List)o;
            String facilityId = null;
            String facilityName = null;
            if (list != null) {
                facilityId = (String)list.get(0);
                facilityName = (String)list.get(1);
                facilityIdList.add(facilityId);
            }
            if (facilityId == null) {
                return;
            }
            if ("".equals(facilityId)) {
                return;
            }
            if (flag) {
                flag = false;
            } else {
                message = String.valueOf(message) + ", ";
            }
            message = String.valueOf(message) + facilityName + "(" + facilityId + ")";
        }
        Object[] args = new String[]{message};
        if (!MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.repository.45", (Object[])args))) {
            m_log.debug((Object)"cancel");
            return;
        }
        try {
            RepositoryEndpointWrapper.restartAgent(facilityIdList, AgentCommandConstant.UPDATE);
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("run(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

