/*

 Copyright (C) 2008 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.notify.bean;

import javax.xml.bind.annotation.XmlType;

/**
 * 通知メール情報を保持するクラスです。
 * 
 * @author yosuke
 * @version 3.0.0
 * @since 3.0.0
 */
@XmlType(namespace = "http://notify.ws.clustercontrol.com")
public class NotifyMailInfo  extends NotifyInfoDetail
{
	private static final long serialVersionUID = -5089086735470199399L;


	/**
	 * メールテンプレートID。
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	private String m_mailTemplateId;

	/** メールアドレス（セミコロン区切り）。 */
	private String m_mailAddress;


	/**
	 * コンストラクタ。
	 */
	public NotifyMailInfo() {
	}

	/**
	 * コンストラクタ。
	 * 
	 * @param notifyId 通知ID
	 * @param priority 重要度
	 * @param mailTemplateId メールテンプレートID
	 * @param validFlg イベント通知フラグ
	 * @param mailAddress メールアドレス（セミコロン区切り）
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.ValidConstant
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public NotifyMailInfo(
			String notifyId,
			Integer priority,
			String mailTemplateId,
			Integer validFlg,
			String mailAddress ) {

		setNotifyId(notifyId);
		setPriority(priority);
		setMailTemplateId(mailTemplateId);
		setValidFlg(validFlg);
		setMailAddress(mailAddress);
	}

	/**
	 * コンストラクタ。
	 * 
	 * @param otherData コピー元の通知情報
	 */
	public NotifyMailInfo( NotifyMailInfo otherData ) {
		setNotifyId(otherData.getNotifyId());
		setPriority(otherData.getPriority());
		setMailTemplateId(otherData.getMailTemplateId());
		setValidFlg(otherData.getValidFlg());
		setMailAddress(otherData.getMailAddress());

	}


	/**
	 * メールテンプレートIDを返します。
	 * 
	 * @return メールテンプレートID
	 * 
	 */
	public String getMailTemplateId() {
		return this.m_mailTemplateId;
	}

	/**
	 * メールテンプレートIDを設定します。
	 * 
	 * @param mailTamplateId メールテンプレートID
	 * 
	 */
	public void setMailTemplateId(String  mailTemplateId) {
		this.m_mailTemplateId = mailTemplateId;
	}

	/**
	 * メールアドレスを返します。
	 * 
	 * @return メールアドレス（セミコロン区切り）
	 */
	public String getMailAddress() {
		return this.m_mailAddress;
	}

	/**
	 * メールアドレスを設定します。
	 * 
	 * @param mailAddress メールアドレス（セミコロン区切り）
	 */
	public void setMailAddress( String mailAddress ) {
		this.m_mailAddress = mailAddress;
	}
}
