/*

Copyright (C) 2012 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.plugin.impl;

import java.util.HashSet;
import java.util.Set;

import com.clustercontrol.commons.util.HinemosProperties;
import com.clustercontrol.ws.managercli.ManagerCliEndpoint;

/**
 * JAX-WSによるWEBサービスの初期化(publish)/停止(stop)を制御するHinemos本体管理用プラグイン.
 * 
 * @author takahatat
 */
public class WebServiceManagementPlugin extends WebServicePlugin {

	@Override
	public Set<String> getDependency() {
		Set<String> dependency = new HashSet<String>();
		dependency.add(WebServiceJobMapPlugin.class.getName());
		dependency.add(WebServiceNodeMapPlugin.class.getName());
		return dependency;
	}

	@Override
	public void create() {
		final String addressPrefix = HinemosProperties.getProperty("common.ws.management.address" , "http://0.0.0.0:8080");
		publish(addressPrefix, "/HinemosWS/ManagementEndpoint", new ManagerCliEndpoint());
	}

	@Override
	public void activate() {
		// do nothing
	}

}
